<?php
session_start();  
if(!isset($_SESSION['name']) || $_SESSION['user_type']!="admin") {
    header("Location: login.php");
}

// Include Functions File
include("../process/functions.php");

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>DDxRx Admin Panel | List of Admins</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Other JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/nurse-script.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/adminlte.min.js"></script>

    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="dist/css/custom.css">

</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
  <?php
    include('includes/header.php');
    include('includes/sidebar.php');
  ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Bulk Upload
        <small style="display: block">Upload Excel to create users in bulk</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Nurses</li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <!-- Small boxes (Stat box) -->
          <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

                <!-- Upload Form -->
                <form action="process/xls-upload.php" medthod="POST" class="xls-upload-form" style="margin-bottom: 50px">
                    <div class="col-md-2">
                        <input type="file" name="fileToUpload" id="fileToUpload" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
                    </div>
                    <div class="col-md-2">
                        <input type="submit" value="Upload Image" name="submit">
                    </div>
                </form>
                <!-- Upload Form -->

                <!-- Bulk Users -->
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>Username</th>
                        <th>Email</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Action</th>
                    </tr>
                  </thead>

                  <tbody>

                    <?php

                      // Set Connection
                      $conn = ddxrxDBConnect();

                      // SQL Query
                      $sql = "SELECT * FROM patients JOIN all_users ON patients.user_id = all_users.userid WHERE patients.auto_generated = 'true' AND all_users.groupid ='100018'";

                      $result = $conn->query($sql);
                      
                      if ($result->num_rows > 0) {

                        // output data of each row
                        while($row = $result->fetch_assoc()) {
                          echo '<tr>';
                          echo '<td>'.$row['username'].'</td>';
                          echo '<td>'.$row['email_address'].'</td>';
                          echo '<td>'.$row['patient_fname'].'</td>';
                          echo '<td>'.$row['patient_lname'].'</td>';
                          echo '<td><a href="#">Delete</a></td>';
                          echo '</tr>';
                        }

                      } else {
                        echo '<tr>';
                        echo '<td colspan="5">No data yet for this group</td>';
                        echo '</tr>';
                      }

                      $conn->close();

                    ?>
                    
                  </tbody>
                  
                </table>
                <!-- Bulk Users -->

            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 2.4.0
    </div>
    <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- Custom JavaScript -->
<script src="dist/js/xls-upload.js"></script>

</body>
</html>
