<?php

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Change header output to JSON
header("Content-Type: application/json");

// Include functions
include('../process/functions.php');

// Check if there are post data
if(isset($_POST)) {

    if( !isset($_POST['user_id']) || !isset($_POST['user_type']) || !isset($_POST['group_id']) || !isset($_POST['room_number']) || !isset($_POST['first_name']) || !isset($_POST['last_name']) || !isset($_POST['face_pattern']) ){

        // Set status code
        http_response_code(400);

        $output = array(
            'status_code' => '400',
            'status' => 'Bad Request',
            'message' => 'The server cannot or will not process the request due to missing parameters'
        );
        
    }else{

        // Generate 5 digit numbers
        $rand = rand(11111,99999);

        // Get post data
        $user_id = $_POST['user_id'];
        $user_type = $_POST['user_type'];
        $group_id = $_POST['group_id'];
        $room_number = $_POST['room_number'];
        $first_name = $_POST['first_name'];
        $last_name = $_POST['last_name'];
        $face_pattern = $_POST['face_pattern'];
        $face_id = $_POST['group_id'].'-'.$rand;

        // Main upload Folder
        $target_dir = "../face_files/";
        
        // Check if log_uploads folder exist
        if( is_dir( $target_dir ) == false ){
            mkdir( $target_dir );
        }
        
        // Get file Type
        $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
        $FileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
        
        // Set file name for the new uploaded file
        $fileName = md5(date('m-d-y-H-i-s')) .'.'. $FileType;
        
        // Set path for the new file
        $newFile = $target_dir . $fileName;
        
        // Set URL for the file name
        $filePath = 'https://'.$_SERVER['HTTP_HOST'].'/face_files/' . $fileName;
        
        // Check if file is an actual .txt/.log or fake file
        if($FileType == "jpg" || $FileType == "jpeg" || $FileType == "png" ) {
            
            // Check if file is too large
            if ($_FILES["fileToUpload"]["size"] > 500000) {

                // Set status code
                http_response_code(413);

                $output = array(
                    'status_code' => '413',
                    'status' => 'Payload Too Large',
                    'message' => 'Request entity is larger than limits defined by server.'
                );

            }else{
                
                if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $newFile)) {
                    
                    // Insert data into database
                    $sql = "INSERT INTO face_id (`user_id`, `user_type`, `group_id`, `room_number`, `first_name`, `last_name`, `file_path`, `file_name`, `face_id`, `face_pattern`) VALUES ('$user_id', '$user_type', '$group_id', '$room_number', '$first_name', '$last_name', '$filePath', '$fileName', '$face_id', '$face_pattern')";

                    if (ddxrxDBConnect()->query($sql) === TRUE) {

                        // Set status code
                        http_response_code(200);

                        $output = array(
                            'status_code' => '200',
                            'status' => 'success',
                            'message' => 'The file have been successfully uploaded',
                            'file_name' => $fileName,
                            'file_path' => $filePath,
                        );

                    } else {
                        
                        // Set status code
                        http_response_code(500);

                        $output = array(
                            'status_code' => '500',
                            'status' => 'Internal Server Error',
                            'message' => 'The server has encountered a situation it does not know how to handle.',
                            'error' => ddxrxDBConnect()->error
                        );
                    
                    }
                    
                } else {
                    
                    // Set status code
                    http_response_code(504);

                    $output = array(
                        'status_code' => '504',
                        'status' => 'Timed Out',
                        'message' => 'Request timed out'
                    );
                    
                }
                
            }
            
        } else {
            
            // Set status code
            http_response_code(415);

            $output = array(
                'status_code' => '415',
                'status' => 'Invalid File Type',
                'message' => 'Invalid file type, only .jpg, .jpeg and .png files allowed'
            );
            
        }
        
    }
    
}else{
    
    $output = array(
        'result' => false,
        'title' => 'No File',
        'desc' => 'No file selected, please upload a proper file.'
    );
    
}

echo json_encode($output);

?>