<?php

// Receives data as a JSON
$receiver_data = json_decode(file_get_contents('php://input'), true);

try{

    if (!empty($receiver_data)) {

        // Flag to track if any parameters are missing
        $missing_parameters = false;

        // List of expected keys
        $expected_keys = ['userid', 'igG', 'igA', 'igM', 'c3', 'c4', 'ch50', 'ana', 'rf', 'mmp-3', 'ss_a_ab', 'ss_b_ab', 'mpo_anca', 'pr3_anca', 'sil_2r'];

        // Run through the keys
        foreach ($expected_keys as $key) {
            if (!isset($receiver_data[$key])) {
                $missing_parameters = true;
                break; // Exit the loop if any key is missing
            }
        }

        if (!$missing_parameters) {

            // Generate SQL query
            $sql = "INSERT INTO `immunology` (";
            $values = "VALUES (";
            foreach ($expected_keys as $key) {
                $sql .= "`$key`, ";
                $values .= "'" . $receiver_data[$key] . "', ";
            }
            // Remove trailing comma and space
            $sql = rtrim($sql, ', ');
            $values = rtrim($values, ', ');
            $sql .= ") " . $values . ")";
            
            // Execute the SQL query here
            if (ddxrxDBConnect()->query($sql) === TRUE) {
                
                $output = array(
                    'result' => true,
                    'status_code' => '200',
                    'data' => "Data inserted successfully"
                );

            }else{

                $output = array(
                    'result' => false,
                    'status_code' => '400',
                    'message' => "Error: " . $sql . " " . ddxrxDBConnect()->error
                );
            }
              
            ddxrxDBConnect()->close();
        
        }else{

            $output = array(
                'result' => false,
                'status_code' => '400',
                'message' => 'Bad request, there are 1 or more missing parameters to complete this process',
                'expected_keys' => $expected_keys
            );

        }

    }else{

        $output = array(
            'result' => false,
            'status_code' => '400',
            'message' => 'Bad request, there are 1 or more missing parameters to complete this process'
        );

    }

}catch (Exception $e) {

    $output = array(
        'result' => false,
        'status_code' => '400',
        'message' => 'An error occurred: ' . $e->getMessage()
    );

}