<?php

/**
 * This API will get provider_id based on unique_id. The api will expect only 1 parameter, unique_id.
 */

// Output header for JSON
header('Content-Type: application/json');

// Include functions file
include('../process/functions.php');

// Try block
try{

    // Get input JSON
    $inputJSON = file_get_contents('php://input');

    // Decode JSON
    $input = json_decode($inputJSON, true);

    // If input is not empty
    if(!empty($input)) {

        // If all required parameters are present
        if( isset($input['unique_id']) ){

            // Get unique_id
            $unique_id = $input['unique_id'];

            // SQL Query
            $sql = "SELECT * FROM all_users WHERE `unique_id` = '$unique_id' && `user_type` = '2' LIMIT 1";

            // Execute query
            $result = ddxrxDBConnect()->query($sql);

            // Associative array
            $row = $result -> fetch_assoc();
            
            // If row is not empty
            if (!empty($row)) {
                
                // Output
                $output = array(
                    'result' => true,
                    'provider_id' => $row['userid'],
                    'desc' => 'The Physician details match our database records for the unique_id: ' . $unique_id
                );

            } else {
                
                // Output
                $output = array(
                    'result' => false,
                    'desc' => 'Physician details not found.'
                );

            }

            // Free result set
            $result -> free_result();

            // Close Connection
            ddxrxDBConnect()->close();

        }else{

            // Output
            $output = array(
                'status_code' => '422',
                'title' => 'Missing Parameters',
                'message' => 'The request sent by client was incomplete. One or more parameters are missing.'
            );

        }

    }else{

        // Output
        $output = array(
            'status_code' => '422',
            'title' => 'Missing Parameters',
            'message' => 'The request sent by client was incomplete. One or more parameters are missing.'
        );

    }

} catch (Exception $e) {
    
    // Output
    $output = array(
        'status_code' => '500',
        'title' => 'Internal Server Error',
        'message' => 'Opps! Something went wrong in our backend. Please try again later.',
        'error' => 'An error occurred: ' . $e->getMessage()
    );

}

// Output Response
echo json_encode($output);