<?php

// Include functions file
include('../process/functions.php');

// Set Content to json
header('Content-Type: application/json');

// Request Type
$request_type = $_SERVER['REQUEST_METHOD'];

// Register output variable
$output = array();

if($request_type == 'POST'){

    $payload = json_decode(file_get_contents('php://input'), true);

    if (isset($payload['major'])) {
        $table_name = $payload['major'];
    
        if (isset($payload['minor']) && isset($payload['user_id'])) {
            $column_name = $payload['minor'];
            $user_id = $payload['user_id'];
    
            $sql = "SELECT `$column_name` FROM `$table_name` WHERE `userid` = '$user_id' ORDER BY `id` DESC LIMIT 1;";
        } else {
            $sql = "SELECT * FROM `$table_name` ORDER BY `id` DESC LIMIT 1";
        }
    
        try {
            $result = ddxrxDBConnect()->query($sql);
            $data = array();
    
            if ($result->num_rows > 0) {
                $data = array();
                $columns = ""; // Initialize string to hold formatted column names and values
    
                // Fetch column names and values for the first row
                if ($row = $result->fetch_assoc()) {
                    // Exclude some fields
                    unset($row['id']);
    
                    // Filter out specified columns and their values
                    foreach ($row as $key => $value) {
                        if ($key !== 'userid' && $key !== 'created_at') {
                            $columns .= ucfirst($key) . ": " . $value . ", "; // Format column name and value
                        }
                    }
                    $columns = rtrim($columns, ", "); // Remove trailing comma and space
    
                    // Push formatted row data into the array
                    array_push($data, $row);
                }
    
                // Output data of each remaining row
                while ($row = $result->fetch_assoc()) {
                    // Exclude some fields
                    unset($row['id']);
    
                    // Push formatted row data into the array
                    array_push($data, $row);
                }
    
                // Determine the text message
                $text = isset($payload['minor']) ? 'Your test results are: ' : '';
    
                $output = array(
                    'result' => true,
                    'status_code' => '200',
                    'title' => "200 OK",
                    'desc' => "Great news! We've found records matching your request. Here are the details you were looking for. If you need further assistance, feel free to reach out.",
                    'text' => 'Your test results are: ' . $columns,
                    'data' => $data
                );
            } else {
                $output = array(
                    'result' => false,
                    'status_code' => 204,
                    'title' => "204 No Content.",
                    'desc' => "Did not find any records"
                );
            }
        } catch (Exception $e) {
            $output = array(
                'result' => false,
                'status_code' => 500,
                'error' => "500 Internal Server Error",
                'desc' => "An error occurred: " . $e->getMessage()
            );
        }
    } else {
        $output = array(
            'result' => false,
            'status_code' => 400,
            'error' => "400 Bad Request",
            'desc' => "One or more parameter is missing"
        );
    }
    

}else{

    $output = array(
        'result' => false,
        'status_code' => 405,
        'error' => "405 Method Not Allowed",
        'desc' => "Request type needs to be POST"
    );

}

echo json_encode($output);

?>
