<?php

// Enable error reporting for debugging (Remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set the content type to JSON
header('Content-Type: application/json');

// Include functions
include('../process/functions.php');

// Include required libraries
require_once '../vendor/phpmailer/phpmailer/class.phpmailer.php';
require_once '../vendor/phpmailer/phpmailer/class.smtp.php';

// Define your API Key
$apiKeyName = 'X-API-KEY';
$apiKeyValue = 'f23c4d5e8a9b0c12d3e4f5g6h7i8j9k0l1m2n3o4p5q6r7s8t9u0v1w2x3y4z5a6'; // Replace this with your actual secure API Key

// Function to validate the API Key
function isApiKeyValid()
 {
    global $apiKeyName, $apiKeyValue;

    // Get all headers
    $headers = function_exists('getallheaders') ? getallheaders() : [];
    $normalizedHeaders = [];
    foreach ($headers as $key => $value) {
        $normalizedHeaders[strtolower($key)] = $value; // Normalize to lowercase
    }

    // Validate API Key
    return isset($normalizedHeaders[strtolower($apiKeyName)]) && trim($normalizedHeaders[strtolower($apiKeyName)]) === $apiKeyValue;
}

// Function to send email
function sendEmail($emailId, $subject, $message) {
    $mail = new PHPMailer();
    try {
        // SMTP configuration
                $mail->IsSMTP();
                $mail->Host = 'mail.ddxrx.net'; // Replace with your SMTP host
                $mail->SMTPAuth = true;
                $mail->Username = 'contact@ddxrx.net'; // Replace with your SMTP username
                $mail->Password = '39530Lighthouse5347!'; // Replace with your SMTP password
                $mail->SMTPSecure = 'ssl'; // Use 'tls' or 'ssl' as per your SMTP server
                $mail->Port = 465; // Replace with your SMTP port

        // Email details
        $mail->SetFrom('contact@ddxrx.net', 'Device Email'); // Replace with your "from" address
        $mail->AddAddress($emailId);
        $mail->Subject = $subject;
        $mail->Body = $message;

        // Send email
        if (!$mail->Send()) {
            return ['success' => false, 'message' => 'Email could not be sent. Error: ' . $mail->ErrorInfo];
        }

        return ['success' => true, 'message' => 'Email sent successfully'];
    } catch (Exception $e) {
        return ['success' => false, 'message' => 'Email could not be sent. Exception: ' . $e->getMessage()];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_SERVER['CONTENT_TYPE']) && $_SERVER['CONTENT_TYPE'] === 'application/json') {
    // Validate API Key
    if (!isApiKeyValid()) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Unauthorized: Invalid API Key']);
        exit;
    }

    $inputData = file_get_contents('php://input');
    $data = json_decode($inputData);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Invalid JSON format: ' . json_last_error_msg()]);
        exit;
    }

    if (isset($data->emailId, $data->subject, $data->message)) {
        // Extract email data
        $emailId = $data->emailId;
        $subject = $data->subject;
        $message = $data->message;

        // Send email
        $response = sendEmail($emailId, $subject, $message);
        http_response_code($response['success'] ? 200 : 500);
        echo json_encode($response);
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Missing required fields: emailId, subject, or message']);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Invalid request method or content type']);
}

?>

