<?php

/**
 * 3 = patient
 * 2 = physician
 * 4 = nurse
 */

// Set the header to JSON type for the response
header('Content-Type: application/json');

// Include the functions file
include('../process/functions.php');

// Create a connection to the database
$conn = ddxrxDBConnect();

// Get user input in JSON format
$inputJSON = json_decode(file_get_contents('php://input'), true);

// Get version ID from function
$group_id = get_version();

// if the input is empty and the user has not provided any input
if (!empty($inputJSON)) {

    if( empty($inputJSON['user_type']) ){
        $output = array(
            'result' => false,
            'status_code' => '404',
            'message' => 'User type not provided'
        );
        echo json_encode($output);
        die();
    }

    if( empty($inputJSON['search_term']) ){
        $output = array(
            'result' => false,
            'status_code' => '404',
            'message' => 'Search term not provided'
        );
        echo json_encode($output);
        die();
    }

    // SQL query to get all users joined with patient table
    if( isset($inputJSON['user_type'] ) && $inputJSON['user_type'] == 'patient' ) {
        $searchterm = $inputJSON['search_term'];
        $sql = "SELECT `all_users`.`userid`, `all_users`.`email_address`, `patients`.`patient_fname` AS `first_name`, `patients`.`patient_lname` AS `last_name`
                FROM `all_users` 
                JOIN `patients` ON `all_users`.`userid` = `patients`.`user_id` 
                WHERE (`patients`.`patient_fname` LIKE '%$searchterm%' 
                OR `patients`.`patient_lname` LIKE '%$searchterm%' 
                OR `all_users`.`email_address` LIKE '%$searchterm%') 
                AND `all_users`.`groupid` = '$group_id'";
    } elseif( isset($inputJSON['user_type'] ) && $inputJSON['user_type'] == 'physician' ) {
        $searchterm = $inputJSON['search_term'];
        $sql = "SELECT `all_users`.`userid`, `all_users`.`email_address`, `physician`.`physician_fname` AS `first_name`, `physician`.`physician_lname` AS `last_name`
                FROM `all_users` 
                JOIN `physician` ON `all_users`.`userid` = `physician`.`user_id` 
                WHERE (`physician`.`physician_fname` LIKE '%$searchterm%' 
                OR `physician`.`physician_lname` LIKE '%$searchterm%' 
                OR `all_users`.`email_address` LIKE '%$searchterm%') 
                AND `all_users`.`groupid` = '$group_id'";
    } elseif( isset($inputJSON['user_type'] ) && $inputJSON['user_type'] == 'nurse' ) {
        $searchterm = $inputJSON['search_term'];
        $sql = "SELECT `all_users`.`userid`, `all_users`.`email_address`, `nurse`.`nurse_fname` AS `first_name`, `nurse`.`nurse_lname` AS `last_name`
                FROM `all_users` 
                JOIN `nurse` ON `all_users`.`userid` = `nurse`.`user_id` 
                WHERE (`nurse`.`nurse_fname` LIKE '%$searchterm%' 
                OR `nurse`.`nurse_lname` LIKE '%$searchterm%' 
                OR `all_users`.`email_address` LIKE '%$searchterm%') 
                AND `all_users`.`groupid` = '$group_id'";
    }

    // Execute the query
    $result = mysqli_query($conn, $sql);

    // Iterate through the result
    if ($result->num_rows > 0) {

        $jsonItems = array();

        while($row = $result->fetch_assoc()) {

            $tempArr = array(
                'user_id' => $row['userid'],
                'first_name' => $row['first_name'],
                'last_name' => $row['last_name'],
                'full_name' => $row['first_name'] . ' ' . $row['last_name'],
                'email' => $row['email_address'],
            );

            array_push($jsonItems, $tempArr);

        }

        $output = array(
            'result' => true,
            'user_type' => $inputJSON['user_type'],
            'data' => $jsonItems
        );

    } else {

        $output = array(
            'result' => false,
            'status_code' => '404',
            'message' => 'No users found'
        );

    }

} else {
    
    // Show error message if no input is provided
    $output = array(
        'result' => false,
        'status_code' => '404',
        'message' => 'No input provided'
    );

}

// Close the connection to the database
$conn->close();

// Return the output in JSON format
echo json_encode($output);