$(document).ready(function(){

    // Get monitor height
    var screenHeight = $(window).height();

    // Calculate Message List height for patients
    var formHeight = $('.form-container').outerHeight();
    var messageListHeight = screenHeight-formHeight;
    
    $('#messages').css('height', messageListHeight);

    // Calculate chat header height to be used for chat messages margin top
    var chatHeaderHeight = $('.chat-header').outerHeight();
    $('#messages').css('margin-top', chatHeaderHeight);

    // Calculate Message List height for providers
    var formHeightAlt = $('.form-container-alt').outerHeight();
    var messageListHeightAlt = screenHeight-formHeightAlt-chatHeaderHeight;

    $('.message-list.provider').css('height', messageListHeightAlt);
    $('.chat-wrapper').css('height', screenHeight);
    $('.sidebar').css('height', screenHeight);

    // Scroll down by default
    scrollToBottomChat();

    // Navigation Button
    $('.nav a').on('click', function(){
        $('.nav').find('.active').removeClass('active');
        $(this).addClass('active');

        if( $(this).html() == "Messages" ){
            $('.thread-list').removeClass('active');
            $('.thread-list.messages').addClass('active');
        }else if( $(this).html() == "Contacts" ){
            $('.thread-list').removeClass('active');
            $('.thread-list.contacts').addClass('active');
        }

    });

    // Set unread thread
    $('.thread-item').click(function(){
        
        var owner_id = $(this).data('user-id');

        $.ajax({
            url: "process/read_status.php",
            method: "POST",
            data: { owner_id: owner_id },
            success: function(data) {
                
                if( data.result == true ){

                    $('#user_id_'+owner_id+' .unreadIcon').remove();

                }

            }
        });

    });

    // Search Box
    $('.searchBox').on('keyup', function() {

        var search_keyword = $(this).val();
        // do something with the text

        if( search_keyword !== '' ){

            // Hide contact list
            $('.default-contact-list').hide();

            // Show search list
            $('.search-result-contact-list').show();

            $('.search-contact-list').html('<li class="label">Patients</li>');

            $.ajax({
                url: "process/search-patient.php",
                method: "POST",
                data: { search: search_keyword },
                success: function(data) {
                    
                    if( data.result == true ){

                        var items = data.items;

                        for (var i = 0; i < items.length; i++) {
                            console.log(items[i].patient_fname);
                            
                            $('.search-contact-list').append('<li class="thread-item"><a href="javascript:;" data-user-id="'+items[i].user_id+'" data-name="'+items[i].patient_fname+' '+items[i].patient_lname+'"><ion-icon name="person-circle-outline"></ion-icon><span>'+items[i].patient_fname+' '+items[i].patient_lname+'</span></a><div class="clear"></div></li>');

                        }

                    }

                }
            });

        }else{

            // Hide contact list
            $('.default-contact-list').show();

            // Show search list
            $('.search-result-contact-list').hide();
            $('.search-result-contact-list ul').html('');

        }

    });

});

// Initialize Nice Scroll
$(document).ready(function(){

    // For sidebar
    $(".sidebar").niceScroll({
        autohidemode: "leave",
        cursorcolor: "#8ec1f5",
        cursorborder: "none"
    });

    // For chat messasges
    $(".message-list").niceScroll({
        autohidemode: "false",
        cursorcolor: "#027eff",
        cursorborder: "none"
    });

});

// Scroll to bottom of chat when page is loaded
function scrollToBottomChat(){
    var element = document.getElementById("messages");
    var chatHeight = element.scrollHeight;
    $('#messages').animate({ scrollTop: chatHeight }, 100);
}

// Play Chat Sound
function chat_sound( soundType = 'chat' ){

    if( soundType == 'chat' ){
        var audio = new Audio('assets/others/chat-sound.mp3');
    }else if( soundType == 'chat-2' ){
        var audio = new Audio('assets/others/chat-sound-2.mp3');
    }else if( soundType == 'notification' ){
        var audio = new Audio('assets/others/join.mp3');
    }

    audio.play();
}

// Epoch to elapsed time
function timeSince(date) {

    // Assign date
    var seconds = Math.floor((new Date() - date) / 1000);

    // Get time lapsed in years
    var interval = seconds / 31536000;
    if (interval > 1) {
        // if years is 1, show year
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " year ago";
        }else{
            return Math.floor(interval) + " years ago";
        }
    }
    
    // Get time lapsed in months
    interval = seconds / 2592000;
    if (interval > 1) {
        // if months is 1, show month
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " month ago";
        }else{
            return Math.floor(interval) + " months ago";
        }
    }
    
    // Get time lapsed in days
    interval = seconds / 86400;
    if (interval > 1) {
        // if days is 1, show day
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " day ago";
        }else{
            return Math.floor(interval) + " days ago";
        }
    }

    // Get time lapsed in hours
    interval = seconds / 3600;
    if (interval > 1) {
        // If hours is 1, show hour
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " hour ago";
        }else{
            return Math.floor(interval) + " hours ago";
        }
    }

    // Get time lapsed in minutes
    interval = seconds / 60;
    if (interval > 1) {
        // If minutes is 1, show minute
        if(Math.floor(interval) == 1){
            return Math.floor(interval) + " minute ago";
        }else{
            return Math.floor(interval) + " minutes ago";
        }
    }

    // Get time lapsed in seconds
    // if seconds is 1, show second
    if(Math.floor(seconds) == 1){
        return Math.floor(seconds) + " second ago";
    }else{
        return Math.floor(seconds) + " seconds ago";
    }

}

// Update time lapsed
function updateTimeLapsed() {
    var timeLapsed = document.querySelectorAll('.time-lapsed');
    timeLapsed.forEach(function(time) {
        var timeLapsed = timeSince(time.getAttribute('data-time'));
        time.innerHTML = timeLapsed;
    });
}

// Load more contact list for patients
$(document).ready(function(){

    var patientThreadList = $('.patient-contact-list').height();

    $('.load_patients').on('click', function(){

        var next_page = $(this).attr('data-page');
        var currentSidebarHeight = $('.sidebar').height();

        $.ajax({
        
            url: 'process/patient_pagination.php',
            type: 'POST',
            data: { page: next_page },
            success: function(data){

                if( data.result == true ){
                    
                    var items = data.items;

                    // Add +1 to next page
                    var plus_one = parseInt(next_page) + 1;
                    $('.load_patients').attr('data-page', plus_one);

                    // Loop through items
                    $.each(items, function(i, item){
                        // Append to contact list
                        $('ul.patient-contact-list').append('<li class="thread-item"><a href="javascript:;" data-user-id="'+items[i].user_id+'" data-name="'+items[i].patient_fname+' '+items[i].patient_lname+'"><ion-icon name="person-circle-outline"></ion-icon><span>'+items[i].patient_fname+' '+items[i].patient_lname+'</span></a><div class="clear"></div></li>');
                    
                        console.log( items[i].user_id );

                    });

                    // Update sidebar height
                    $('.sidebar').css('height', currentSidebarHeight+0.1);

                }else{

                    // Remove load more button
                    $('.load_patients').remove();

                }

            }

        });

    });
});

// Load Thread
$(document).ready(function(){

    // Update Room
    function update_room( room_id, room_owner, room_name, participant_id, user_type){

        var last_update = Date.now();
        var roomStatus = $('#messages').attr('data-has-room');

        $.ajax({
            url: 'process/update_room.php',
            data : {
                'room_id': room_id,
                'room_owner': room_owner,
                'last_update': last_update,
                'participant_id' : participant_id,
                'roomStatus' : roomStatus,
                'room_name' : room_name,
                'user_type' : user_type
            },
            type: 'POST',
            success: function success(response) {
                // Response here
            },
        });

    }

    $('body').on('click', '.thread-item', function() {
        
        var user_id = $(this).children('a').attr('data-user-id');
        var name = $(this).children('a').attr('data-name');
        var room_id = user_id;
        var room_owner = $('#messages').attr('data-group');
        var roomName = $('#messages').attr('data-name');
        var participant_id = $('#messages').attr('data-sender-id');
        var user_type = $('#messages').attr('data-user-type');

        console.log('user_id: ' + user_id);
        console.log('name: ' + name);

        // Remove unread icon
        $(this).children('a').children('.ion-container').children('.unreadIcon').remove();

        $('#messages').attr('data-group', user_id);
        $('#messages').attr('data-name', name);

        // Change Chat Header Name
        $('.chat-header .desc .name').html(name);

        // Update chat list via ajax
        $.ajax({
            url: 'process/load_messages.php',
            type: 'POST',
            data: {
                room_id: room_id
            },
            success: function(data){
                
                // Clear messages
                $('#messages').html('');

                if( data.result == true ){

                    // Set has room indicator
                    $('#messages').attr('data-has-room', 'yes');

                    // Loop through items in backwards order
                    for (var i = data.messages.length - 1; i >= 0; i--) {
                        if( data.messages[i].msg_type == 'text' ){
                            $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.messages[i].sender_name+'</h6><div class="messageContainer">'+data.messages[i].msg+'</div><div class="time-lapsed" data-time="'+data.messages[i].sent_date+'">...</div></div><div class="clear"></div></li>');
                        }else if( data.messages[i].msg_type == 'videocall' ){
                            $('#messages').append('<li class="chatItem"><ion-icon name="person-circle-outline"></ion-icon><div class="content"><h6 class="username">'+data.messages[i].sender_name+'</h6><div class="videoCallLink"><div class="inner"><div class="desc"><h5>Video Call Started <span>Click to join in on the conversation</span></h5><a href="'+data.messages[i].msg+'" class="joincall" target="_blank">Join Call</a></div></div></div><div class="time-lapsed" data-time="'+data.messages[i].sent_date+'">...</div></div><div class="clear"></div></li>');
                        }
                    }

                    // Scroll to bottom of chat after loading messages
                    scrollToBottomChat();

                    $('.chat-wrapper .chat-header').show();

                }else{

                    // Set has room indicator
                    $('#messages').attr('data-has-room', 'no');

                    // Send error message
                    $('#messages').append('<li class="chatItem"><div class="systemContent leftChat">No chat history with '+name+' yet. Write message and send to start a conversation.</div></li>');

                }

            }
        });

        // Create Chat Room
        $.ajax({
        
            url: 'process/create_room.php',
            type: 'POST',
            data: {
                room_id: room_id
            },
            success: function(data){
                console.log(data);
            }

        });

        // Update Room
        update_room( room_id, room_owner, roomName, participant_id, user_type);

    });

});

// Hide & Show Navigation Menu functions
$(document).ready(function(){

    // Open Navigation
    $('.nav-menu-icon').click(function(){
        $('.navigation-container').css('right','0px');
    });

    // Close Navigation
    $('.close-nav-btn').click(function(){
        $('.navigation-container').css('right','-100%');
    });

    // Contact List
    $('.nav-link.contact-list').click(function(){
        $('.sidebar-link.contact-list').click();
    });

    // Message List
    $('.nav-link.msg').click(function(){
        $('.sidebar-link.msg').click();
    });

});

// Search Patient for video call initiation
$(document).ready(function(){

    function load_patient_list(){

        $.ajax({
            url: "process/load-vc-list.php",
            method: "POST",
            success: function(data) {
                
                if( data.result == true ){

                    var items = data.items;

                    for (var i = 0; i < items.length; i++) {
                        console.log(items[i].patient_fname);
                        
                        $vc_link = 'https://development.ddxrx.net/start_videocall.php?patient='+items[i].patient_id+'&username='+items[i].user_id+'&room_name='+items[i].patient_id+'&callid='+items[i].patient_id;

                        $('.vc-list-container .videocall-list .inner .vc-call-list').append('<li><span>'+items[i].patient_fullname+'</span> <a href="'+$vc_link+'" target="_blank"><ion-icon name="videocam" title="Start Video Call with '+items[i].patient_fullname+'"></ion-icon></a></li>');
                    
                    }

                }

            }
        });

    }

    // Load default list
    load_patient_list();

    // AJAX Search
    $('.vc-list-container .videocall-list .search').on('keyup', function() {

        var search_keyword = $(this).val();
        // do something with the text

        if( search_keyword !== '' ){

            // Hide contact list
            $('.vc-list-container .videocall-list .inner .vc-call-list').html('');

            $.ajax({
                url: "process/search-patient.php",
                method: "POST",
                data: { search: search_keyword },
                success: function(data) {
                    
                    if( data.result == true ){

                        var items = data.items;

                        for (var i = 0; i < items.length; i++) {
                            console.log(items[i].patient_fname);
                            
                            $vc_link = 'https://development.ddxrx.net/start_videocall.php?patient='+items[i].patient_id+'&username='+items[i].user_id+'&room_name='+items[i].patient_id+'&callid='+items[i].patient_id;

                            $('.vc-list-container .videocall-list .inner .vc-call-list').append('<li><span>'+items[i].patient_fullname+'</span> <a href="'+$vc_link+'" target="_blank"><ion-icon name="videocam" title="Start Video Call with '+items[i].patient_fullname+'"></ion-icon></a></li>');

                        }

                    }

                }
            });

        }else{

            // Erase search result
            $('.vc-list-container .videocall-list .inner .vc-call-list').html('');

            // Load default list
            load_patient_list();

        }

    });

    // Hide patient list
    $('.vc-list-container').on('click', function(event){
        // Check if the clicked element is the container itself
        if (event.target === this) {
            // Hide list
            $('.vc-list-container .videocall-list').css('right','-100%');
    
            // Hide after 0.5 seconds
            setTimeout(function() {
                $('.vc-list-container').fadeOut();
            }, 500);
        }
    });

    // Show patient list
    $('.videocall-btn').on('click', function(){

        // Show list
        $('.vc-list-container').fadeIn();

        // Show after 0.5 seconds
        setTimeout(function() {
            $('.vc-list-container .videocall-list').css('right','0');
        }, 500);

    });

    // Send Video Call Link to chat
    // $('.videocall-btn').click(function () {
    $(document).on('click', '.vc-list-container .videocall-list ul li a', function (e) {

        // Prevent default action
        e.preventDefault();

        // Generate Video Call ID
        function generateVCID() {
            return Math.floor(Math.random() * 9000000000) + 1;
        }

        // Get domain name
        var domainName = 'https://chat.ddxrx.com';

        // Generate the video call link
        //var vc_id = generateVCID();
        //var stream_link = domainName + '/video-chat.php?room_name=' + vc_id;

        // Get href attribute
        var stream_link = $(this).attr('href');

        // Insert video link in textarea
        let userMsg = $('#txt').val(stream_link);

        // Send the message
        $('.msgButton').click();

        // Open Video Call Link in new tab
        window.open(stream_link, '_blank');

    });

});

// Update time lapsed every 60 seconds
setInterval(updateTimeLapsed, 10000);