jQuery(document).ready(function($){
	
	// Canvas Options
	var options = {
		backgroundColor: '#FFFFFF',
		height: 800,
		brushSize: 1.5,
	};
	// Signature Canvas Options
	var SignatureOptions = {
		backgroundColor: '#EEEEEE',
		brushSize: 1,
	};

	// User ID's
	var uid = $('#uid').val();
	var provider_id = $('#provider_id').val();
	var provider_name = $('#provider_name').val();
	var patient_id = $('#patient_id').val();
	var patient_name = $('#patient_name').val();
	var patient_dob = $('#patient_dob').val();
	var patient_gender = $('#patient_gender').val();
	var gender = '';
	if(patient_gender == 'M' || patient_gender == 'm'){
		gender = 'Male';
	}else{
		gender = 'Female';
	}

    function patientDetails_watermark(){
        
    	var canvas = $("#canvas-container canvas").get(0);
    	var current_date_time = $('#order_date').val();
    	var provider_name = $('#provider_name').val();
        var ctx = canvas.getContext("2d");
        
    	const pixelSize = 18;
    	const width = ctx.measureText("text").width;
    	const height = pixelSize * 3 / 4;
    	
    	ctx.fillStyle = "#999999";
    	ctx.font = "bold " + pixelSize +"px serif";
		// ctx.fillText(("Issued On: " + current_date_time), 20, 775);
    	// ctx.fillText(("Patient: "+patient_name), 20, 40);
		// ctx.fillText(("Birthdate: "+patient_dob), 20, 70);
		// ctx.fillText(("Gender: " + gender), 20, 100);

		ctx.fillText(("Birthdate: "+patient_dob), 20, 40);
		ctx.fillText(("Gender: " + gender), 230, 40);
		ctx.fillText(("Patient: "+patient_name), 370, 40);

		ctx.fillText(("Issued On: " + current_date_time), 20, 775);
	
    }
    
	// Load Canvas
	$('#canvas-container').jqScribble(options);
	patientDetails_watermark();
	
	// Load Signature Canvas
	$('.signatureCanvas').jqScribble(SignatureOptions);

	// Reset Canvas
	$('.clear_canvas').click(function(){

		// Reset Signature Canvas
		$('.signatureCanvas').data('jqScribble').clear();

		// Reset Main Canvas
	    $('#canvas-container').data('jqScribble').clear();

		// Add Watermark
	    patientDetails_watermark();

	});
	
	
	$('.tab-content-container').on('click', '.button.blue.save_canvas', function() {
		
		// Declare Variables
		var order = '';
		var order_type = '';

		// Check if the order is a write order or a text order
		if( $(this).hasClass('write_order') == true ){
			order = $("#canvas-container canvas")[0].toDataURL('image/png');
			order_type = 'write';
		}else{
			order = $(".tab-content-container .editable-section").html();
			order_type = 'text';
		}
		var signed_image = $('.signatureCanvas canvas')[0].toDataURL('image/png');
        
        $.ajax({
			type: 'POST',
			url: 'process/save_order.php',
			data: {
				uid:uid,
				provider_id:provider_id,
				patient_id:patient_id,
				order_type:order_type,
				order:order,
				signed_image:signed_image
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response.result == true){
				    
				    Swal.fire({
                        icon: 'success',
                        title: response.title,
                        text: response.message,
                        showConfirmButton: true
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = 'order_list.php?id=' + response.patient_id + '&uid=' + response.uid + '&patient_id=' + response.patient_id;
                        }
                    });
					
				}

				console.log(response);
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}
		});
        
    });
    
	$('.tab-content-container').on('click', '.button.blue.open.save', function() {
		
		var $canvas = $("canvas");
		var patient_id = $('#patient_id').val();
		var provider_id = $('#provider_id').val();
        var user_id = $('body').data('patient-id');
        var image_url = $canvas[0].toDataURL('image/png');
        
        $.ajax({
			type: 'POST',
			url: 'process/save_image_open.php',
			data: {
				image_url:image_url,
				user_id:user_id,
				provider_id:provider_id
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response.status == 'success'){
				    
				    Swal.fire({
                        type: 'success',
                        title: 'Sign order has been saved',
                        showConfirmButton: true,
                    })
				    
					Swal.fire({
						title: 'Order Saved',
						text: "Signed order has been saved",
						icon: 'success',
						showCancelButton: false,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Done'
					}).then((result) => {
						if (result.isConfirmed) {

							// Redirect to page
							window.location.href = "order-app.php?patient_id=" + user_id;

						}
					});
				    
				}

			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}
		});
        
    });
    
    // Detect Checkbox
    $(".signature").change(function() {
        if(this.checked) {
            $('.save_canvas').removeClass('gray');
            $('.save_canvas').addClass('blue');

			$('.save').removeClass('gray');
            $('.save').addClass('blue');
        }else{
            $('.save_canvas').addClass('gray');
            $('.save_canvas').removeClass('blue');

			$('.save').addClass('gray');
            $('.save').removeClass('blue');
        }
    });
    
}); // End of Jquery



// Redirect
jQuery(document).ready(function($){

	$('.refresh').click(function(){

		var patient_id = $(this).data('patient-id');
		window.location.href = "order-app.php?patient_id=" + patient_id;

	});

});

// Print feature
jQuery(document).ready(function($){

    $('.print-order').on('click', function() {
        
        // Add class to hide non-printable content and show printable content
        $('body').addClass('printing');

        // Trigger print
        window.print();
    });

    // Remove class after printing
    $(window).on('afterprint', function() {
        $('body').removeClass('printing');
    });

    // Ensure class is added before printing
    $(window).on('beforeprint', function() {
        $('body').addClass('printing');
    });

});

// Editor UI initialization script
$(document).ready(function() {
    $(".live-edit").liveEdit({
        afterSaveAll: function(event, params) {
            console.log("Content saved:", params);
        },
        doubleClick: function(event, element, selectedNode) {
            console.log("Double-click detected on:", element);
        },
		toolbar: ['bold', 'italic', 'underline', 'strikethrough', 'quote', 'undo', 'redo'],
        allowedTags: ['h3']
    });

    $(".editable-section").each(function() {
        var placeholderText = $(this).attr("placeholder");

        function addPlaceholder(element) {
            if ($(element).find(".placeholder").length === 0) {
                $(element).empty().append('<p class="placeholder">' + placeholderText + '</p>');
            }
        }

        function removePlaceholder(element) {
            $(element).find(".placeholder").remove();
        }

        function cleanEmptyTags(element) {
            $(element).find("p").each(function() {
                if ($(this).text().trim() === "" || $(this).html() === "<br>") {
                    $(this).remove();
                }
            });
        }

        // Initialize placeholder
        if ($(this).text().trim() === "") {
            addPlaceholder(this);
        }

        // Handle focus event
        $(this).on("focus", function() {
            removePlaceholder(this);
        });

        // Handle blur event
        $(this).on("blur", function() {
            cleanEmptyTags(this); // Remove unnecessary <p><br></p>
            if ($(this).text().trim() === "") {
                addPlaceholder(this);
            }
        });

        // Handle keyup to remove placeholder if user starts typing
        $(this).on("keyup", function() {
            cleanEmptyTags(this); // Remove unnecessary <p><br></p>
            if ($(this).text().trim() === "") {
                addPlaceholder(this);
            } else {
                removePlaceholder(this);
            }
        });

        // Prevent unnecessary new lines on enter key
        $(this).on("keypress", function(event) {
            if (event.keyCode === 13) {
                event.preventDefault();
                document.execCommand("insertLineBreak");
            }
        });
    });
});
