$(document).ready(function(){
    
    // Get URL parameter "patient" from URL
    function getParameterByName(name, url) {
        if (!url) {
            url = window.location.href;
        }
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }

    // Function to get all data attribute from iframeContainer item using .each()
    function getIframeData() {
        var iframeData = [];
        var counter = 0;
        var total_page = 48;

        if( $('.iframWrapper').data('total-rooms') == '40' ) {
            total_page = 40;
        }

        $('.iframeContainer .item').each(function(){

            counter++;

            if( counter <= total_page ) {

                var iframeDataItem = {
                    frame: $(this).attr('data-frame'),
                    room: $(this).attr('data-room'),
                    source: $(this).attr('data-source'),
                    patientID: $(this).attr('data-patient-id'),
                };

                iframeData.push(iframeDataItem);
                
            }

        });

        // Convert to JSON
        const outputData = JSON.stringify(iframeData);

        // Get filename
        var url = window.location.pathname;
        var page = url.substring(url.lastIndexOf('/')+1);

        $.ajax({
            url: '../process/saveIframeData.php',
            type: 'POST',
            data: {
                page: page,
                iframeData: outputData
            },
            success: function(data){}
        });
        
    }

    // Close Popup
    $('.closeSitter').click(function(){
        $('.sitterContainer').css('left','-100%');
    });
    
    $('.target').click(function(){
        $('.sitterContainer').css('left','-100%');
    });

    // Open Popup
    // $('.add').click(function(){
    $('body').on('click', '.add', function() {

        // Add active class to item
        $('.item').removeClass('active');
        $(this).parent().addClass('active');

        // Show Popup
        $('.sitterContainer').css('left','0px');

        // Get frame number
        var frameNumber = $(this).parent().find('iframe').attr('class').split(' ')[1].split('_')[1];

        // Change Frames to selected frame
        $('.target').attr('target', 'iframe_'+frameNumber);

        // Show Sitter Container/popup
        $('.sitterContainer').css('left','0px');

    });

    // Change Channel Name
    $('.target').click(function(){

        var channelName = $('span',this).text();
        var videocallSrc = $(this).attr('href');
        var patientID = getParameterByName('username', videocallSrc);

        $('.item.active').find('.channel-label').text(channelName);
        $('.item.active').attr('data-room', channelName);
        $('.item.active').attr('data-source', videocallSrc);
        $('.item.active').attr('data-patient-id', patientID);

        // Reset stats container
        $('.item.active').find('.stats').remove();

        // Set stats container
        $('.item.active').append('<ul class="stats" data-patient-id="'+patientID+'" id="patient-id-'+patientID+'">');

        getIframeData();

    });

    // Add Remove Button when clicking item
    $('.target').click(function(){
        $('.item.active').prepend('<div class="icon-group"><ion-icon name="add-circle" class="add"></ion-icon><ion-icon name="close-circle" class="remove"></ion-icon><ion-icon name="refresh-circle" class="refresh"></ion-icon></div>');
    });

    // Remove iframe source when clicking remove button
    $('.item').on('click', '.remove', function(){
        $(this).parent().find('iframe').attr('src','');
        $(this).parent().find('.channel-label').text('');
        $(this).parent().attr('data-room', '');
        $(this).parent().attr('data-source', '');
        $(this).parent().find('.refresh').remove();
        $(this).parent().find('.stats').remove(); 
        $(this).remove();
        getIframeData();
    });

    // Refresh iframe
    $('.refresh').click(function(){
        // var iframeSrc = $(this).parent().find('iframe').attr('src');
        // $(this).parent().find('iframe').attr('src', iframeSrc);
        // document.getElementById('iframeid').src = document.getElementById('iframeid').src

        // Get Iframe ID
        var iframeID = $(this).parent().find('iframe').attr('id');

        // Change Iframe Source
        document.getElementById(iframeID).src = document.getElementById(iframeID).src

    });

    // Redirect to selected page
    $('.selectbox').change(function(){
        var page = $(this).val();
        window.location.replace(page);
    });

    // Pagination Section
    $('.pagination a').click(function(){
        
        var page = $(this).data('page');

        // Set active class to pagination item
        $(this).addClass('active');
        $(this).siblings().removeClass('active');

        // Change page number
        $('.page').removeClass('active');
        $('.page.page-'+page).addClass('active');

    });

    // Check stats every 1 second
    setInterval(function(){

        $(".stats").each(function(){

            var this_item = $(this).attr('id');
    
            // Ajax Call
            $.ajax({
                url: '../process/sitter_stats.php',
                type: 'POST',
                data: {
                    patientID: $(this).data('patient-id')
                },
                success: function(data){
                    $('#'+this_item).html(data);
                }
            });
    
        });

    }, 60000);

    // Check alert every 1 second
    setInterval(function(){

        $(".item").each(function(){

            var patientID = $(this).data('patient-id');
            var this_item = $(this).attr('id');
            var has_data = $(this).data('source');

            // Ajax Call
            if (has_data) {
                $.ajax({
                    url: '../process/sitter_alert.php',
                    type: 'POST',
                    data: {
                        patientID: patientID
                    },
                    success: function(data){

                        if(data.result == true) {
                            $('#'+this_item).children('.iframe').addClass('alert');
                        }

                    }
                });
            }
    
        });

    }, 5000);

    // Check and remove alert every 10 seconds
    setInterval(function(){

        $(".item").each(function(){

            var this_item = $(this).attr('id');

            $('#'+this_item).children('.iframe').removeClass('alert');
    
        });

    }, 10000);

});