function detectSilence(
    stream,
    onSoundEnd,
    onSoundStart,
    silence_delay = 500,
    min_decibels = -50
) {
    const ctx = new AudioContext();
    const analyser = ctx.createAnalyser();
    const streamNode = ctx.createMediaStreamSource(stream);
    streamNode.connect(analyser);
    analyser.minDecibels = min_decibels;

    const data = new Uint8Array(analyser.frequencyBinCount); // will hold our data
    let silence_start = performance.now();
    let triggered = false; // trigger only once per silence event

    function loop(time) {
        requestAnimationFrame(loop); // we'll loop every 60th of a second to check
        analyser.getByteFrequencyData(data); // get current data
        if (data.some((v) => v)) {
            // if there is data above the given db limit
            if (triggered) {
                triggered = false;
                onSoundStart();
            }
            silence_start = time; // set it to now
        }
        if (!triggered && time - silence_start > silence_delay) {
            onSoundEnd();
            triggered = true;
        }
    }
    loop(0);
    return async () => {
        streamNode.disconnect();
        analyser.disconnect();
        await ctx.close();
    };
}


const mergeAudioStreams = (desktopStream, voiceStream) => {
    const context = new AudioContext();
    const destination = context.createMediaStreamDestination();
    let hasDesktop = false;
    let hasVoice = false;
    if (desktopStream && desktopStream.getAudioTracks().length > 0) {
      // If you don't want to share Audio from the desktop it should still work with just the voice.
      const source1 = context.createMediaStreamSource(desktopStream);
      const desktopGain = context.createGain();
      desktopGain.gain.value = 0.7;
      source1.connect(desktopGain).connect(destination);
      hasDesktop = true;
    }

    if (voiceStream && voiceStream.getAudioTracks().length > 0) {
      const source2 = context.createMediaStreamSource(voiceStream);
      const voiceGain = context.createGain();
      voiceGain.gain.value = 0.7;
      source2.connect(voiceGain).connect(destination);
      hasVoice = true;
    }
      
    return (hasDesktop || hasVoice) ? destination.stream.getAudioTracks() : [];
};



async function doctorAiStartSTT(callback) {

    let audioContext;
   
    let audioChunks = [];


    navigator.mediaDevices.getDisplayMedia({ video: true, audio: true, "echoCancellation":true,"noiseSuppression":true,  selfBrowserSurface: "include"}).then(screenStream => {

        let recorder = new MediaRecorder(screenStream);
        recorder.ondataavailable = async (record) => {
            let response = await fetch("https://doctorai.online/api/ai/stt/", {
                method: "POST",
                body: record.data,
            });
            if (response.status == 200) {
                let txt = await response.text();
                callback(txt);
            }
        };
        let analyserClose = detectSilence(
            screenStream,
            () => recorder.stop(),
            () => recorder.start()
        );
        return async () => {
            await analyserClose();
            screenStream.getTracks().map((u) => u.stop());
        };

    });
}



async function doctorAiStartSTTNew(callback) {
    //var constraints = {audio: true, deviceId: { exact: devicesMain } };
    let audioStream = await navigator.mediaDevices.getUserMedia({
        audio: true,  "echoCancellation":true,"noiseSuppression":true 
    });
    let recorder = new MediaRecorder(audioStream);
    recorder.ondataavailable = async (record) => {
        let response = await fetch("https://doctorai.online/api/ai/stt/", {
            method: "POST",
            body: record.data,
        });
        if (response.status == 200) {
            let txt = await response.text();
            callback(txt);
        }
    };
    let analyserClose = detectSilence(
        audioStream,
        () => recorder.stop(),
        () => recorder.start()
    );
    return async () => {
        await analyserClose();
        audioStream.getTracks().map((u) => u.stop());
    };
}


