<?php

/**
 * REQUIRE FUNCTIONS
 */
include('process/functions.php');

/**
 * REQUIRE PDF LIBRARY
 * 
 * FPDF is a PHP class which allows to generate PDF files with pure PHP,
 * that is to say without using the PDFlib library. F from FPDF stands for Free:
 * you may use it for any kind of usage and modify it to suit your needs.
 */
require('lib/fpdf.php');

class PDF extends FPDF {

    // Page header
    function Header() {

        // Check if it's the first page
        if ($this->PageNo() != 1) {
            // Don't output anything for the header on the second page
            return;
        }

        // Set font family to Arial bold 
        $this->SetFont('Arial', '', 10);
        
        $this->SetFillColor(255,255,255);
        
        // Add logo to page
        $this->Image('assets/images/logo.png', 120, 20, 80);
        
        // Bill From
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(50, 5, 'Company Address:', '0', 2, 'L');
        
        // From Address
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(50, 5, 'American Healthcare AI, LLC 1120 Beach Blvd; Biloxi; MS 39530', '0', 2, 'L');
        
        // Line break
        $this->Ln(2);

        // Generate Date
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(11, 5, 'Clinic: ', 0, 0, 'L');

        $this->SetFont('Arial', '', 10);
        $this->Cell(30, 5, get_version('clinic_name'), 0, 0, 'L');

        $this->Ln(5);

        $this->SetFont('Arial', 'B', 10);
        $this->Cell(11, 5, 'URL: ', 0, 0, 'L');

        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 5, 'https://'.get_version('url'), 0, 0, 'L');

        $this->Ln(10);

    }
  
    // Page footer
    function Footer() {
          
        // Position at 1.5 cm from bottom
        $this->SetY(-15);
          
        // Arial italic 8
        $this->SetFont('Arial','I',8);
          
        // Page number
        $this->Cell(0,10,'Page ' . $this->PageNo() . '/{nb}',0,0,'C');
    }
    
    // Content
    function contentTable(){
        
        // URL Parameters
        if( isset($_GET['month']) || isset($_GET['month']) ){
            if( isset($_GET['month']) ){ $month = $_GET['month']; }
            if( isset($_GET['year']) ){ $year = $_GET['year']; }
            $parameters = '?month='.$month.'&year='.$year;
        }else{
            $parameters = '';
        }

        /* -------------------------------- */
        /* TABLE DATE */
        /* -------------------------------- */
        // Width
        $width = $this->w;
        $margin = $this->lMargin+$this->rMargin;
        $width = $width-$margin;

        $generate_date = date("F", mktime(0, 0, 0, $month, 1)).' 01, '.$year.' - '.date("F", mktime(0, 0, 0, $month, 1)).' 30, '.$year;


        // Rectangle
        $this->Rect(10, 48, 190, 20, 'D');

        // Label
        $this->Ln(5);
        $this->SetFont('Arial', 'B', 18);
        $this->Cell($width, 5, 'Report Date', 0, 0, 'C');
        $this->Ln();

        // Report Data
        $this->SetFont('Arial', '', 10);
        $this->Cell($width, 10, $generate_date, 0, 0, 'C');

        // Spacing
        $this->Ln(11);

        /* -------------------------------- */
        /* TABLE HEADER */
        /* -------------------------------- */
        $this->SetFont('Arial', 'B', 10);
        $this->SetFillColor(255, 0, 51);
        
        // Tick Border
        $this->SetFillColor(85, 85, 85);
        $this->Cell(0, 3, '', 't', 2, 'r', true);
        $this->Ln(3);

        // Table Header
        $this->Cell(50, 10, 'Full Name', 0, 0, 'L');
        $this->Cell(18, 10, 'Gender', 0, 0, 'L');
        $this->Cell(28, 10, 'Birth Date', 0, 0, 'L');
        $this->Cell(30, 10, '99453', 0, 0, 'L');
        $this->Cell(23, 10, '99454', 0, 0, 'L');
        $this->Cell(20, 10, '99457', 0, 0, 'L');
        $this->Cell(30, 10, '99458', 0, 0, 'L');
        $this->Ln();
        
        // Output Thick Border
        $this->SetFillColor(85, 85, 85);
        $this->Cell(0, 0, '', 't', 2, 'r', true);
        $this->Ln('3');
        
        /* -------------------------------- */
        /* TABLE CONTENT */
        /* -------------------------------- */
        $this->SetFont('Arial', '', 10);

        // GET API END POINT URL
        $protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://';
        $domain = $_SERVER['HTTP_HOST'];

        if ($domain == '192.168.0.100' || $domain == 'localhost') {
            $endpoint = $protocol . $domain . '/ddxrx-main/process/billing-code-data.php' . $parameters;
        } else {
            $endpoint = $protocol . $domain . '/process/billing-code-data.php' . $parameters;
        }
        

        // Fetch data from the API endpoint
        $data = file_get_contents($endpoint);

        // Decode JSON data into a PHP variable
        $result = json_decode($data, true);

        if ($result !== null) {
            foreach( $result['data'] as $item ){

                $pdf_fullName = $item['0'].' '.$item['1'];
                $pdf_gender = $item['2'];
                $pdf_dob = $item['3'];
                $pdf_99453 = $item['4'];
                $pdf_99454 = $item['5'];
                $pdf_99457 = $item['6'];
                $pdf_99458 = $item['7'];

                $this->Cell(50, 5, $pdf_fullName, 10, 0, 'L');
                $this->Cell(18, 5, $pdf_gender, 10, 0, 'L');
                $this->Cell(28, 5, $pdf_dob, 10, 0, 'L');
                $this->Cell(30, 5, $pdf_99453, 10, 0, 'L');
                $this->Cell(23, 5, $pdf_99454, 10, 0, 'L');
                $this->Cell(20, 5, $pdf_99457, 10, 0, 'L');
                $this->Cell(30, 5, $pdf_99458, 10, 0, 'L');
                $this->Ln('8');
                
                // Output Thick Border
                $this->SetFillColor(204, 204, 204);
                $this->Cell(0, 0, '', 't', 2, 'r', true);
                $this->Ln('5');

            }
        } else {
            echo "Failed to retrieve data from the API.";
        }
        
    }
    
}


$pdf = new PDF();

// Set Title
$pdf->SetTitle('Billing Records PDF');

// Define alias for number of pages
$pdf->AliasNbPages();
$pdf->AddPage();

// Add Content
$pdf->contentTable();

//Output the file as a PDF
$pdf->Output();

?>