<!DOCTYPE html>
<html>
<head>
    <title>Create Progress Note</title>
    
    <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link href="assets/css/create-note-progress.css" rel="stylesheet">
    
    <script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
    <script src="https://cdn.tiny.cloud/1/xcfx6zf39xlodz2jrzrd7w47euaf03u23fjuo8m4bn23tafd/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <script type="text/javascript">
        tinymce.init({
            selector: 'textarea',
            plugins: 'autoresize casechange linkchecker autolink lists checklist permanentpen powerpaste table advtable tinymcespellchecker',
            toolbar: 'a11ycheck addcomment showcomments casechange checklist export table',
            toolbar_mode: 'floating',
            tinycomments_mode: 'embedded',
            tinycomments_author: 'Author name',
            min_height: 400
        });
        
        $(document).ready(function(){
            
            $('.options-container .button').click(function(){
                
                $.ajax({
                    type: "POST",
                    url: 'process/create-note-progress.php',
                    
                    data:{
                        userid:userid,
                        content: content,
                        yes_content: yes_content,
                        no_content: no_content,
                        alertType: alertType
                    },
                    
                    success: function(data){
                        // Do something
                    }
                
                });
                
            });
            
        });
        
    </script>
    
</head>
<body>
    
    <div class="editor-container">
        <div class="container">
            <div class="col-md-12">
                
                <div class="edit-note-header">
                    <h3>Create Progress Note</h3>
                    <a href="notes-progress.php"></a>
                    <a href="notes-progress.php" class="go-back-button">Go Back</a>
                </div>
                
                <textarea>
                    <h4 class="edit-text-header">Chief Complaints:</h4>
                    <p class="not-edited edit-text">** Remove this and start writing chief complaint **</p>
                    <br>
                    
                    <h4 class="edit-text-header">History of present illness</h4>
                    <p class="not-edited edit-text">** Remove this and enter present illness **</p>
                    <br>
                    
                    <h4 class="edit-text-header">Additional Information</h4>
                    <p class="not-edited edit-text">** Remove this and add additional information **</p>
                    <br>
                    
                    <h4 class="edit-text-header">Review of system</h4>
                    <p class="not-edited edit-text">** Remove this and write review system **</p>
                </textarea>
                
                <!-- Options -->
                <div class="options-container">
                    
                    <h6>Review of system</h6>
                    <label>
                        <span>All system were reviewed and was found negative except the above in HPI</span>
                        <input type="checkbox" id="review_system" name="review_system" value="true">
                        <div style="clear: both"></div>
                    </label>
                    
                    <h6>Vitals</h6>
                    <label>
                        <span>All Vitals were reviewed</span>
                        <input type="checkbox" id="vitals_check" name="vitals_check" value="true">
                        <div style="clear: both"></div>
                    </label>
                    
                    <h6>Physical Exam:</h6>
                    <label>
                        <span>Approve normal physical exam</span>
                        <input type="checkbox" id="physical_exam" name="physical_exam" value="true">
                        <div style="clear: both"></div>
                    </label>
                    
                    <h6>Laboratory and Radiology Data</h6>
                    <label>
                        <span>Assesment and plan</span>
                        <input type="checkbox" id="assesment_plan" name="assesment_plan" value="true">
                        <div style="clear: both"></div>
                    </label>
                    
                    <a href="javascript:;" class="button">Create Note</a>
                    
                </div>
                <!-- Options -->
                
            </div>
        </div>
    </div>
    
</body>
</html>