<?php
    
    session_start();
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || ($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor')) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');
    
?>
<html>
    <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        
        <title>Dictation Notes</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/jquery.bxslider.min.css">
	    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
        <link rel="stylesheet" type="text/css" href="assets/css/dictation-notes.css">
        
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>        
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>
        <script type="text/javascript" src="assets/js/faq.js"></script>
        <script type="text/javascript" src="assets/js/jquery.bxslider.min.js"></script>
        <script type="text/javascript" src="assets/js/dictation-list.js"></script>
        
    </head>
    <body class="patien-data-table dashboard-area">
        
        <!-- Header -->
        <div class="header">
            
            <div class="container">
                <div class="col-md-12">
                    <div class="patient-info">
                        <h3 class="tabtitle">Dictation Notes</h3>
                        <div class="clear"></div>
                    </div>
                </div>
            </div>
            
            <div class="menu-container">
                <div class="container">
                    <div class="col-md-12">
                    <ul class="dashboard-nav fix">
                        <li><a href="nurse_default.php">Home</a></li>
                        <li><a href="dashboard.php">Diagnosis</a></li>
                        <li class="current"><a href="dictation-notes.php">Dictation Notes</a></li>
                        <li><a href="vitals_dashboard.php">RPM</a></li>
                        <li><a href="ccm_dashboard.php">CCM</a></li>
                    </ul>
                    </div>
                </div>
            </div>
            
        </div>
        <!-- Header -->

        <!-- Start Dictation Notes Container -->
        <div class="container">
            <div class="col-md-12">

                <ul class="dictation-nav">
                    <li><a href="dictation-notes.php">Dictation</a></li>
                    <li><a href="dictation-notes-hallucinations.php" class="active">Hallucinations</a></li>
                </ul>

                <div class="dictation-notes full">

                    <?php
                    $version = get_version(); // Get the current version

                    // $sql = "SELECT nd.*, 
                    //     CONCAT(p.patient_fname, ' ', p.patient_lname) AS full_name,
                    //     DATE_FORMAT(nd.`date`, '%b %d, %Y / %l:%i %p') AS `note_date`,
                    //     DATE_FORMAT(p.`patient_dob`, '%b %d, %Y') AS `dob`
                    //     FROM notes_dictation nd
                    //     JOIN patients p ON nd.patient_id = p.patient_id
                    //     JOIN notes_dictation_ai ndai ON nd.dictation_id = ndai.dictation_id
                    //     WHERE ndai.hallucination = 1
                    //     ORDER BY nd.`date` DESC;";

                    // Create SQL query that will select all data from the notes_dictation_ai table, just that no more joins are needed and hallucination is set to 1
                    $sql = "SELECT * FROM `notes_dictation_ai` WHERE `hallucination` = '1' AND `groupid` = '$version' ORDER BY `created` DESC";
                    
                    $result = ddxrxDBConnect()->query($sql); // Execute the query

                    // Store hex color codes in an array
                    $colors = array(
                        'a' => '#e870be',
                        'b' => '#70d4e8',
                        'c' => '#70e8de',
                        'd' => '#70e8dc',
                        'e' => '#e89870',
                        'f' => '#e87070',
                        'g' => '#e8708e',
                        'h' => '#e8a670',
                        'i' => '#70e872',
                        'j' => '#9FE870',
                        'k' => '#70e8bc',
                        'l' => '#7088e8',
                        'm' => '#7074e8',
                        'n' => '#e8d470',
                        'o' => '#e870da',
                        'p' => '#70b0e8',
                        'q' => '#c670e8',
                        'r' => '#e8707c',
                        's' => '#dc70e8',
                        't' => '#cee870',
                        'u' => '#8e70e8',
                        'v' => '#e8707c',
                        'w' => '#90e870',
                        'x' => '#70e8bc',
                        'y' => '#e870be',
                        'z' => '#9FE870'
                    );

                    // Check if there are any notes
                    if ($result->num_rows > 0) {

                        // output data of each row
                        while($row = $result->fetch_assoc()) {

                            $note_date = $row['created'];
                            $note_text = $row['note'];
                            $readMore = '<a href="dictation-notes-view.php?note_id='.$row['id'].'" class="open-note">Open Note <i class="fa-solid fa-arrow-up-right-from-square"></i></a>';

                            // Filter out the elements
                            $note_text = str_replace('<h3 contenteditable="false">Progress Note:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false"> Progress Note:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false">Plan:</h3>', '', $note_text);
                            $note_text = str_replace('<h3 contenteditable="false"> Plan:</h3>', '', $note_text);
                            $expanded_note_text = $note_text;

                            // Limit note text to 100 characters
                            if (strlen($note_text) > 300) {
                                $note_text = '<div id="compressed_note_'.$row['id'].'" class="previewText compressed">'.substr($note_text, 0, 300) . '... <a href="#" class="more" data-note-id="'.$row['id'].'">Read More</a></div>';
                            }else{
                                $note_text = '<div class="previewText">'.$note_text.'</div>';
                            }

                            $expanded_note = '<div id="expanded_note_'.$row['id'].'" class="previewText expanded-note">'.$expanded_note_text.'</div>';

                            // Generate random letter from a-z
                            $first_letter = chr(rand(97, 122));
                            $color = $colors[$first_letter];

                            echo '
                            <div class="item">
                                <div class="bullet"><div class="point" style="background-color: '.$color.'"></div></div>
                                <div class="innerNote">
                                    <div class="note-info">
                                        <div class="patient"><span>'.$note_date.'</span></div>
                                        <div class="details">
                                        <div class="patient-info"><i class="fa-regular fa-clipboard"></i>Provider ID: 37821</div>
                                        </div>
                                    </div>
                                    <div class="note-text">
                                        '.$expanded_note.'
                                        '.$note_text.'
                                    </div>
                                </div>
                            </div>
                            ';
                        
                        }
                    } else { // No notes found
                        echo '<h1>No hallucination notes found</h1>';
                    }
                    ?>

                </div>
            </div>
        </div>
        <!-- End Dictation Notes Container -->
        
        <?php provider_bottom_nav(); ?>
        
    </body>
</html>