<?php
error_reporting(1);
session_start();

include('process/functions.php');
// include('includes/database_include.php');

if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
    header("Location: login.php");
    die();
}

if( isset($_GET['id']) ){
    $target_id = $_GET['id'];
}else{
    $target_id = $_SESSION['patient_id'];
}

$patient_id = null;

if(isset($_SESSION['userid']) && isset($_SESSION['patient_id'])) {
    $patient_id = $_SESSION['patient_id'];
    $user_id = $_SESSION['userid'];
} else if($_SESSION['userType']!="patient" && isset($_GET['id']) ) {
    $patient_id = $_GET['id'];
    $user_id = $_GET['uid'];
}

?>
    
    <!DOCTYPE html>
    <html class="ui-mobile">
        
        <head>
            <title>DDXRX - AI Notes</title>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            
            <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
            <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
            <link rel="stylesheet" type="text/css" href="assets/css/style.css">
            <link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
            <link rel="stylesheet" type="text/css" href="assets/css/encounter.css">
            <link rel="stylesheet" type="text/css" href="assets/css/dictation-notes.css">
            <link rel="stylesheet" type="text/css" href="assets/css/patient-records.css">
            <link rel="stylesheet" type="text/css" href="assets/css/faq.css">

            <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
            <script type="text/javascript" src="https://kit.fontawesome.com/e424c30ea6.js" crossorigin="anonymous"></script>

            <style type="text/css">
                body{
                    top: 0px!important;
                }
                .goog-te-banner-frame.skiptranslate {
                    display: none !important;
                }
                #goog-gt-tt{
                    display:none!important;
                }
                #google_translate_element{
                    position: fixed; left:20px; top: 20px; z-index: 9999999;
                }
                </style>
                
                <script type="text/javascript">
                function googleTranslateElementInit() {
                    new google.translate.TranslateElement({pageLanguage: 'en', 
                    layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
                    autoDisplay: false, 
                    includedLanguages: ''}, 'google_translate_element');}
            </script>
            <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

        </head>
        
        <body data-patient-id="<?php echo $target_id; ?>" data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?> data-cctype="rpm">

        <div id="google_translate_element"></div>

            <div class="container">
                <div class="col-md-12">
                    
                    <div class="record-navigation-menu" style="margin-top: 40px;">
                        <?php include('emr_navigation.php'); ?>
                    </div>

                    <?php note_nav( $patient_id, $user_id ); ?>

                    <div class="dictation-notes full">
                            
                        <?php

                            // Get the current version
                            $version = get_version();
                            
                            $sql = "SELECT nd.*, DATE_FORMAT(nd.`date`, '%b %d, %Y / %l:%i %p') AS `note_date` FROM notes_dictation nd WHERE nd.patient_id = '$user_id' AND nd.group_id = '$version' ORDER BY nd.`date` DESC;";

                            $result = ddxrxDBConnect()->query($sql); // Execute the query

                            // Store hex color codes in an array
                            $colors = array(
                                'a' => '#e870be',
                                'b' => '#70d4e8',
                                'c' => '#70e8de',
                                'd' => '#70e8dc',
                                'e' => '#e89870',
                                'f' => '#e87070',
                                'g' => '#e8708e',
                                'h' => '#e8a670',
                                'i' => '#70e872',
                                'j' => '#9FE870',
                                'k' => '#70e8bc',
                                'l' => '#7088e8',
                                'm' => '#7074e8',
                                'n' => '#e8d470',
                                'o' => '#e870da',
                                'p' => '#70b0e8',
                                'q' => '#c670e8',
                                'r' => '#e8707c',
                                's' => '#dc70e8',
                                't' => '#cee870',
                                'u' => '#8e70e8',
                                'v' => '#e8707c',
                                'w' => '#90e870',
                                'x' => '#70e8bc',
                                'y' => '#e870be',
                                'z' => '#9FE870'
                            );

                            // Check if there are any notes
                            if ($result->num_rows > 0) {

                                // output data of each row
                                while($row = $result->fetch_assoc()) {

                                    $note_owner = $row['patient_name'];
                                    $note_date = !empty($row['note_date']) ? $row['note_date'] : 'N/A';
                                    $note_text = !empty($row['message']) ? $row['message'] : 'N/A';
                                    $patient_birthdate = !empty($row['dob']) ? $row['dob'] : 'N/A';
                                    $readMore = '<a href="dictation-notes-view.php?note_id='.$row['id'].'" class="open-note">Open Note <i class="fa-solid fa-arrow-up-right-from-square"></i></a>';

                                    // Filter out the elements
                                    $note_text = str_replace('<h3 contenteditable="false">Progress Note:</h3>', '', $note_text);
                                    $note_text = str_replace('<h3 contenteditable="false"> Progress Note:</h3>', '', $note_text);
                                    $note_text = str_replace('<h3 contenteditable="false">Plan:</h3>', '', $note_text);
                                    $note_text = str_replace('<h3 contenteditable="false"> Plan:</h3>', '', $note_text);
                                    $expanded_note_text = $note_text;

                                    // Limit note text to 100 characters
                                    if (strlen($note_text) > 300) {
                                        $note_text = '<div id="compressed_note_'.$row['id'].'" class="previewText compressed">'.substr($note_text, 0, 300) . '... <a href="#" class="more" data-note-id="'.$row['id'].'">Read More</a></div>'.$readMore;
                                    }else{
                                        $note_text = '<div class="previewText">'.$note_text.'</div>'.$readMore;
                                    }

                                    $expanded_note = '<div id="expanded_note_'.$row['id'].'" class="previewText expanded-note">'.$expanded_note_text.'</div>';

                                    // Get color based on first letter of patient's name
                                    $first_letter = strtolower(substr($note_owner, 0, 1));
                                    $color = $colors[$first_letter];
                                    
                                    if( $row['patient_name'] != 'none' && $row['provider_name'] != 'none' ){
                                        
                                        $note_owner = decryptAES($row['patient_name']);
                                        $provider_name = decryptAES($row['provider_name']);

                                    }else{

                                        if( $row['provider_id'] != '0' ){
                                            $provider_name = getphysicianInfo( $row['provider_id'], 'physician_fname' ) . ' ' . getphysicianInfo( $row['provider_id'], 'physician_lname' );
                                        }else{
                                            $provider_name = 'N/A';
                                        }

                                        if( $row['patient_id'] != '0' ){
                                            $note_owner = getpatientInfo( $row['patient_id'], 'patient_fname' ) . ' ' . getpatientInfo( $row['patient_id'], 'patient_lname' );
                                        }else{
                                            $note_owner = 'N/A';
                                        }

                                    }

                                    echo '
                                    <div class="item">
                                        <div class="bullet"><div class="point" style="background-color: '.$color.'"></div></div>
                                        <div class="innerNote">
                                            <div class="note-info">
                                                <div class="patient"><div>'.$note_owner.'</div><span>'.$note_date.'</span></div>
                                                <div class="details">
                                                <div class="patient-info"><i class="fa-regular fa-clipboard"></i>Provider: '.$provider_name.'</div>
                                                </div>
                                            </div>
                                            <div class="note-text">
                                                '.$expanded_note.'
                                                '.$note_text.'
                                            </div>
                                        </div>
                                    </div>
                                    ';
                                
                                }
                            } else { // No notes found
                                echo '<h1>No dictation notes found.</h1>';
                            }
                        ?>

                        </div>
                    
                </div>
            </div>
            
            <?php
            	if( $_SESSION['userType'] == 'nurse' ){
            		provider_bottom_nav();
            	}elseif( $_SESSION['userType'] == 'doctor' ){
            		physician_bottom_nav();
            	}else{
            		bottom_nav();
            	}
            ?>
            <script type="text/javascript" src="assets/js/faq.js"></script>
            
        </body>
    </html>