jQuery(document).ready(function($){

	$('.reset_password').click(function(){

		var user_n = $('#user_n').val();
		var cpass = $('#cpass').val();
		var npass = $('#npass').val();
		var rpass = $('#rpass').val();

		if( user_n == '' || cpass == '' || npass == '' || rpass == '' ){

			Swal.fire({
				type: 'error',
				title: 'Error',
				text: 'All fields must not be empty!',
			});

		}else{

			if( npass != rpass ){

				Swal.fire({
					type: 'error',
					title: 'Password does not match',
					text: 'New password and repeat password does not match',
				});

			}else{

				// Ajax
				$.ajax({
					type: 'POST',
					url: 'process/reset_password_change.php',

					data: {
						user_n:user_n,
						cpass:cpass,
						npass:npass
					},

					beforeSend: function() {
					    // Do Something
					},
					success: function(response) {
						if( response == 'match' ){
							Swal.fire({
								type: 'success',
							  	title: 'Success',
							  	text: 'Password has been changed to: '+npass,
							});
						}else{
							Swal.fire({
								type: 'error',
							  	title: 'Invalid Credentials',
							  	text: 'Username and password does not match',
							});
							console.log(response);
						}
					},
					
					fail: function(response){
						Swal.fire({
							type: 'error',
						  	title: 'Oops...',
						  	text: 'Password reset failed!',
						});
					}
				});
				// Ajax

			} // End if

		} // End if

	});

});