<?php
    ob_start();

    // Start the session
    session_start();
    
    // Enable error reporting
    error_reporting(E_ALL);
    ini_set('display_errors', 1);

    // Include the necessary files
    include('process/functions.php');

    // Check if the session has expired
    checkSessionTimeout();

    if (!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: logout.php");
        die();
    } elseif ($_SESSION['userType'] == 'doctor') {
        header("Location: physician_default.php");
        die();
    } elseif ($_SESSION['userType'] != 'nurse') {
        header("Location: logout.php");
        die();
    }
    
    if(isset($_GET['staff']) && $_GET['staff'] == 'true'){
        $_SESSION["staff"] = "true";
    }
    
    unset($_SESSION['checkbox_selected']);
    unset($_SESSION['dataArray']);
    unset($_SESSION['review']);
    unset($_SESSION['vital']);
    unset($_SESSION['physical_exam']);
    
    if (isset($_SESSION['names']) && is_array($_SESSION['names'])) {
        foreach (array_unique($_SESSION['names']) as $key => $value) {
            unset($_SESSION[$value]);
        }
    }    
    
    unset($_SESSION['names']);
    unset($_SESSION['denied']);
    unset($_SESSION['deniedfinal']);
    unset($_SESSION['visitor_info_id']);
    
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>DDXRX Choose Actions</title>
	
	<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/sweetalert2.min.js"></script>
	<script type="text/javascript" src="assets/js/base64converter.js"></script>
	<script type="text/javascript" src="assets/js/mobile.js"></script>
	<script type="text/javascript" src="assets/js/faq.js"></script>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css">
	<link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-5"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-5');
    </script>

	
	<script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({pageLanguage: 'en', 
        layout:     google.translate.TranslateElement.InlineLayout.VERTICAL,
        autoDisplay: false, 
        includedLanguages: ''}, 'google_translate_element');}
    </script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
	
</head>
<body class="page-default <?php echo body_class(); ?>">
    
    <div class="loading-screen"></div>
    
    <div id="google_translate_element"></div>
    
    <div class="container">
        <div class="home-screen">
            <div class="inner">

                <div class="logo-container">
                    <img src="assets/images/logo-new.png">
                </div>

                <div class="icon_wrapper">

                    <div class="icon">
                        <a href="dashboard.php">
                            <div class="item dashboard color-9"></div>
                            <div class="label"><h6>Dashboard</h6></div>
                        </a>
                    </div>

                    <div class="icon">
                        <a href="dictation-notes.php">
                            <div class="item sitter color-6"></div>
                            <div class="label"><h6>Dictation</h6></div>
                        </a>
                    </div>

                    <div class="icon">
                        <a href="search_dd.php?staff=true">
                            <div class="item search color-1"></div>
                            <div class="label"><h6>Symptoms Checker</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="https://chat.ddxrx.net">
                            <div class="item chat color-3"></div>
                            <div class="label"><h6>Chat</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="search-video-call.php">
                            <div class="item video-call color-5"></div>
                            <div class="label"><h6>Video Call</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="new_records.php">
                            <div class="item account color-2"></div>
                            <div class="label"><h6>EMR</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="vitals_dashboard.php">
                            <div class="item rpm color-8"></div>
                            <div class="label"><h6>RPM / CCM</h6></div>
                        </a>
                    </div>

                    <div class="icon">
                        <a href="downloads.php" class="no-loading">
                            <div class="item downloads color-10"></div>
                            <div class="label"><h6>Downloads</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="assign-nurse.php">
                            <div class="item assign color-7"></div>
                            <div class="label"><h6>Assign Nurse</h6></div>
                        </a>
                    </div>
                    
                    <div class="icon">
                        <a href="sitter/index.php">
                            <div class="item watch color-4"></div>
                            <div class="label"><h6>Sitter</h6></div>
                        </a>
                    </div>

                    <div class="icon">
                        <a href="adt-dashboard.php">
                            <div class="item adt color-9"></div>
                            <div class="label"><h6>ADT Dashboard</h6></div>
                        </a>
                    </div>

                    <div class="icon">
                        <a href="logout.php">
                            <div class="item logout color-4"></div>
                            <div class="label"><h6>Logout</h6></div>
                        </a>
                    </div>    

                </div>
                
            </div>
        </div>
    </div>
    
    <?php provider_bottom_nav(); ?>
    
</body>
</html>