<?php

header('Content-type: application/json');

include('functions.php');

// Register the groupid
$groupid = get_version();

// Set Database Connection
$conn = ddxrxDBConnect();

// Assuming you want to handle pagination and filtering
if( isset($_POST['length']) || isset($_POST['start']) || isset($_POST['search']['value']) ){
    $limit = $_POST['length'];
    $start = $_POST['start'];
    $searchValue = $_POST['search']['value'];
    $draw = $_POST['draw'];
}else{    
    $start = '0';
    $limit = '1000';
    $searchValue = '';
    $draw = 0;
}

if( isset($_GET['month']) && isset($_GET['year']) ){

    $month = $_GET['month'];
    $year = $_GET['year'];

}elseif(isset($_POST['month']) && isset($_POST['year'])) {

    $month = $_POST['month'];
    $year = $_POST['year'];

}else{

    $month = intval(date("n"));
    $year = intval(date("Y"));

}

// SQL Query to fetch data
$sql = "SELECT `patients`.`patient_id`, `patients`.`patient_lname`, `patients`.`patient_fname`, `patients`.`patient_gender`, `patients`.`patient_dob` FROM `cardiowell_users` INNER JOIN `patients` ON `cardiowell_users`.`patient_id` = `patients`.`patient_id` WHERE `cardiowell_users`.`type` = 'bp' AND `patients`.`groupid` = '$groupid'";

// Apply search filter if any
if (!empty($searchValue)) {
    $sql .= " AND (patients.patient_fname LIKE '%" . $searchValue . "%' OR patients.patient_lname LIKE '%" . $searchValue . "%')";
}

$sql .= " LIMIT $start, $limit";

$result = $conn->query($sql);

$data = array();
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {

        // Format Date of Birth to Aug 01, 2000
        $row["patient_dob"] = date("M d, Y", strtotime($row["patient_dob"]));

        // Prepare data
        $data[] = array(
            $row["patient_lname"],
            $row["patient_fname"],
            ($row["patient_gender"] == 'm' || $row["patient_gender"] == 'M') ? 'Male' : 'Female',
            $row["patient_dob"],
            get_first_bp_record($row["patient_id"], $month, $year),
            get_bp_count($row["patient_id"], $month, $year, 'total') . ' Times',
            get_bp_count($row["patient_id"], $month, $year, 'days') . ' Days',
            session_time($row["patient_id"], $month, $year, '20min'),
            exceeded_time($row["patient_id"], $month, $year, 'excess'),
            '<a href="#" class="manual-time-btn" data-patient-id="'.$row['patient_id'].'">Manual Timer</a>'
        );
    }
}

// Get total Record Count
$sqlCount = "SELECT COUNT(*) AS count FROM cardiowell_users INNER JOIN patients ON cardiowell_users.patient_id = patients.patient_id WHERE cardiowell_users.type = 'bp' AND patients.groupid = '$groupid'";
if (!empty($searchValue)) {
    $sqlCount .= " AND (patients.patient_fname LIKE '%" . $searchValue . "%' OR patients.patient_lname LIKE '%" . $searchValue . "%')";
}
$result = $conn->query($sqlCount);
if ($result && $row = $result->fetch_assoc()) {
    $totalRecords = $row["count"];
} else {
    $totalRecords = '0';
}
$conn->close();

// Prepare response
$response = array(
    "draw" => intval($draw),
    "recordsTotal" => $totalRecords,
    "recordsFiltered" => $totalRecords, // Assuming no filtering at the moment
    "data" => $data,
    "month" => date("F", mktime(0, 0, 0, $month, 1)),
    "year" => $year
);

echo json_encode($response);