<?php

header('Content-type: application/json');
header('Access-Control-Allow-Origin: *');

include('functions.php');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function sendOTPRequest( $phoneNumber = null ){
    
    if( isset($phoneNumber) ){
        
        // API URL
        $url = 'https://waitingroom.ai/api/verification';
        
        // Create a new cURL resource
        $ch = curl_init($url);
        
        // Setup request to send json via POST
        $data = array(
            'number' => $phoneNumber
        );
        $payload = json_encode($data);
        
        // Attach encoded JSON string to the POST fields
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        
        // Set the content type to application/json
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        
        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        // Execute the POST request
        $result = curl_exec($ch);
        
        // Close cURL resource
        curl_close($ch);
        
        //$result = json_decode($result);
        
        return $result;
        
    }  
    
}


if( isset($_POST['number']) || $_POST['number'] != '' ){
    
    $result = json_decode( sendOTPRequest( $_POST['number'] ) );
    
    if( $result->status == 'success' ){
        
        $otp_code = $result->otp_number;
        $otp_session = $_POST['otp_session'];
        $ip = getenv('HTTP_CLIENT_IP') ?: getenv('HTTP_X_FORWARDED_FOR') ?: getenv('HTTP_X_FORWARDED') ?: getenv('HTTP_FORWARDED_FOR') ?: getenv('HTTP_FORWARDED') ?: getenv('REMOTE_ADDR');
        
        $sql = "INSERT INTO otp (otp_code, otp_session, ip_address, status) VALUES ('$otp_code', '$otp_session', '$ip', 'pending')";
    
        if (ddxrxDBConnect()->query($sql) === TRUE) {
        
            $finalResult = array(
                'rstatus' => 'success',
                'result_desc' => 'The otp has successfully generated, please check your number'
            );
        
        }
        
    }
    
}else{
    
    $finalResult = array(
        'rstatus' => 'failed',
        'result_desc' => 'Parameter is not valid or empty'
    );
    
}

echo json_encode($finalResult);

?>