<?php
session_start();
include('../process/functions.php'); // Include database connection or helper functions

header('Content-Type: application/json');

if (!isset($_SESSION['userid'])) {
    echo json_encode([
        'result' => false,
        'message' => 'User not logged in.',
        'title' => 'Error',
        'icon' => 'error'
    ]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_SESSION['userid'];
    $uploadDir = '../photo-uploads/';
    $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
    $maxFileSize = 5 * 1024 * 1024; // 5MB

    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['file']['tmp_name'];
        $fileName = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION); // Get file extension
        $fileSize = $_FILES['file']['size'];
        $fileType = mime_content_type($fileTmpPath);

        if (!in_array($fileType, $allowedTypes)) {
            echo json_encode([
                'result' => false,
                'message' => 'Invalid file type. Only JPEG, PNG, and GIF are allowed.',
                'title' => 'Upload Failed',
                'icon' => 'error'
            ]);
            exit;
        }

        if ($fileSize > $maxFileSize) {
            echo json_encode([
                'result' => false,
                'message' => 'File size exceeds the maximum limit of 5MB.',
                'title' => 'Upload Failed',
                'icon' => 'error'
            ]);
            exit;
        }

        // Generate a unique file name (20 characters)
        $uniqueName = substr(bin2hex(openssl_random_pseudo_bytes(10)), 0, 20);
        $newFileName = $uniqueName . '.' . $fileName;
        $destination = $uploadDir . $newFileName;

        if (move_uploaded_file($fileTmpPath, $destination)) {
            // Insert into database
            $conn = ddxrxDBConnect();
            $stmt = $conn->prepare("INSERT INTO uploaded_photos (user_id, image_name) VALUES (?, ?)");
            $stmt->bind_param("is", $userId, $newFileName);

            if ($stmt->execute()) {
                echo json_encode([
                    'result' => true,
                    'message' => 'File uploaded successfully.',
                    'title' => 'Upload Successful',
                    'icon' => 'success',
                    'image_name' => $newFileName
                ]);
            } else {
                echo json_encode([
                    'result' => false,
                    'message' => 'Failed to save file information to the database.',
                    'title' => 'Database Error',
                    'icon' => 'error'
                ]);
            }

            $stmt->close();
            $conn->close();
        } else {
            echo json_encode([
                'result' => false,
                'message' => 'Failed to move the uploaded file.',
                'title' => 'Upload Failed',
                'icon' => 'error'
            ]);
        }
    } else {
        echo json_encode([
            'result' => false,
            'message' => 'No file uploaded or an error occurred.',
            'title' => 'Upload Failed',
            'icon' => 'error'
        ]);
    }
} else {
    echo json_encode([
        'result' => false,
        'message' => 'Invalid request method.',
        'title' => 'Error',
        'icon' => 'error'
    ]);
}
?>