<?php

/**
 * ------------------------------------------ 
 * Set header to JSON
 * ------------------------------------------
*/
header('Content-Type: application/json');



/**
 * ------------------------------------------ 
 * Include the function file
 * ------------------------------------------
*/
include_once('functions.php');



/**
 * ------------------------------------------ 
 * GET THE JSON DATA
 * ------------------------------------------
*/
$data = json_decode(file_get_contents('php://input'), true);



/** 
 * ------------------------------------------
 * CHECK IF KEY(patient_id, month, year) IS SET
 * If not, return an error response
 * ------------------------------------------
*/
if (!isset($data['patient_id']) || !isset($data['month']) || !isset($data['year'])) {
    // If not, return an error response
    $output = [
        'status' => false,
        'status_code' => 400,
        'message' => 'Bad Request, Missing Required Fields',
    ];
    echo json_encode($output);
    exit;
}



/**
 * ------------------------------------------
 * CHECK IF KEY(patient_id, month, year) IS NOT EMPTY and valid number values and correct date format
 * If not, return an error response
 * ------------------------------------------
*/
$patient_id = $data['patient_id'];
$month = $data['month'];
$year = $data['year'];
$items = [];
$temp_array = [];

// Validate patient_id, month, year
if (
    empty($patient_id) || !is_numeric($patient_id) ||
    empty($month) || !is_numeric($month) || $month < 1 || $month > 12 ||
    empty($year) || !is_numeric($year) || strlen((string)$year) != 4
) {
    $output = [
        'status' => false,
        'status_code' => 400,
        'message' => 'Bad Request, Invalid patient_id, month, or year',
    ];
    echo json_encode($output);
    exit;
}


/**
 * ------------------------------------------
 * CHECK IF THE PATIENT ID EXISTS
 * If not, return an error response
 * ------------------------------------------
*/

// Query for vitals_history (BP Count)
$sql = "SELECT vh.*, p.patient_fname, p.patient_lname 
    FROM `vitals_history` vh
    JOIN `patients` p ON p.patient_id = vh.patient_id
    WHERE vh.patient_id = '$patient_id' 
        AND MONTH(vh.date_added) = '$month' 
        AND YEAR(vh.date_added) = '$year' 
    ORDER BY vh.date_added DESC";

$result = ddxrxDBConnect()->query($sql);
$bp_count = 0;

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $date_raw = substr($row['date_added'], 0, 10);
        $temp_array = [$date_raw, $row['systolic'], $row['diastolic'], $row['heartrate'], $row['rhythm'], $row['pulseox'], $row['temp'], $row['glucose'], $row['weight'], $row['dataSource'], $row['patient_fname'], $row['patient_lname']];
        array_push($items, $temp_array);
        $bp_count++;
    }
}

// Query for total session time from timer table
$sql_timer = "SELECT SUM(total_time_in_seconds) as total_session_seconds FROM `timer` WHERE `patient_id` = '$patient_id' AND MONTH(watch_time) = '$month' AND YEAR(watch_time) = '$year'";
$result_timer = ddxrxDBConnect()->query($sql_timer);
$total_session_time = null;
if ($result_timer && $row_timer = $result_timer->fetch_assoc()) {
    if ($row_timer['total_session_seconds'] && $row_timer['total_session_seconds'] > 0) {
        $total_session_time = round($row_timer['total_session_seconds'] / 60, 2);
    }
}


// Check if items is empty
if (empty($items)) {
    $output = [
        'status' => false,
        'status_code' => 404,
        'message' => 'No data found for the given patient_id, month, and year',
    ];
    echo json_encode($output);
    exit;
}

if( !empty($items) ){
    $output = [
        'status' => true,
        'status_code' => 200,
        'message' => 'Data retrieved successfully',
        'bp_count' => $bp_count,
        'total_session_time' => $total_session_time,
        'data' => $items
    ];
    $sendData = json_encode($output);

    // Send data to external API as POST
    $ch = curl_init('http://54.64.130.117/rpm_excel_export');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $sendData);
    $apiResult = curl_exec($ch);
    $curlError = curl_error($ch);
    curl_close($ch);

    // Echo API result or error
    if ($apiResult !== false) {
        echo $apiResult;
    } else {
        echo json_encode([
            'status' => false,
            'status_code' => 500,
            'message' => 'Failed to connect to export API',
            'error' => $curlError
        ]);
    }
    exit;
}