<?php
    
    session_start();
    
    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType'])) {
        header("Location: provider_login.php");
        die();
    }
    if($_SESSION['userType'] != 'nurse' && $_SESSION['userType'] != 'doctor') {
        header("Location: view_record.php");
        die();
    }

    include('process/functions.php');
    
    $version = get_version();
    $patientsResult = mysqli_query(ddxrxDBConnect(), "SELECT * FROM patients WHERE user_id != 0 AND active = 1 AND groupid = '$version' ORDER BY patient_id DESC");
    
?>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Video Call Meetings - DDXRX</title>
        
        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/videocall.css">
        
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        
    </head>
    <body class="nooverflow">
        
        <div class="container optimized-container videocallwrapper">
            <div class="col-md-12">
                
                <?php include('nav/nav_videocall.php'); ?>
                
                <div class="meeting-form-container">
                    
                    <div class="titleBar">
                        <h1>My Meetings</h1>
                        <a href="create-meeting-schedule.php">Schedule a Meeting</a>
                    </div>
                    
                    <div class="schedules">
                        <?php
                        $owner_id = $_SESSION['userid'];
                        $sql = "SELECT * FROM vc_meeting INNER JOIN vc_meeting_attendee ON vc_meeting.id = vc_meeting_attendee.meeting_id WHERE vc_meeting_attendee.source = '$owner_id'";
                        $result = ddxrxDBConnect()->query($sql);
                        
                        if ($result->num_rows > 0) {
                            while($row = $result->fetch_assoc()) {
                                
                                $attendees_list = '';
                                $date = date('M d Y h:i T', $row['epoch_time']);
                                $duration = $row['duration'];
                                $duration_hour = substr($duration, 0, 2);
                                $duration_hour = (string)$duration_hour;
                                $duration_min = substr($duration, 3, 2);
                                $duration_min = (string)$duration_min;
                                $duration_total = '+'.$duration_hour.' hour + '.$duration_min.' minutes';
                                
                                $time_start = date('h:i A', $row['epoch_time']);
                                $time_end = date('h:i A', strtotime($date.$duration_total));
                                
                                // Get Attendees
                                $attendees_data = get_attendees($row['meeting_id']);
                                $attendees_data = $attendees_data['items'];
                                $total_attendee = count($attendees_data);
                                
                                // Get Meeting Attendees
                                for( $x = 0; $x < $total_attendee; $x++ ){
                                    $attendees_list .= '<span class="attendeeItem">'.$attendees_data[$x]['full_name'].'</span>';
                                }
                                
                                /**
                                 * In the class "date-group" you can add extra class called "ended" to indicate that the meeting has expired
                                 */
                                
                                echo '
                                    <div class="date-group">
                                        <h6><ion-icon name="calendar-outline"></ion-icon>'.$date.'</h6>
                                        <div class="items">
                                            <div class="col-md-4">
                                                <p class="label">Meeting Name: <span>'.$row["meeting_name"].'</span></p>
                                            </div>
                                            
                                            <div class="col-md-2">
                                                <p class="label">Time: <span>'.$time_start.' - '.$time_end.'</span></p>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <p class="label">Attendee:<br> '.$attendees_list.'</p>
                                            </div>
                                            
                                            <div class="col-md-2">
                                                <div class="button-group">
                                                    <!--<a href="#" class="button">Start</a> <a href="#" class="button">Edit</a> <a href="#" class="button">Delete</a>-->
                                                    <a href="https://development.ddxrx.net/videocall_stream.php?room_name='.$row['video_call_id'].'" class="button">Join Meeting</a>
                                                </div>
                                            </div>
                                            <div class="clear"></div>
                                        </div>
                                    </div>
                                ';
                                
                            }
                        }else{
                            
                            echo '<div class="warning-notice">There are no scheduled meetings associated with your account at the moment. To create a meeting schedule please click the "Schedule a Meeting" button at the top</div>';
                            
                        }
                        
                        ddxrxDBConnect()->close();
                        ?>
                        
                    </div>
                </div>
                
            </div>
        </div>

        <?php
            if( $_SESSION['user_type'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                physician_bottom_nav();
            }
        ?>

    </body>
</html>
