<?php
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    // Start the session
    session_start();

    // Check if the user is logged in, if not then redirect him/her to login page
    if( !isset($_SESSION['userid']) && !isset($_SESSION['userType']) ){
        header("Location: logout.php");
       exit;
    }

    // Include the functions file
    include('process/functions.php');

    // Assign the connection to a variable
    $con = ddxrxDBConnect();
    

    // Create Custom Functions
    function RemoveBS($Str) {  
        $StrArr = STR_SPLIT($Str); $NewStr = '';
        foreach ($StrArr as $Char) {    
            $CharNo = ORD($Char);
            if ($CharNo == 163) { $NewStr .= $Char; CONTINUE; } // keep � 
            if ($CharNo > 31 && $CharNo < 127) {
                $NewStr .= $Char;    
            }
        }

        return $NewStr;
    }

    function multiexplode ($delimiters,$string) {

        $ready = str_replace($delimiters, $delimiters[0], $string);
        $launch = explode($delimiters[0], $ready);
        return  $launch;
    }

    $vitalFieldLables = new StdClass();
    $vitalFieldLables->systolicBP = 'Systolic BP';
    $vitalFieldLables->diastolicBP = 'Diastolic BP';
    $vitalFieldLables->heartRate = 'Heart Rate';
    $vitalFieldLables->respRate = 'Respiratory Rate';
    $vitalFieldLables->pulseOX = 'Pulse Ox';
    $vitalFieldLables->temp = 'Temperature';
    
    $wid = $_GET['wID'];
    $_SESSION['wID'] = $wid;
    $waitingroomQuery = "Select * from waiting_room left join patients on waiting_room.patient_id = patients.patient_id where waitingroom_id =".$wid;
    $waitingroomResult = mysqli_query($con, $waitingroomQuery);
    $waitingroom = mysqli_fetch_array($waitingroomResult);

    $_SESSION['dd_id']=$_GET['wID'];
    $_SESSION['ss'] = $waitingroom['symptoms'];
    $_SESSION['havingz'] = $waitingroom['havingz'];
    $_SESSION['denied'] = $waitingroom['denied'];
    $vitals = $waitingroom['vital_json'];
    $positive_diagnosis_id = json_decode($waitingroom['diagnosis_id']);
    $negative_diagnosis_id = json_decode($waitingroom['failed_diagnosis_id']);
    if($waitingroom['answers_per_diagnosis'] != "") {
        $answers_per_diagnosis = json_decode($waitingroom['answers_per_diagnosis']);
        $all_diagnosis = new stdClass();
        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
            $diagnosis_query = "Select * from differential_diagnoses where id='". $diagnosis_id ."' limit 1";
            $result_diagnosis_query = mysqli_query($con, $diagnosis_query);
            $diagnosis = mysqli_fetch_array($result_diagnosis_query);
            $all_diagnosis->$diagnosis_id = $diagnosis;
        }
    }
    

    $user_query = "SELECT * FROM all_users WHERE userid='".$_SESSION['userid']."'";
	$run_query = mysqli_query($con, $user_query);
	$count = mysqli_num_rows($run_query);
	$data = mysqli_fetch_array($run_query);
	
	if($count==1) {
		
		if($data['user_type'] == 2) {
			$_SESSION['user_type'] = "doctor";
		} else if($data['user_type'] == 3) {
			$_SESSION['user_type'] = "patient";
		} else if($data['user_type'] == 4) {
			$_SESSION['user_type'] = "nurse";
		}
	}

?>
<!DOCTYPE html>
<html>
    <head>
        <title>Edit Progress Note - DDXRX</title>
        
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta charset="utf-8" http-equiv="X-UA-Compatible" content="IE=edge" />

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/main-menu.css">
        <link rel="stylesheet" type="text/css" href="assets/css/style.css">
        <link rel="stylesheet" type="text/css" href="assets/css/responsive.css">
        <link rel="stylesheet" type="text/css" href="assets/css/search-style-reports.css">
        <link rel="stylesheet" type="text/css" href="assets/css/single-notes-ai.css">

        <script src="https://code.jquery.com/jquery-1.8.2.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <script type="text/javascript" src="assets/js/ddx_reports_ui.js"></script>
        <script type="text/javascript" src="assets/js/dictation-checker.js"></script>
        
        <style>
            #submit{ display: none!important; }
            .vital-label {
                display:inline !important;
                padding-left:30px;
            }
            .check-box {
                margin-top: 5px;
            }
            .results-container {
                margin-top: 10px;
                position: relative;
                /*line-height: 1.5em;*/
            }
            .each_diagnosis {
                border-top:2px solid #ccc;
                padding-top: 15px;
            }
            .additional_treatment {
                min-height: 80px !important;
                width: 60% !important;
            }
            
            .goog-te-banner-frame.skiptranslate {
                display: none !important;
            }
            #goog-gt-tt{
                display:none!important;
            }
            #google_translate_element{
                position: fixed; left:20px; top: 20px; z-index: 9999999;
            }
            .denied-text {
          line-height: 1.8;
           margin-bottom: 20px;
                        }

                        
        </style>
        
        <script>
            jQuery(document).ready(function($){
                $('#submit').remove();
                $('.ui-grid-a').css("margin-top", "50px");
            });
        </script>
        
        <script>
            $(document).ready(function(){

                // $('.dictation-button-container a').click(function(){
                //     $('.additional_info .textarea').val('it works!');
                // });

                var jsonData = JSON.parse('<?php echo $waitingroom['note_selection_json']; ?>');
                
                // Additional Information
                if( jsonData.additional_info != undefined && jsonData.additional_info != '' ){
                    $('textarea[name="additional_info"]').text(jsonData.additional_info);
                }
                
                // Additional Treatment
                if( jsonData.additional_treatment != undefined && jsonData.additional_treatment != '' ){
                    $('textarea[name="additional_treatment"]').text(jsonData.additional_treatment);
                }
                
                if( jsonData.additional_treatment_1 != undefined && jsonData.additional_treatment_1 != '' ){
                    $('textarea[name="additional_treatment_1"]').text(jsonData.additional_treatment_1);
                }
                
                if( jsonData.additional_treatment_2 != undefined && jsonData.additional_treatment_2 != '' ){
                    $('textarea[name="additional_treatment_2"]').text(jsonData.additional_treatment_2);
                }
                
                if( jsonData.additional_treatment_3 != undefined && jsonData.additional_treatment_3 != '' ){
                    $('textarea[name="additional_treatment_3"]').text(jsonData.additional_treatment_3);
                }
                
                if( jsonData.additional_treatment_4 != undefined && jsonData.additional_treatment_4 != '' ){
                    $('textarea[name="additional_treatment_4"]').text(jsonData.additional_treatment_4);
                }
                
                if( jsonData.additional_treatment_5 != undefined && jsonData.additional_treatment_5 != '' ){
                    $('textarea[name="additional_treatment_5"]').text(jsonData.additional_treatment_5);
                }
                
                if( jsonData.additional_treatment_6 != undefined && jsonData.additional_treatment_6 != '' ){
                    $('textarea[name="additional_treatment_6"]').text(jsonData.additional_treatment_6);
                }
                
                if( jsonData.additional_treatment_7 != undefined && jsonData.additional_treatment_7 != '' ){
                    $('textarea[name="additional_treatment_7"]').text(jsonData.additional_treatment_7);
                }
                
                if( jsonData.additional_treatment_8 != undefined && jsonData.additional_treatment_8 != '' ){
                    $('textarea[name="additional_treatment_8"]').text(jsonData.additional_treatment_8);
                }
                
                if( jsonData.additional_treatment_9 != undefined && jsonData.additional_treatment_9 != '' ){
                    $('textarea[name="additional_treatment_9"]').text(jsonData.additional_treatment_9);
                }
                
                if( jsonData.additional_treatment_10 != undefined && jsonData.additional_treatment_10 != '' ){
                    $('textarea[name="additional_treatment_10"]').text(jsonData.additional_treatment_10);
                }
                
                // Checkbox
                // if( jsonData.checkbox_1_11 != undefined && jsonData.checkbox_1_11 != '' ){
                //     //$('#label_1_11').children('.check-box').addClass('checked');
                //     $('#label_1_11 .check-box').addClass('checked');
                //     $('#checkbox_1_11').prop('checked', true);
                // }

                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_1_<?php echo $i; ?> != undefined && jsonData.checkbox_1_<?php echo $i; ?> != '' ){
                        $( '#label_1_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_1_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_2_<?php echo $i; ?> != undefined && jsonData.checkbox_2_<?php echo $i; ?> != '' ){
                        $( '#label_2_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_2_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_3_<?php echo $i; ?> != undefined && jsonData.checkbox_3_<?php echo $i; ?> != '' ){
                        $( '#label_3_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_3_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_4_<?php echo $i; ?> != undefined && jsonData.checkbox_4_<?php echo $i; ?> != '' ){
                        $( '#label_4_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_4_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.checkbox_5_<?php echo $i; ?> != undefined && jsonData.checkbox_5_<?php echo $i; ?> != '' ){
                        $( '#label_5_<?php echo $i; ?> .check-box' ).addClass('checked');
                        $( '#checkbox_5_<?php echo $i; ?>' ).prop('checked', true);
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_1_<?php echo $i; ?> != undefined && jsonData.textfield_1_<?php echo $i; ?> != '' ){
                        $( '#textfield_1_<?php echo $i; ?>' ).val( jsonData.textfield_1_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_2_<?php echo $i; ?> != undefined && jsonData.textfield_2_<?php echo $i; ?> != '' ){
                        $( '#textfield_2_<?php echo $i; ?>' ).val( jsonData.textfield_2_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_3_<?php echo $i; ?> != undefined && jsonData.textfield_3_<?php echo $i; ?> != '' ){
                        $( '#textfield_3_<?php echo $i; ?>' ).val( jsonData.textfield_3_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_4_<?php echo $i; ?> != undefined && jsonData.textfield_4_<?php echo $i; ?> != '' ){
                        $( '#textfield_4_<?php echo $i; ?>' ).val( jsonData.textfield_4_<?php echo $i; ?> );
                    }
                <?php } ?>
                
                <?php for( $i = 1; $i <= 100; $i++ ){ ?>
                    if( jsonData.textfield_5_<?php echo $i; ?> != undefined && jsonData.textfield_5_<?php echo $i; ?> != '' ){
                        $( '#textfield_5_<?php echo $i; ?>' ).val( jsonData.textfield_5_<?php echo $i; ?> );
                    }
                <?php } ?>
                
            });
        </script>

        <!-- TEMPORARY DISABLE TRANSLATION -->
        <!-- <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({pageLanguage: 'en',
            layout:     google.translate.TranslateElement.InlineLayout.SIMPLE,
            autoDisplay: false, 
            includedLanguages: ''}, 'google_translate_element');}
        </script>
        <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> -->
    
    </head>
    
    <?php
    $patient_id = $waitingroom['2'];
    /*
    Hi! I'm Jonathan! If you're wondering why $waitingroom['2'] = patient_id please check var_dump($waitingroom)
    it will show you that the value for patient_id is null but it has an array index of '2' which points to patient's ID
    for some reasons I do not fucking know why it does not show the patient id, who the fuck coded this? Only god knows!
    */
    ?>
    <body data-patient-id="<?php echo $patient_id; ?>">

        <?php include('nav/nav_provider.php'); ?>
        
        <div id="google_translate_element"></div>
        
    	<div class="container">
    		<div class="col-md-12">

                <!-- User info bar -->
    			<div class="user-info-bar">	
    				<ul>
        				<li><img src="images/topbar/name.svg"> <span><strong>Name:</strong> <div class="user-info name"><?php echo $waitingroom['patient_fname'].' '.$waitingroom['patient_lname']; ?></div></span></li>
        				<li><img src="images/topbar/dob.svg"> <span><strong>Date of Birth:</strong> <div class="user-info dob"><?php echo $waitingroom['patient_dob']; ?></div></span></li>
        				<li><img src="images/topbar/gender.svg"> <span><strong>Gender:</strong> <div class="user-info gender"><?php if($waitingroom['patient_gender'] == 'M' || $waitingroom['patient_gender'] == 'm'){ echo 'Male'; }else{ echo 'Female'; } ?></div></span></li>
        				<li><img src="images/topbar/mobile.svg"> <span><strong>Cell:</strong> <div class="user-info cell"><?php echo $waitingroom['cell']; ?></div></span></li>

        				<li class="right"><img src="images/topbar/calendar.svg"> <span><strong>Date of Encounter:</strong> <div class="user-info encounter_date"><?php echo date_format(date_create($waitingroom['checkin_time']),"M/d/Y"); ?></div></span></li>
        				<li class="right"><img src="images/topbar/login.svg"> <span><strong>Encounter ID:</strong> <i class="encounter_id"><div class="user-info waitingroom"><?php echo $waitingroom['waitingroom_id']; ?></div></i></span></li>
    				</ul>
    				<div class="clear"></div>
    			</div>
                <!-- User info bar -->

                <div class="dictation-text"></div>

                 <!-- <div class="dictation-button-container">

                     //Enhanced Dictation 
                    <div class="enhanced-dictation">
                        <h6 class="heading">AI Enhanced Dictation</h6>
                        <div class="items"></div>
                        <a href="#" class="addEnhancedBtn"><div class="inner"><i class="fa-solid fa-circle-plus" aria-hidden="true"></i><span>Add Dictation</span></div></a>
                    </div>
                   

                     //Original Dictation
                    <div class="dictation-original">
                        <h6 class="heading">Physician Dictation</h6>
                        <p class="instructions">This section compiles recorded dictations from physicians, serving as a comprehensive repository. To enhance your entries, simply click on a specific dictation to seamlessly append additional information below. Streamlining your data management for a more efficient workflow</p>
                        <div class="items">
                            <p>Please wait, fetching dictations...</p>
                        </div>
                    </div>
                    // Original Dictation 

                </div>  -->
    		</div>
    	</div>
        
        <div class="container optimized-container typography-entry">
            <div class="col-md-12">
                <div class="results-container provider">
                    <div class="chief_complaints">
                        <?php
                        if($waitingroom['chief_complaints'] != "") {
                        ?>
                            <h6>Chief Complaints:</h6>
                            <ul>
                                <?php
                                $chief_complaints = explode(";", $waitingroom['chief_complaints']);
                                $presentedString = "";
                                $count = 1;
                                $counter = count($chief_complaints);
                                foreach ($chief_complaints as $key => $value) {
                                    $count++;
                                    echo "<li> $value </li>";
                                    $presentedString .= $value;
                                    if ($count < $counter) {
                                        $presentedString .= ", ";
                                    } elseif ($count == $counter) {
                                        $presentedString .= " and ";
                                    }
                                }
                                ?>
                            </ul>
                            <h6>History of present illness:</h6>
                            <p>Patient presented with <?php echo $presentedString; ?></p>
                        <?php
                        } else {
                            echo "<center><h5>No patient data available!</h5></center>";
                            exit();
                        }
                        ?>
                    </div>
                    <div class="diagnosis_and_symptoms">
                        <?php
                        $denied = [];
                        foreach($answers_per_diagnosis as $diagnosis_id => $answers) {
                            $diag = $all_diagnosis->$diagnosis_id;
                            
                            echo "<strong style='color:black; font-size:16; font-weight:bold;'>" . $diag['name'] . ":</strong><br><br>";
                            echo "Patient complained of having " . implode(", ", $answers->positives) . ".<br><br>";
                        
                            $denied = array_merge($denied, $answers->negatives);
                        }
                        
                        ?>
                    </div>
                    <form id="missingDDs" action="view_note.php?wID=<?php echo $wid; ?>" method="post" name="checkboxSelectSelected">
                        <div class="additional_info">
                            <label>
                                <h6>Additional Information</h6>
                                <textarea class="textarea" name="additional_info" placeholder="Type additional information..."></textarea>
                            </label>
                        </div>
                        <div class="checkbox-group">
                            <div class="review_of_system">
                                <h6>Review of System:</h6><br>
                           <?php $clean_denied = array_filter(array_unique($denied), function($val) {
                                    return trim($val) !== '';
                                                });
                              
                                ?>  
                                <p class="denied-text">
    <strong>Patient denied having:</strong> <?php echo implode(", ", $clean_denied); ?>
                                 </p>
                                <br/><br/>
                                <label>
                                    <div class="check-box checked"></div>
                                    <span>All system were reviewed and was found negative except the above in HPI.</span>
                                    <input type="checkbox" class="checkbox" name="review" value="checkbox" checked="checked">
                                    <div class="clear"></div>
                                </label>
                            </div>
                            <div class="vitals">
                                <h6>Vitals</h6>
                                <label>
                                    <div class="check-box checked"></div>
                                    <span>All vitals were reviewed.</span>
                                    <input type="checkbox" class="checkbox" name="vital" value="checkbox" checked="checked">
                                    <br>
                                    <div>
                                        <?php
                                        if($vitals != "") {
                                            $vitalArray = json_decode($vitals);
                                            foreach($vitalArray as $key => $value) {
                                                echo "<b class='vital-label'>".$vitalFieldLables->$key."</b> : ".$value."<br/>";
                                            }
                                        }
                                        ?>
                                    </div>
                                    <div class="clear"></div>
                                </label>
                            </div>
                            <div class="physical_exam">
                            <label>
                            <h6>Physical Exam:</h6>
                                <textarea class="textarea" name="physical_exam" placeholder="Approve normal physical exam">Approve normal physical exam</textarea>
                            </label>
                            <div class="clear"></div>


                               
                                <!-- <label>
                                    <div class="check-box checked"></div>
                                    <span>Approve normal physical exam</span>
                                    <input type="checkbox" class="checkbox" name="physical_exam" value="checkbox" checked="checked">
                                    <div class="clear"></div>
                                </label> -->
                            </div>
                        </div>
                        <?php
                        $negative_diagnosis_names = [];
                        
                        foreach($negative_diagnosis_id as $id) {
                            $diag = $all_diagnosis->$id;
                            $negative_diagnosis_names[] = $diag['name'];
                        }
                        if(sizeof($negative_diagnosis_names) > 0) {
                            echo "Patient less likely have ".implode(", ", $negative_diagnosis_names);
                            echo "<br/><br/>";   
                        }
                        
                        $i = 0;
                        $j = 0;
                        $return = "";
                        
                        foreach($positive_diagnosis_id as $id) {
                            $i = $i + 1;
                            $decision_support_query = "Select * from decision_supports where differential_diagnose_id='".$id."' limit 1";
                            $result_decision_support = mysqli_query($con, $decision_support_query);
                            $decision_support = mysqli_fetch_array($result_decision_support);
                            
                            // Check if $decision_support is valid before proceeding
                            if ($decision_support && isset($decision_support['decisions_edited'])) {
                                $var = trim($decision_support['decisions_edited']);
                                $var = str_replace('</p>', '', $var);
                                $var = str_replace('<br /><br />', '<br />', $var);
                                $var = trim(html_entity_decode($var), " \t\n\r\0\x0B\xC2\xA0");
                                $var = RemoveBS($var);
                                $var = multiexplode(array("<br />", "<p>", "<br>"), $var);
                                $var = array_filter(array_map('trim', $var));
                            } else {
                                // If no decision support data, set $var to an empty array to avoid further errors
                                $var = array();
                            }
                        
                            $diag = $all_diagnosis->$id;
                         
                            $return .= '<div class="each_diagnosis">';
$return .= '<strong style="font-weight:700">' . $i . '. ' . $diag['name'] . '</strong><br/>';

foreach ($var as $key => $value) {
    $isChecked = false;
    $isHeader = false;

    if (strpos($value, '**') !== false) {
        $isChecked = true;
        $value = str_replace('**', '', $value);
    } elseif (strpos($value, '##') !== false) {
        $isHeader = true;
        $value = str_replace('##', '', $value);
    }

    $j++;

    // Handle text fields if () present
    $value = ucfirst(str_replace("()", "<input class='textbox' type='text' name='textfield_{$i}_{$key}'><!--$j-->", $value));
    $content = RemoveBS($value);

    if ($isHeader) {
        // Render as a heading (bold + optional spacing)
        $return .= "<div class='section-header' style='font-weight:bold; margin-top:30px;'>$content</div>";
    } else {
        // Checkbox rendering
        $checkedClass = $isChecked ? 'checked' : '';
        $checkedAttr = $isChecked ? 'checked' : '';

        $return .= "
        <label for='checkbox_{$i}_{$key}' class='checkbox-label'>
            <div class='check-box $checkedClass'></div>
            <span class='inline'>$content</span>
            <input class='checkbox' name='checkbox_{$i}_{$key}' type='checkbox' id='checkbox_{$i}_{$key}' $checkedAttr>
        </label>";
    }
}

                            
                            $return .= '
                            <div class="additional_info">
                                <label>
                                    <h6>Additional Treatment</h6>
                                    <textarea class="textarea additional_treatment" name="additional_treatment_'.$i.'" placeholder="Type additional treatment..."></textarea>
                                </label>
                            </div>';
                            $return .= "</div>";
                        }
                        echo $return;

                        ?>
            
                        <input type="hidden" name="checkbox_selected">
            
                        <input type="reset" name="Submit2" value="Reset" data-mini="true" data-theme="b" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">
                        
                        <input type="submit" name="Submit" value="Next" data-theme="b" data-mini="true" class="button large rounded solid blue" style="display:inline-block!important; width:auto!important;">
        
                    </form>		
            	    <a href="javascript:;"></a>
            	    <div class="clear" style="clear:both"></div>
        		</div>
            </div>
        </div>

        <script>
  document.addEventListener('DOMContentLoaded', function () {
    // Find all textboxes
    document.querySelectorAll('input.textbox').forEach(function (input) {
      const fieldName = input.name;
      const match = fieldName.match(/textfield_(\d+)_(\d+)/);

      if (match) {
        const i = match[1];
        const key = match[2];
        const checkbox = document.getElementById(`checkbox_${i}_${key}`);

        // If there's a matching checkbox
        if (checkbox) {
          // On focus or input, check the checkbox
          input.addEventListener('focus', () => {
            checkbox.checked = true;
            checkbox.parentElement.querySelector('.check-box')?.classList.add('checked');
          });

          input.addEventListener('input', () => {
            if (input.value.trim() !== '') {
              checkbox.checked = true;
              checkbox.parentElement.querySelector('.check-box')?.classList.add('checked');
            } else {
              checkbox.checked = false;
              checkbox.parentElement.querySelector('.check-box')?.classList.remove('checked');
            }
          });
        }
      }
    });
  });
</script>
<!-- form reset code -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const checkboxStates = {};

    // Store initial checkbox states only for those with valid IDs
    document.querySelectorAll('input[type="checkbox"]').forEach(checkbox => {
        if (checkbox.id) {
            checkboxStates[checkbox.id] = checkbox.checked;
        }
    });

    document.querySelector('form#missingDDs').addEventListener('reset', function () {
        setTimeout(() => {
            Object.entries(checkboxStates).forEach(([id, state]) => {
                const checkbox = document.getElementById(id);
                if (checkbox) {
                    checkbox.checked = state;
                    const box = checkbox.parentElement.querySelector('.check-box');
                    if (box) {
                        box.classList.toggle('checked', state);
                    }
                }
            });

            // Optional cleanup (if you want to manually clear fields)
            this.querySelectorAll('input[type="text"], textarea').forEach(el => el.value = '');
        }, 0);
    });
});
</script>



    </body>
</html>

<?php mysqli_close($con); ?>