jQuery(document).ready(function($){
    
    // Toggle on-off
    $('body').on('click', '.anti-coagiation .item img.off', function() {
        $(this).attr("src","assets/images/boticon/switch-yes.png");
        $(this).removeClass('off');
        $(this).addClass('on');
    });
    
    $('body').on('click', '.anti-coagiation .item img.on', function() {
        $(this).attr("src","assets/images/boticon/switch-no.png");
        $(this).removeClass('on');
        $(this).addClass('off');
    });
    
    $('.submit').click(function(){
       
       var patient_id = $('body').data('patient-id');
       
        if( $('.male_sex').hasClass('on') === true  ){
            var male_sex = $('.male_sex').data('value'); 
        }else if( $('.male_sex').hasClass('on') === false ){
            var male_sex = '0';
        }
        
        if( $('.none_white').hasClass('on') === true  ){
            var none_white = $('.none_white').data('value'); 
        }else if( $('.none_white').hasClass('on') === false ){
            var none_white = '0';
        }
        
        if( $('.ulcer_diesease').hasClass('on') === true  ){
            var ulcer_diesease = $('.ulcer_diesease').data('value'); 
        }else if( $('.ulcer_diesease').hasClass('on') === false ){
            var ulcer_diesease = '0';
        }
        
        if( $('.bleeding').hasClass('on') === true  ){
            var bleeding = $('.bleeding').data('value'); 
        }else if( $('.bleeding').hasClass('on') === false ){
            var bleeding = '0';
        }
        
        if( $('.platele_count').hasClass('on') === true  ){
            var platele_count = $('.platele_count').data('value'); 
        }else if( $('.platele_count').hasClass('on') === false ){
            var platele_count = '0';
        }
        
        if( $('.inr').hasClass('on') === true  ){
            var inr = $('.inr').data('value'); 
        }else if( $('.inr').hasClass('on') === false ){
            var inr = '0';
        }
        
        if( $('.active_cancer').hasClass('on') === true  ){
            var active_cancer = $('.active_cancer').data('value'); 
        }else if( $('.active_cancer').hasClass('on') === false ){
            var active_cancer = '0';
        }
        
        if( $('.rheumatic_disease').hasClass('on') === true  ){
            var rheumatic_disease = $('.rheumatic_disease').data('value'); 
        }else if( $('.rheumatic_disease').hasClass('on') === false ){
            var rheumatic_disease = '0';
        }
        
        if( $('.venous_catheter').hasClass('on') === true  ){
            var venous_catheter = $('.venous_catheter').data('value'); 
        }else if( $('.venous_catheter').hasClass('on') === false ){
            var venous_catheter = '0';
        }
        
        if( $('.stroke_history').hasClass('on') === true  ){
            var stroke_history = $('.stroke_history').data('value'); 
        }else if( $('.stroke_history').hasClass('on') === false ){
            var stroke_history = '0';
        }
        
        if( $('.gastrointestinal_bleeding').hasClass('on') === true  ){
            var gastrointestinal_bleeding = $('.gastrointestinal_bleeding').data('value'); 
        }else if( $('.gastrointestinal_bleeding').hasClass('on') === false ){
            var gastrointestinal_bleeding = '0';
        }
        
        if( $('.myocardial_infarction').hasClass('on') === true  ){
            var myocardial_infarction = $('.myocardial_infarction').data('value'); 
        }else if( $('.myocardial_infarction').hasClass('on') === false ){
            var myocardial_infarction = '0';
        }
        
        if( $('.diabetes_mellitus').hasClass('on') === true  ){
            var diabetes_mellitus = $('.diabetes_mellitus').data('value'); 
        }else if( $('.diabetes_mellitus').hasClass('on') === false ){
            var diabetes_mellitus = '0';
        }
        
        if( $('.peptic_ulcer').hasClass('on') === true  ){
            var peptic_ulcer = $('.peptic_ulcer').data('value'); 
        }else if( $('.peptic_ulcer').hasClass('on') === false ){
            var peptic_ulcer = '0';
        }
        
        if( $('.bleeding_episode').hasClass('on') === true  ){
            var bleeding_episode = $('.bleeding_episode').data('value'); 
        }else if( $('.bleeding_episode').hasClass('on') === false ){
            var bleeding_episode = '0';
        }
        
        
        var old_age = $( ".old_age option:selected" ).val();
        var egfr = $( ".egfr option:selected" ).val();
        
        
        $.ajax({
            type: "POST",
            url: 'process/add-anti-coagiation.php',
            
            data:{
                patient_id:patient_id,
                male_sex: male_sex,
                none_white: none_white,
                ulcer_diesease: ulcer_diesease,
                bleeding:bleeding,
                platele_count:platele_count,
                inr:inr,
                active_cancer:active_cancer,
                rheumatic_disease:rheumatic_disease,
                venous_catheter:venous_catheter,
                stroke_history:stroke_history,
                gastrointestinal_bleeding:gastrointestinal_bleeding,
                myocardial_infarction:myocardial_infarction,
                diabetes_mellitus:diabetes_mellitus,
                peptic_ulcer:peptic_ulcer,
                bleeding_episode:bleeding_episode,
                old_age:old_age,
                egfr:egfr
            },
            
            success: function(data){
                
                if( data.result === true ){
                    
                    // Swal.fire({
                    //     icon: 'Success',
                    //     // title: 'Doctor Ai Bleeding Risk Score: Sum',
                    //     'title': Risk Stratification
                    //     text: 'Recommendation',
                    // })
                    
                    Swal.fire({
                      title: 'Bleeding Risk Score: ' + data.sum_score,
                      html: 'Risk stratification: ' + data.risk_stratification + '<br>' + 'Recommendation: ' + data.recommendation,
                      confirmButtonText: 'OK'
                    })
                    
                }
                
            }
        
        });
        
       
    });
 
});