$(document).ready(function() {

    $('.request-call').click(function(){
		
		/*
		Swal.fire({
			type: "success",
			title: "Success",
			text: "Phone Call requested"
		});
		*/
		
		var patient_id = $('body').data('patient-id');
		
		$.ajax({
			type: 'POST',
			url: 'process/phone-call.php',

			data: {
			    patient_id:patient_id
			},

			beforeSend: function() {
			    // Do Something
			},
			success: function(response) {
			    
				Swal.fire({
					  type: response.type,
					  title: response.rstatus,
					  text: response.desc
				});
				
			}

		});
        
    });
    
    
    
    
    $('body').on('click', '.phone-call-dashboard', function() {
        
        var phoneNumber = $(this).parent().siblings('.patient_info').children('.phone').text();
        var patient_id = $(this).parent().parent().data('user-id');
        
        Swal.fire({
            title: phoneNumber,
            text: "Call the number written in the above",
            icon: 'info',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Complete Call',
            cancelButtonText: 'Close'
        }).then((result) => {
            if (result.value) {
                
                $.ajax({
        			type: 'POST',
        			url: 'process/finish-phone-call.php?type=phone_call',
        
        			data: {
        			    patient_id:patient_id
        			},
        			
        			success: function(response) {
        			    
        				Swal.fire({
        					  type: response.type,
        					  title: response.rstatus,
        					  text: response.desc
        				});
        				
        			}
        
        		});
                
            }
        });
        
    });
    
    
    $('body').on('click', '.video-call', function() {
        
        var Fname = $(this).attr('data-name');
        var roomID = $(this).attr('data-room-id');
        var patient_id = $(this).parent().parent().data('user-id');
        var groupId = $(this).parent().parent().data('user-group');
        var phoneNumber = $(this).attr('data-phone');
        
        Swal.fire({
            icon: 'info',
            title: 'Start Video Call?',
            html: "<br><br>" +
                '<button type="button" role="button" tabindex="0" class="SwalBtn1 customSwalBtn" data-button="initiate">Initiate Call</button>' +
                '<button type="button" role="button" tabindex="0" class="SwalBtn2 customSwalBtn" data-button="join">Join Call</button>' +
                '<button type="button" role="button" tabindex="0" class="SwalBtn2 customSwalBtn" data-button="complete">Call Completed</button>',
            showCancelButton: true,
            showConfirmButton: false
        });
        
        $('body').on('click', '.customSwalBtn', function() {
            
            var action = $(this).attr('data-button');
            
            if( action == 'initiate' ){
                
                //window.open('https://clinicians.space/?patient_id='+patient_id+'&type=provider&fname='+Fname+'&lname='+Fname);
                window.open('https://clinicians.space/call.html?user_id='+patient_id+'&phone='+phoneNumber);
                $('body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown)').css("overflow", "visible");
                $('.swal2-container.swal2-center.swal2-backdrop-show').fadeOut();
                
            }else if( action == 'join' ){
                
                window.open('https://clinicians.space/?room='+roomID);
                $('body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown)').css("overflow", "visible");
                $('.swal2-container.swal2-center.swal2-backdrop-show').fadeOut();
                
            }else if( action == 'complete' ){
                
                $.ajax({
        			type: 'POST',
        			url: 'process/finish-phone-call.php?type=video_call',
        
        			data: {
        			    patient_id:patient_id
        			},
        			
        			success: function(response) {
        			    
        				Swal.fire({
        					  type: response.type,
        					  title: response.rstatus,
        					  text: response.desc
        				});
        				
        			}
        
        		});
                
            }
            
        });
        
    });
    
    
    
    
    
    
    
    
    
});