$(document).ready(function(){
    
    $('body').on('click', '.nav.closed', function() {
        $('.sub-menu').show();
        $('.patient-information li.nav').addClass('opened');
        $('.patient-information li.nav').removeClass('closed');
    });
    
    $('body').on('click', '.nav.opened', function() {
        $('.sub-menu').hide();
        $('.patient-information li.nav').addClass('closed');
        $('.patient-information li.nav').removeClass('opened');
    });
    
    
    $('body').on('click', '.patient-information li.nav .sub-menu a', function() {
        //alert( $(this).html() );
    });
    
    
    //Add Template
    $('body').on('click', '.patient-information li.nav .sub-menu a.add-template', function() {
        
        Swal.fire({
            icon: 'info',
            title: 'Add Note Template',
            html: "Choose a template you want to add" +
                "<br><br>" +
                '<button type="button" role="button" tabindex="0" class="SwalBtn1 customSwalBtn" data-source="hnp">' + 'H and P' + '</button>' +
                '<button type="button" role="button" tabindex="0" class="SwalBtn2 customSwalBtn" data-source="consult">' + 'Consult Note' + '</button>' +
                '<button type="button" role="button" tabindex="0" class="SwalBtn2 customSwalBtn" data-source="progress">' + 'Progress Note' + '</button>' +
                '<button type="button" role="button" tabindex="0" class="SwalBtn2 customSwalBtn" data-source="rpm">' + 'RPM Note' + '</button>',
            showCancelButton: true,
            showConfirmButton: false
        });
    
    });
    
    $('body').on('click', '.customSwalBtn', function() {
        var url = $(this).attr('data-source')+'.txt';
        $.get('note-template/'+url, function(data, status){
            editor.setData(data);
        });
        
        $('body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown)').css("overflow", "visible");
        $('.swal2-container.swal2-center.swal2-backdrop-show').fadeOut();
    });
    
    $('body').on('click', '.cancel', function() {
        
    });
    
    $('.tabs li a').click(function(){
        if( $(this).hasClass('new-note-link') == true ){
            
        }else{
            $('.tabs li a').removeClass('current');
            $(this).addClass('current');
        }
    });
    
    // New Note
    $('.note-button').click(function(){
        var note_type = '';
        var status = $('body').data('status');
        var ql_editor = $('.ql-editor').html();
        var patient_id = $('body').data('patient-id');
        var provider_id = $('body').data('provider-id');
        var title = $('.note-textbox').val();
        var note_text = $('.ql-editor').html();
        
        $('.tabs li a').each(function(){
            
            if( $(this).hasClass('current') == true ){
                note_type = $(this).data('type');
            }
            
        });
        
        $.ajax({
			type: 'POST',
			url: 'process/save_note.php',
			data: {
				note_type:note_type,
				note_to:patient_id,
				note_by:provider_id,
				status:status,
				title:title,
				note_text:note_text
			},
			beforeSend: function(){},
			
			success: function(response){
			    
			},
			
			fail: function(response){},
		});
        
    });
    
    

    /* ==================================== */
    /* NEW CODE */
    /* ==================================== */
    
    // Open the note
    $('.open-note').click(function(){
        
        var note_id = $(this).data('note-id');
        var note_type = $(this).data('cctype');
        
        $.ajax({
            type: 'POST',
            url: 'process/open_note.php',
                
            data: {
            	note_id:note_id,
            	note_type:note_type
            },

            success: function(response) {
                
                $('body').prepend('<div class="floating-notes" id="open_note_id_'+note_id+'" data-note-id="'+response.note_id+'"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save edit"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+response.note_title+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here...">'+response.note_text+'</textarea></div>');
        
                // Resizable
                $( ".floating-notes" ).resizable({
                   //alsoResize: ".resizable-editor"
                });
                
                // Drag and drop
                $( ".floating-notes" ).draggable();
                
                console.log( response );
                
            },
            
            fail: function(response){
            	Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
            }
        });
        
    });
    
    
    // Note PLUS Button
    $('body').on('click', '.floating-notes .add', function() {
        
        $('body').prepend('<div class="floating-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save create"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    
    // Close Button
    $('body').on('click', '.floating-notes .close', function() {
        
        $(this).parent().parent().remove();
        
    });
    
    
    // Create Note
    $('body').on('click', '.floating-notes .save.create', function() {
        
        if (typeof $(this).parent().parent().data('note-id') !== 'undefined'){
            
            var note_id = $(this).parent().parent().data('note-id');
            
        }else{ // Create Note
            
            var user_type = $('body').data('user-type');
            var provider_id = '';
            if( user_type == 'doctor' ){
                provider_id = $('body').data('physician-id');
            }else if( user_type == 'nurse' ){
                provider_id = $('body').data('nurse-id');
            }
            
            var save_type = 'new';
            var note_type = $('body').data('cctype');
            var created_by = provider_id;
            var patient_id = $('body').data('patient-id');
            var note_title = $('.resizable-title-bar').val();
            var note_text = $('.resizable-editor').val();
            
            $.ajax({
                type: "POST",
                url: 'process/save_note.php',
                
                data:{
                    patient_id:patient_id,
                    save_type: save_type,
                    note_type: note_type,
                    created_by : created_by,
                    note_title: note_title,
                    note_text: note_text
                },
                
                success: function(data){
                    
                    $('.floating-notes').remove();
                    
                    Swal.fire({
                        position: 'top-end',
                        icon: data.icon,
                        title: data.title,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    
                    $('.dataTable tbody').prepend('<tr><td>'+data.note_title+'</td><td>Today</td><td><a href="javascript:;" class="open-note" data-note-id="'+data.post_id+'">Open Note</a></td></tr>');
                    
                },
                
                fail: function(response){
                
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                    });
                            
                }
            
            });
            
        }
        
    });
    
    
    // New Note
    $('.new-note-button').click(function(){
        
        var cctype = $('body').data('cctype');
        var NoteTitle = '';
        
        if( cctype == 'rpm' ){
            NoteTitle = 'RPM Note';
        }else if( cctype == 'cpm' ){
            NoteTitle = 'CPM Note';
        }
        
        $('body').prepend('<div class="floating-notes rpm-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save create"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+NoteTitle+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea><div class="status"></div></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    // Save Edited Note
    $('body').on('click', '.floating-notes .save.edit', function() {
        
        var note_id = $(this).parent().parent().attr('data-note-id');
        var note_title = $('#open_note_id_'+note_id+' .resizable-title-bar').val();
        var note_editor = $('#open_note_id_'+note_id+' .resizable-editor').val();
        
        $.ajax({
            type: 'POST',
            url: 'process/save_edited_note.php',
                
            data: {
            	note_id:note_id,
            	note_title:note_title,
            	note_editor:note_editor
            },

            success: function(response) {
                Swal.fire({
                    position: 'top-end',
                    icon: response.icon,
                    title: response.title,
                    //text: response.desc,
                    showConfirmButton: false,
                    timer: 1500
                });
            },
            
            fail: function(response){
            	Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
            }
        });
        
    });
    
    
    
});