<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();


include ('includes/database_include.php');
require_once(__DIR__.'/payment/stripe/init.php');

$stripe_config_path = __DIR__.'/payment/stripe_config.php';


require_once($stripe_config_path); // New file added by THS on April 12, 2021

if(defined('STRIPE_MODE') && STRIPE_MODE == 'live'){
    $plans = unserialize(STRIPE_LIVE_PLAN);
    $coupons = unserialize(COUPONS);
}else{
    $plans = unserialize(STRIPE_TEST_PLAN);
    $coupons = unserialize(COUPONS);
}

if(!isset($_SESSION['payment_userid']) || !isset($_SESSION['payment_userType']) || $_SESSION['payment_userType'] != "patient") {
    header("Location: ios-launch.php");
    // echo "session messed up";
    // print_r($_SESSION);
    die();
}

if(!isset($_POST['stripeEmail']) || !isset($_POST['stripeToken']) || !isset($_POST['pricing'])) {
    echo "something is not set";
    print_r($_POST);
    // header('Location: payment_failed.html');
    die();
}

if(!isset($_POST['pricing'])) {
    header("Location: search_dd.php?invalid");
    die();
}

if(isset($_POST['coupon']) && !empty($_POST['coupon'])){
    $coupon = trim($_POST['coupon']);
}else{
    $coupon = '';
}

if(isset($_POST['pricing']) && array_key_exists($_POST['pricing'], unserialize(SUBSCRIPTION_EXPIRED_DAYS))){
    $subscription_expired_days = unserialize(SUBSCRIPTION_EXPIRED_DAYS);
    
    $expired_days = $subscription_expired_days[$_POST['pricing']];
    
    $expired_date = date('Y-m-d', strtotime("+ $expired_days days"));
}else{
    $expired_date = null;
}

// Check Coupon Code 
if(isset($coupon) && !empty($coupon) && array_key_exists($coupon, $coupons) && $coupon == 'Genie2021'){
    
    $insert_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
    
	$run = mysqli_query($con, $insert_query);
	
	if($run) {
        header('Location: thank-you.php');
	} else {
        header('Location: payment_failed.html');
	}
}else if(isset($coupon) && !empty($coupon) && array_key_exists($coupon, $coupons)){
    $trial_period_days = (int) $coupons[$coupon];
}

// echo '<pre>';
// print_r($coupons);
// echo '<hr>';
// print_r($coupon);
// echo '<hr>';
// var_dump(array_key_exists($coupon, $coupons));
// echo '<hr>';
// print_r($trial_period_days);
// exit();



if(!defined('STRIPE_MODE') || (STRIPE_MODE != 'live')) {
    \Stripe\Stripe::setApiKey(STRIPE_TEST_SECRET_KEY);
}else{
    \Stripe\Stripe::setApiKey(STRIPE_LIVE_SECRET_KEY);
}

try {
    $searchPatientQuery = "SELECT * FROM patients WHERE user_id = '".$_SESSION['payment_userid']."'";
    $searchPatientResult = mysqli_query($con, $searchPatientQuery);
    
    // code for recurring monthly subscriptions
    if($_POST['pricing'] != "plan_4") {
        
        $customer_id = "";
        
        if (mysqli_num_rows($searchPatientResult) > 0) {
            
            $patient = mysqli_fetch_array($searchPatientResult);
            $customer_id = $patient['stripe_customer_id'];
            $customerObj = $patient['stripe_customer_body'];
        }
        
        if($customer_id == "") {
            
            $customer = \Stripe\Customer::create([
                'email' => $_POST['stripeEmail'],
                'source'  => $_POST['stripeToken'],
            ]);
            
            $customer_id = $customer->id;
            $customerObj = json_encode($customer);
        }
        
        $subscription_data = [];
        
        $subscription_data['customer'] = $customer_id;
        $subscription_data['items'] = [['plan' => $plans[$_POST['pricing']]]];
        
        // $subscription_data['trial_from_plan'] = true;
            
        if(isset($trial_period_days) && $trial_period_days > 0){
            $subscription_data['trial_period_days'] = $trial_period_days;
        }
		
		if($_POST['pricing'] == "plan_3" && !empty($coupon)){  // if plan is $20 then need to apply coupon
		
		  //  $subscription_data['coupon'] = $coupon;
			
        }
        
        $subscription = \Stripe\Subscription::create($subscription_data);
        
        if ($subscription->status != 'incomplete') {
            
        	$insert_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_customer_id = '".$customer_id."', stripe_customer_body = '".$customerObj."', stripe_subscription_id = '".$subscription->id."', stripe_subscription_body = '".json_encode($subscription)."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
        	$run = mysqli_query($con, $insert_query);
        	
        	if($run) {
                header('Location: thank-you.php');
        	} else {
                header('Location: payment_failed.html');
        	}
        	
        } else {
            
            header('Location: payment_failed.html');
            error_log("failed to collect initial payment for subscription");
        }
        
        exit;
    } else if($_POST['pricing'] == "plan_4") {
        

        $customer = \Stripe\Customer::create([
            'email' => $_POST['stripeEmail'],
            'source'  => $_POST['stripeToken'],
        ]);
            
        $customer_id = $customer->id;
        
        // code for one time payment of $40
        $charge = \Stripe\Charge::create([
            'amount' => 4000,
            'currency' => 'usd',
            'description' => 'DDxRx One Month Subscription',
            'customer' => $customer_id,
        ]);
        
        // print_r($charge);
        if ($charge->status == 'succeeded') {
        	$insert_query = "UPDATE patients SET stripe_plan_type =  '".$_POST['pricing']."', subscription_expired_date =  '".$expired_date."', stripe_subscription_isactive = true WHERE user_id=".$_SESSION['payment_userid'];
        	$run = mysqli_query($con, $insert_query);
        	
        	if($run) {
                header('Location: thank-you.php');
        	} else {
                header('Location: payment_failed.html');
        	}
        } else {
            header('Location: payment_failed.html');
            error_log("failed to collect initial payment for subscription");
        }
        exit;
    }else{
        echo '<pre>';
        print_r($_POST);
        exit();
        
        header('Location: payment_failed.html');
    }
} catch(Exception $e) {
    error_log("unable to sign up customer:" . $_POST['stripeEmail'].
    ", error:" . $e->getMessage());
    echo $e->getMessage();
}
?>