$(document).ready(function(){
    
    //localStorage.setItem("symptoms", "");
    localStorage.setItem("entity", "");
    
    // Declare variable
    var inputSymptoms = [];
    var multipleAnswers = [];
    var multipleAnswers_raw = [];
    
    // Function to remove duplicate from array
    function remove_arrayDuplicate(arr){
        var tmp = [];
        for(var i = 0; i < arr.length; i++){
            if(tmp.indexOf(arr[i]) == -1){
            tmp.push(arr[i]);
            }
        }
        return tmp;
    }
    
    // Function to forward symptoms to search_dd.php
    function forward_search(){
        
        var text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        if( inputSymptoms.length == '1' ){
            inputSymptoms.push("Nothing else");
        }
        inputSymptoms = remove_arrayDuplicate(inputSymptoms);
        
        var i, len, text;
        for (i = 0, len = inputSymptoms.length, text = ""; i < len; i++) {
            $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="'+inputSymptoms[i]+'">');
            console.log( inputSymptoms[i] );
        }
        
        window.location.replace('search_dd.php'+text);
        $('#formddX').append('<input type="submit" id="submitbotsearch">');
        $('#submitbotsearch').click();
        
        
        
    }
    
    
    // Auto Redirect/Submit
    function auto_submit(){
        
        // Regular Submit
        if( inputSymptoms.length >= 4 ){
            
            Swal.fire({
                title: 'Success',
                text: "Let's narrow down diagnostic options.",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
        }
        
        
        // Follow up auto submit
        var arrstring = inputSymptoms.toString();
        var ArrSearchResult = arrstring.search('follow-up') !== -1;
        if( ArrSearchResult == true ){
            
            Swal.fire({
                title: 'Success',
                text: "We will forward you with the results",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
        }
        
    }
    
    
    // FUnction to send symptoms
    function sendSymptoms(){
        
        var user_id = '1';
        var userInput = $('.search_phrase').val();
        var entity = localStorage.getItem("entity");
        
        var sendData = {
            "user_id" : user_id,
            "question" : userInput,
            "entity" : entity
        };
        
        $.ajax({
            type: "POST",
            url: 'https://ddxrx.ai',

            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            beforeSend: function() {
                $('.response-container h1').text('Thinking . . .');
                $('.response-container h1').addClass('thinking');
                $('.bot-reaction').removeClass('idle');
                $('.bot-reaction').addClass('thinking'); 
                $('.form-container .textbox').addClass('thinking');
                $('.common-symptoms h6').addClass('thinking');
            },

            success: function(data){
                
                if( data.response == 'success' && data.type == 'type5' ){
                    
                    if( data.symptoms !== undefined ){
                                
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                                
                    }else if( data.symptoms !== undefined ){
                                
                        // Add data to array
                        inputSymptoms.push( data.symptoms );
                                
                    }
                    
                    // Auto Search
                    auto_submit();
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                        
                    // Set The Entity Value In storage
                    localStorage.setItem("entity", data.symptoms);
                        
                    if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                        
                        $('.option_symptoms ol').html(''); // Reset the symptom option container  
                        $('.option_symptoms ul').html(''); // Reset the symptom option container
                        $('.option_symptoms').fadeIn(); // Show the symptoms option container
                        
                        let result = data.symptoms_data;
            			for (let user_options of result) {
                			//console.log( user_options.option.Question );
                	        $('.option_symptoms ul').append('<li class="enabled"><div class="overlay">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
            	        }
                    } // End of if else
                        
                    // Only show none of the above where there are options
                    if( data.symptoms_data.length > 0 ){
                        $('.option_symptoms ul').append('<li class="none-of-above enabled"><div class="overlay">None of the above</div>None of the above</li>');
                    }
            			
            		// Search Form
            		$('.form-container').hide();
            			
                }
                
                
                // Type 6
                if( data.response == 'success' && data.type == 'type6' ){
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    $('.form-container').hide();
                    
                    $('.front-social-media').hide();
                    $('.common-symptoms').hide();
                    $('.option_symptoms').hide();
                    $('.button-container').remove();
                    $('.response-container').append('<div class="button-container"><a href="'+data.link+'">Click Here</a></div>');
                    
                }
                
                // Type 7
                if( data.response == 'success' && data.type == 'type7' ){
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    $('.form-container').hide();
                    
                    $('.button-container').hide();
                    $('.error-report').show();
                	$('.error-report ul').html('');
                    
                    let result = data.symptoms_data;
            		for (let user_options of result) {
                	    
                	    if("link" in user_options){
                	        var optionLink = user_options.link;
                	        var cssclass = 'none';
                	    }else{
                	        var optionLink = 'javascript:;';
                	        var cssclass = 'back-to-main';
                	    }
                	    
                	    $('.error-report ul').append('<li><a href="'+optionLink+'" class="'+cssclass+'">'+user_options.option.question+'</a></li>');
                	    
            	    }
                
                }

            },
            
            failure: function(errMsg) {
                
                $('.response-container h1').text('I am malfunctioning! Try again later.');
                $('.bot-reaction').removeClass('thinking');
                $('.bot-reaction').addClass('angry');

            }
            
        });
        
    }
    
    
    // Search Result Click
    
    $('body').on('click', '.ac_results li', function() {
        $('.textbox').val( $(this).text() );
        sendSymptoms();
    });
    
    // Common Symptoms
    $('body').on('click', '.common-symptoms a', function() {
        var symptom = $(this).attr('data-symptoms');
        $('.textbox.search_phrase').val(symptom);
        sendSymptoms();
    });
    
    // Refresh Button
    $('body').on('click', '.form-container .button.refresh', function() {
        //location.reload();
        $('.form-container .textbox').val('');
        refreshBot();
    });
    
    // Send Symptoms
    $('body').on('click', '.form-container .button.send', function() {
        sendSymptoms();
    });
    
    
    
    /* ==================================================== */
    // Multi Options 
    /* ==================================================== */
    $('body').on('click', '.option_symptoms li .overlay', function() {
        
        multipleAnswers = '';
        multipleAnswers_raw = [];
        
        if( $(this).parent().hasClass('checked') === true ){
            
            $(this).parent().removeClass('checked');
            
        }else{
            
            $(this).parent().addClass('checked');
            
        }
        
        $(".option_symptoms li.checked").each(function(i){
            
            var separator = '';
            
            if( $(".option_symptoms li.checked").last().index() == i ){
                separator = '';
            }else{
                separator = '$';
            }
            
            multipleAnswers = multipleAnswers+$('.overlay',this).text()+separator;
            multipleAnswers_raw.push( $(this).text() );
            
        });
        
    });
    
    $('body').on('click', '.send_mult_ans', function() {
        
        if( multipleAnswers !== '' ){
            
            var sendData = {
                "question" : multipleAnswers,
            };
            
            $.ajax({
                type: "POST",
                url: 'https://ddxrx.ai/questionSearch',
            
                data: JSON.stringify(sendData),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                        
                beforeSend: function() {
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking');
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                    $('.option_symptoms').fadeOut();
                    $('.option_symptoms ul').html('');
                },
            
                success: function(data){
                    
                    setTimeout(function(){
                        
                        // Display Response
                        $('.response-container h1').text(data.text);
                        
                        // Find and replace $ sign to , comma from response
                        var i;
                        for (i = 0; i < 10; i++) {
                            var text = $('.response-container h1').text();
                            $('.response-container h1').text(text.replace('$', ' + '));
                        }
                        
                        //$('.response-container h6').text(data.symptoms);
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                        // Add data to array
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                        
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        //localStorage.setItem("symptoms", inputSymptoms);
                        
                        // Auto Search
                        auto_submit();
                        
                        if( inputSymptoms.length <= 3 ){
                            //if( inputSymptoms.length != 1 ){
                                Swal.fire({
                                    title: 'Success',
                                    text: "Do you want to add more symptoms",
                                    icon: 'warning',
                                    showCancelButton: true,
                                    confirmButtonColor: '#3085d6',
                                    cancelButtonColor: '#2ecc71',
                                    confirmButtonText: 'No',
                                    cancelButtonText: 'Yes',
                                  
                                }).then((result) => {
                                    if (result.value) {
                                    
                                    forward_search();
                                    
                                    }
                                })
                            //}
                        }
                        
                        $('.form-container').show();
                        
                    }, 1000);
                    
                },
                        
                failure: function(errMsg) {
            
                }
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Error...',
                text: 'Answer cannot be empty, please choose atleast one to proceed',
            })
            
        }
        
    });
    
    // None of the above got clicked
    $('body').on('click', '.option_symptoms li.none-of-above.enabled', function() {
        
        $('.response-container h1').html('Please enter a new symptom');
        $('.option_symptoms').hide();
        $('.form-container').show();
    
    });
    
    
    /* ==================================================== */
    /* Navigation Menu */
    /* ==================================================== */
    $('body').on('click', '.nav-menu.open', function() {
        
        $('.wrapper').addClass('blur');
        $('#particles-js').addClass('blur');
        $('.nav-container').addClass('show');
        
        $('.nav-menu.open').addClass('close');
        $('.nav-menu.open').removeClass('open');
        
    });
    
    //$('.nav-menu.close').click(function(){
    $('body').on('click', '.nav-menu.close', function() {
        
        $('.wrapper').removeClass('blur');
        $('#particles-js').removeClass('blur');
        $('.nav-container').removeClass('show');
        
        $('.nav-menu.close').addClass('open');
        $('.nav-menu.close').removeClass('close');
        
    });
    
    
    
    // Refresh Bot
    function refreshBot(){
        
        $('.response-container h1').html('How may I help you?');
        
        localStorage.setItem("entity", "");
    
        // Declare variable
        inputSymptoms = [];
        multipleAnswers = [];
        multipleAnswers_raw = [];
        
        text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        arrstring = inputSymptoms.toString();
        ArrSearchResult = arrstring.search('follow-up') !== -1;
        symptom = $(this).attr('data-symptoms');
        
        user_id = '1';
        userInput = $('.search_phrase').val();
        entity = localStorage.getItem("entity");
                
        sendData = '';
        
        text = '';
        i = '';
        separator = '';
        sendData = '';
        
        
        Swal.fire({
            icon: 'info',
            title: 'Bot Refreshed',
            text: "Bot's memory has been refreshed",
        });
        
    }
    
    // Menu Bar Height
    var NavHeight = $('.menu-bar').outerHeight();
    NavHeight = NavHeight+100;
    $('.menu-bar-spacer').css("height", NavHeight);
    
    
    // Back Button
    $('body').on('click', '.back-to-main', function() {
        
        $('.error-report').hide();
        $('.form-container').show();
        $('.common-symptoms').show();
        
    });
    
    
});