jQuery(document).ready(function($){
	//$('.delete-note').click(function(){
	$('.patient-notes').on('click', '.delete-note', function() {
		
		var note_id = $(this).data('id');

		// Trigger dialog box
		Swal.fire({
			title: 'Delete Progress Note?',
		  	text: "Are you sure you want to delete this note?",
		  	type: 'warning',
		  	showCancelButton: true,
		  	confirmButtonColor: '#3085d6',
		  	cancelButtonColor: '#d33',
		  	confirmButtonText: 'Delete'
		}).then((result) => {
			if (result.value) {

				// Start Ajax
				$.ajax({
					type: 'POST',
					url: 'process/delete_progress_note.php',

					data: {
						note_id:note_id,
					},

					beforeSend: function() {
					    // Do Something
					},
					success: function(response) {
						
						if( response == 'true' ){

							console.log('True: '+response);

							// Show Dialog Box
							Swal.fire({
							  	position: 'top-center',
							  	type: 'success',
							  	title: 'Note has been deleted',
							  	showConfirmButton: false,
							  	timer: 2500
							});

							// Change Background Color
							$('#record_'+note_id).css("border", "2px solid #ff7675");

							// Delete Row
							setTimeout(function() {
								$('#record_'+note_id).remove();
							}, 2000);
							

						}else{

							console.log('False: '+response);

							// Show Dialog Box
							Swal.fire({
							  	position: 'top-center',
							  	type: 'warning',
							  	title: 'Opps, Something went wrong! Please try again.',
							  	showConfirmButton: false,
							  	timer: 2500
							});

						}

					},
					
					fail: function(response){
						
						console.log('Fail: '+response);

						Swal.fire({
						  	position: 'top-center',
						  	type: 'warning',
						  	title: 'Opps, Something went wrong! Please try again.',
						  	showConfirmButton: false,
						  	timer: 2500
						});

					}

				});
				// End Ajax
			    
			}
		});

	});
});