<?php 

require_once(__DIR__.'/stripe-php-7.80.0/init.php');
require_once(__DIR__.'/stripe_config.php'); // New file added by THS on April 12, 2021

Class CustomStripe {
    protected $stripe;
    private $response;
    function __construct(){
        
        // Initialize Stripe
        if(!defined('STRIPE_MODE') || (STRIPE_MODE != 'live')) {    
            $this->stripe = new \Stripe\StripeClient(STRIPE_TEST_SECRET_KEY);
        
        }else{
            $this->stripe = new \Stripe\StripeClient(STRIPE_LIVE_SECRET_KEY);
        }
        
        $this->response = array('status' => '', 'type' => '', 'code' => '', 'param' => '', 'message' => '', 'data' => new stdClass());
    }
    
    public function retrieve_customer($customer_id, $return_param = array()){
        try{
            $this->response['data'] = $this->stripe->customers->retrieve($customer_id, []);
            $this->response['status'] = 200;
        }
        // catch(\Stripe\Exception\CardException $e) {
        //     // Since it's a decline, \Stripe\Exception\CardException will be caught
        //     $this->response['status'] = $e->getHttpStatus();
        //     $this->response['type'] = $e->getError()->type;
        //     $this->response['code'] = $e->getError()->code;
        //     $this->response['param'] = $e->getError()->param;
        //     $this->response['message'] = $e->getError()->message;
        // } catch (\Stripe\Exception\RateLimitException $e) {
        //     // Too many requests made to the API too quickly
        //     $this->response['status'] = $e->getHttpStatus();
        //     $this->response['type'] = $e->getError()->type;
        //     $this->response['code'] = $e->getError()->code;
        //     $this->response['param'] = $e->getError()->param;
        //     $this->response['message'] = $e->getError()->message;
        // } catch (\Stripe\Exception\InvalidRequestException $e) {
        //     // Invalid parameters were supplied to Stripe's API
        //     $this->response['status'] = $e->getHttpStatus();
        //     $this->response['type'] = $e->getError()->type;
        //     $this->response['code'] = $e->getError()->code;
        //     $this->response['param'] = $e->getError()->param;
        //     $this->response['message'] = $e->getError()->message;
        // } catch (\Stripe\Exception\AuthenticationException $e) {
        //     // Authentication with Stripe's API failed
        //     // (maybe you changed API keys recently)
        //     $this->response['status'] = $e->getHttpStatus();
        //     $this->response['type'] = $e->getError()->type;
        //     $this->response['code'] = $e->getError()->code;
        //     $this->response['param'] = $e->getError()->param;
        //     $this->response['message'] = $e->getError()->message;
        // } catch (\Stripe\Exception\ApiConnectionException $e) {
        //     // Network communication with Stripe failed
        //     $this->response['status'] = $e->getHttpStatus();
        //     $this->response['type'] = $e->getError()->type;
        //     $this->response['code'] = $e->getError()->code;
        //     $this->response['param'] = $e->getError()->param;
        //     $this->response['message'] = $e->getError()->message;
        // } catch (\Stripe\Exception\ApiErrorException $e) {
        //     // Display a very generic error to the user, and maybe send
        //     // yourself an email
            
        // } 
        
        catch (Exception $e) {
            $this->error_handaler($e);
            // Something else happened, completely unrelated to Stripe
        }
        
        return $this->response;
    }
    
    public function update_customer($customer_id, $data){
        $this->stripe->customers->update($customer_id, ['metadata' => ['order_id' => '6735']]);
    }
    
    public function update_customer_default_source($customer_id, $card_id){
        try{
            $this->response['data'] = $this->stripe->customers->update($customer_id, ['invoice_settings' => ['default_payment_method' => $card_id]]);
            $this->response['status'] = 200;
            
        }catch(Exception $e){
            $this->error_handaler($e);
        }
        
        return $this->response;
    }
    
    public function create_customer($data = array()){
        try{
            $this->response['data'] = $this->stripe->customers->create($data);
            $this->response['status'] = 200;
        }catch (Exception $e) {
            $this->error_handaler($e);
            // Something else happened, completely unrelated to Stripe
        }
        
            // [
            //     'description' => 'My First Test Customer (created for API docs)',
            // ]
            // );
        return $this->response;
    }
    
    public function create_card($customer_id, $data = array()){
        if(isset($customer_id) && !empty($customer_id) && !empty($data)){
            $cardObject = array();
            
            $cardObject['address_line1'] = array_key_exists('street_address', $data) ? $data['street_address'] : '';
            $cardObject['address_city'] = array_key_exists('billing_city', $data) ? $data['billing_city'] : '';
            $cardObject['address_state'] = array_key_exists('address_state', $data) ? $data['address_state'] : '';
            $cardObject['address_zip'] = array_key_exists('billing_zip', $data) ? $data['billing_zip'] : '';
            $cardObject['name'] = array_key_exists('name', $data) ? $data['name'] : '';
            // $cardObject['source'] = array_key_exists('token', $data) ? $data['token'] : '';
            
            
            try{
                $this->response['data'] = $this->stripe->customers->createSource($customer_id, ['source' => $data['token']]);
            }catch(Exception $e){
                $this->error_handaler($e);
            }
        }
        
        return $this->response;
    }
    
    private function error_handaler($e){
        $this->response['status'] = $e->getHttpStatus();
        $this->response['type'] = $e->getError()->type;
        $this->response['code'] = $e->getError()->code;
        $this->response['param'] = $e->getError()->param;
        $this->response['message'] = $e->getError()->message;
    }
}