<?php

    session_start();
    if( $_SESSION['userType'] != 'doctor' && $_SESSION['userType'] != 'nurse' ) {
        header("Location: provider_login.php");
        die();
    }
    date_default_timezone_set('America/Chicago');
    
    include('process/functions.php');

?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
	<title>RPM Time</title>
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
    <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
    <link rel="stylesheet" type="text/css" href="assets/css/jquery-ui.min.css">
    <link rel="stylesheet" type="text/css" href="assets/css/vitals_history.css">
    <link rel="stylesheet" type="text/css" href="assets/css/dashboard_responsive.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css">
	
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	<script type="text/javascript" src="//cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js"></script>
	<script type="text/javascript" src="assets/js/jquery-ui-drag-and-drop.min.js"></script>
	<script type="text/javascript" src="assets/js/vitals_history.js"></script>
	
	<script type="text/javascript">
	    $(document).ready(function(){
	        
	        // Load DataTable JS
            $('#more-than-twenty').DataTable({
                "pageLength": 100,
                "order": [[ 4, "asc" ]]
            });
            
            $('#less-than-twenty').DataTable({
                "pageLength": 100,
                "order": [[ 4, "asc" ]]
            });
            
        });
	</script>
	
	<style>
	    .selectbox{
	        padding: 10px;
	        margin-bottom: 20px;
	        border: 1px solid #BBBBBB;
	    }
	    
	    .submit{
	        padding: 10px;
	    }
	    
	    .result-status{
	        font-size: 20px;
	        float: right;
	        margin-top: 10px;
	    }
	    .result-status li{
	        float: left;
	        margin-right: 10px;
	    }
	    .result-status li:last-child{
	        margin-right: 0px;
	    }
	    .result-status strong{
	        font-weight: 700;
	    }
	</style>
	
</head>
<body data-patient-id="<?php if( isset($_GET['patient_id']) ){ echo $_GET['patient_id']; } ?>" data-user-type="<?php echo $_SESSION['user_type']; ?>" <?php if( $_SESSION['user_type'] == 'nurse' ){ echo 'data-nurse-id="'.$_SESSION['userid'].'"'; } ?> <?php if( $_SESSION['user_type'] == 'doctor' ){ echo 'data-physician-id="'.$_SESSION['userid'].'"'; } ?> data-cctype="<?php echo $cctype; ?>">
    
    <?php
        if( isset($_GET['month']) && isset($_GET['year']) && isset($_GET['type']) ){
            $year = $_GET['year'];
            $month = $_GET['month'];
            $type = $_GET['type'];
        }else{
            $year = date('Y');
            $month = date('n');
            $type = 'ccm';
        }
    ?>
    
    <!-- Header -->
    <div class="header">
        <div class="container">
            
            <div class="padded">
                <div class="patient-info">
                    <h3 class="tabtitle">20 Minute Dashboard</h3>
                    <div class="clear"></div>
                </div>
            </div>
            
            
            
        </div>
        
        <div class="menu-container">
            <?php include('nurse_dashboard_nav.php'); ?>
            <div class="clear"></div>
        </div>
        
    </div>
    <!-- Header -->
    
    <div class="container" style="position: relative">
        <div class="TableContainer">
            
            <form action="rpm_time.php" method="GET">
                <select name="type" class="selectbox">
                    <option value="ccm" <?php if( $type == 'ccm' ){ echo 'selected'; } ?>>CCM</option>
                    <option value="rpm" <?php if( $type == 'rpm' || $type != '' ){ echo 'selected'; } ?>>RPM</option>
                </select>
                
                <select name="month" class="selectbox">
                    <option value="">Select Month</option>
                    <option value="1" <?php if( $month == '1' ){ echo 'selected'; } ?>>January</option>
                    <option value="2" <?php if( $month == '2' ){ echo 'selected'; } ?>>February</option>
                    <option value="3" <?php if( $month == '3' ){ echo 'selected'; } ?>>March</option>
                    <option value="4" <?php if( $month == '4' ){ echo 'selected'; } ?>>April</option>
                    <option value="5" <?php if( $month == '5' ){ echo 'selected'; } ?>>May</option>
                    <option value="6" <?php if( $month == '6' ){ echo 'selected'; } ?>>June</option>
                    <option value="7" <?php if( $month == '7' ){ echo 'selected'; } ?>>July</option>
                    <option value="8" <?php if( $month == '8' ){ echo 'selected'; } ?>>August</option>
                    <option value="9" <?php if( $month == '9' ){ echo 'selected'; } ?>>September</option>
                    <option value="10" <?php if( $month == '10' ){ echo 'selected'; } ?>>October</option>
                    <option value="11" <?php if( $month == '11' ){ echo 'selected'; } ?>>November</option>
                    <option value="12" <?php if( $month == '12' ){ echo 'selected'; } ?>>December</option>
                </select>
                
                <select name="year" class="selectbox">
                    <option value="">Select Year</option>
                            
                    <?php
                    $year = date('Y');
                    $start_year = '2015';
                    for ($x = $start_year; $x <= $year; $x++) {
                    ?>
                        <option value="<?php echo $x; ?>" <?php if( $year == $x ){ echo 'selected'; } ?>><?php echo $x; ?></option>
                    <?php } ?>
                </select>
                
                <input type="submit" value="Filter Results" class="submit">
                
                <ul class="result-status">
                    <li>Type: <strong style="text-transform: uppercase"><?php echo $type; ?></strong></li>
                    <li>Year: <strong><?php echo $year; ?></strong></li>
                    <li>Month: <strong><?php echo $month; ?></strong></li>
                </ul>
                
            </form>
            
            <table id="more-than-twenty" class="timeTableDate">
            	<thead>
                    <tr>
                        <td>First Name</td>
                        <td>Last Name</td>
                        <td>Mobile No.</td>
                        <td>Birth Date</td>
                        <td>Total Time</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                <?php
                    $group_id = get_version();
                    $provider_id = $_SESSION['userid'];
                    //$sql = "SELECT timer.patient_id, patients.patient_fname, patients.patient_lname, patients.cell, patients.patient_dob, ROUND(SUM(timer.total_time_in_seconds)/60) as time_in_minutes FROM `timer` LEFT JOIN patients ON timer.patient_id = patients.patient_id WHERE MONTH(timer.watch_time) = '$month' AND YEAR(timer.watch_time) = '$year' AND timer.provider_id = '$provider_id' AND cctype = '$type' AND timer.total_time_in_seconds >=1200 GROUP BY timer.patient_id ORDER BY time_in_minutes DESC";
                    $sql = "SELECT timer.patient_id, patients.patient_fname, patients.patient_lname, patients.cell, patients.patient_dob, ROUND(SUM(timer.total_time_in_seconds)/60) as time_in_minutes FROM `timer` LEFT JOIN patients ON timer.patient_id = patients.patient_id WHERE patients.groupid = '$group_id' AND MONTH(timer.watch_time) = '$month' AND YEAR(timer.watch_time) = '$year' AND timer.cctype = '$type' GROUP BY timer.patient_id HAVING time_in_minutes >= 20 ORDER BY time_in_minutes DESC";
                    
                    $result = ddxrxDBConnect()->query($sql);
                    
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            
                            if( isset($row["patient_fname"]) && isset($row["patient_lname"]) ){
                             
                                echo '<tr>';
                                    echo '<td>' . $row["patient_fname"] . '</td>';
                                    echo '<td>' . $row["patient_lname"] . '</td>';
                                    echo '<td>' . $row["cell"] . '</td>';
                                    echo '<td>' . $row["patient_dob"] . '</td>';
                                    echo '<td>' . $row["time_in_minutes"] . ' Minutes</td>';
                                echo '</tr>';
                            
                            }
                                
                        }
                    } else {
                        //echo "0 results";
                    }
                    
                    ddxrxDBConnect()->close();
                ?>
                    
                </tbody>
            </table>
            
            <table id="less-than-twenty" class="timeTableDate">
            	<thead>
                    <tr>
                        <td>First Name</td>
                        <td>Last Name</td>
                        <td>Mobile No.</td>
                        <td>Birth Date</td>
                        <td>Total Time</td>
                    </tr>
                </thead>
    
                <tbody>
                    
                <?php
                    
                    $group_id = get_version();
                    $provider_id = $_SESSION['userid'];
                    //$sql = "SELECT timer.patient_id, patients.patient_fname, patients.patient_lname, patients.cell, patients.patient_dob, ROUND(SUM(timer.total_time_in_seconds)/60) as time_in_minutes FROM `timer` LEFT JOIN patients ON timer.patient_id = patients.patient_id WHERE MONTH(timer.watch_time) = '$month' AND YEAR(timer.watch_time) = '$year' AND timer.provider_id = '$provider_id' AND cctype = '$type' AND timer.total_time_in_seconds <1200 GROUP BY timer.patient_id ORDER BY time_in_minutes DESC";
                    $sql = "SELECT patients.patient_id, patients.patient_fname, patients.patient_lname, patients.cell, patients.patient_dob, IFNULL(cal.time_in_minutes, 0 ) as time_in_minutes FROM patients LEFT JOIN(SELECT timer.patient_id, patients.patient_fname, patients.patient_lname, patients.cell, patients.patient_dob, ROUND(SUM(timer.total_time_in_seconds)/60) as time_in_minutes, MONTH(timer.watch_time) as month, YEAR(timer.watch_time) as year FROM patients LEFT JOIN timer ON patients.patient_id = timer.patient_id WHERE patients.groupid = '$group_id' AND MONTH(timer.watch_time) = '$month' AND YEAR(timer.watch_time) = '$year' AND timer.cctype = '$type' GROUP BY timer.patient_id HAVING time_in_minutes < 20 ORDER BY time_in_minutes DESC) AS cal ON patients.patient_id = cal.patient_id WHERE patients.groupid = '$group_id' ORDER BY `time_in_minutes`  DESC";
                    $result = ddxrxDBConnect()->query($sql);
                    
                    if ($result->num_rows > 0) {
                        while($row = $result->fetch_assoc()) {
                            
                            if( isset($row["patient_fname"]) && isset($row["patient_lname"]) ){
                             
                                echo '<tr>';
                                    echo '<td>' . $row["patient_fname"] . '</td>';
                                    echo '<td>' . $row["patient_lname"] . '</td>';
                                    echo '<td>' . $row["cell"] . '</td>';
                                    echo '<td>' . $row["patient_dob"] . '</td>';
                                    echo '<td>' . $row["time_in_minutes"] . ' Minutes</td>';
                                echo '</tr>';
                            
                            }
                                
                        }
                    } else {
                        //echo "0 results";
                    }
                    
                    ddxrxDBConnect()->close();
                ?>
                    
                </tbody>
            </table>
            
        </div>
    </div>
                
    <?php provider_bottom_nav(); ?>
    
</body>
</html>