<?php
ob_start();
session_start();
include ('restriction.php');
include ('analytics.php');

require_once(__DIR__.'/payment/stripe_config.php'); // New file added by THS on April 12, 2021

define('ASSET_VERSION', '0.0.9');
?>

<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-148409281-3"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'UA-148409281-3');
    </script>
	
	<title>AI Based Health Care - DDxRx.com</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
    <?php if( basename($_SERVER['REQUEST_URI']) == 'ios-launch.php' ){ include('header-ios-launch.php'); } ?>
    <?php if( basename($_SERVER['REQUEST_URI']) == 'search_dd.php' ){ include('header-search-dd.php'); } ?>

	<link rel="stylesheet" type="text/css" href="assets/css/reset.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/main-menu.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/slicknav.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/jquery.fancybox.min.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.min.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/easy-autocomplete.themes.min.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/login-selector.css?v=<?php echo ASSET_VERSION; ?>">
	<!--<link rel="stylesheet" type="text/css" href="assets/css/style.css?v=<?php echo ASSET_VERSION; ?>">-->
	<link rel="stylesheet" type="text/css" href="assets/css/signup-patient.css?v=<?php echo ASSET_VERSION; ?>">
	<!--<link rel="stylesheet" type="text/css" href="assets/css/sweetalert2.min.css">-->
	<link rel="stylesheet" type="text/css" href="assets/css/mobile.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/select2.min.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/responsive.css?v=<?php echo ASSET_VERSION; ?>">
	<link rel="stylesheet" type="text/css" href="assets/css/faq.css?v=<?php echo ASSET_VERSION; ?>">
    
	<script type="text/javascript" src="assets/js/jquery.min.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/jquery.waypoints.min.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/base64converter.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/jquery.slicknav.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/jquery.fancybox.min.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<!--<script type="text/javascript" src="assets/js/jquery-ui.min.js?v=<?php echo ASSET_VERSION; ?>"></script>-->
	<script type="text/javascript" src="assets/js/jquery.easy-autocomplete.min.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@10?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/admin.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/select2.full.min.js?v=<?php echo ASSET_VERSION; ?>"></script>
	<script type="text/javascript" src="assets/js/faq.js?v=<?php echo ASSET_VERSION; ?>"></script>
    
    <script type="text/javascript">
        
            
        <?php if(defined('STRIPE_MODE')): ?>
        
            const stripe_mode = "<?php echo STRIPE_MODE ?>";
        
            <?php if(STRIPE_MODE !='live'): ?>
                const publishable_key = "<?php echo STRIPE_TEST_PUBLISHABLE_KEY ?>";
                const secret_key = "<?php echo STRIPE_TEST_SECRET_KEY ?>";
            <?php else: ?>
                const publishable_key = "<?php echo STRIPE_LIVE_PUBLISHABLE_KEY ?>";
                const secret_key = "<?php echo STRIPE_LIVE_SECRET_KEY ?>";
            <?php endif ?>
            
        <?php endif ?>
        
        
        $(document).ready(function() {
            $('.CustomSelectbox').select2();
        });
    </script>
    
</head>
<body>

<script src="//js.stripe.com/v3/"></script>
<script type="text/javascript" src="assets/js/payment.js?v=<?php echo ASSET_VERSION; ?>"></script>

    <div class="loading-screen" style="display: none;"></div>
    
    <!-- OTP Popup -->
    <div class="otp-popup" style="display: none">
        <div class="inner">
            
            <div class="otpForm">
                <div class="desc">
                    <h5 style="font-size: 16px;">Verify your cell phone number</h5>
                    <p>To continue registration, please enter your cell phone number.</p>
                    <select class="form-control" id="countryCode">
                        <option value="+93">AF +93</option>
                        <option value="+355">AL +355</option>
                        <option value="+213">DZ +213</option>
                        <option value="+1684">AS +1684</option>
                        <option value="+376">AD +376</option>
                        <option value="+244">AO +244</option>
                        <option value="+1264">AI +1264</option>
                        <option value="+0">AQ +0</option>
                        <option value="+1268">AG +1268</option>
                        <option value="+54">AR +54</option>
                        <option value="+374">AM +374</option>
                        <option value="+297">AW +297</option>
                        <option value="+61">AU +61</option>
                        <option value="+43">AT +43</option>
                        <option value="+994">AZ +994</option>
                        <option value="+1242">BS +1242</option>
                        <option value="+973">BH +973</option>
                        <option value="+880">BD +880</option>
                        <option value="+1246">BB +1246</option>
                        <option value="+375">BY +375</option>
                        <option value="+32">BE +32</option>
                        <option value="+501">BZ +501</option>
                        <option value="+229">BJ +229</option>
                        <option value="+1441">BM +1441</option>
                        <option value="+975">BT +975</option>
                        <option value="+591">BO +591</option>
                        <option value="+387">BA +387</option>
                        <option value="+267">BW +267</option>
                        <option value="+0">BV +0</option>
                        <option value="+55">BR +55</option>
                        <option value="+246">IO +246</option>
                        <option value="+673">BN +673</option>
                        <option value="+359">BG +359</option>
                        <option value="+226">BF +226</option>
                        <option value="+257">BI +257</option>
                        <option value="+855">KH +855</option>
                        <option value="+237">CM +237</option>
                        <option value="+1">CA +1</option>
                        <option value="+238">CV +238</option>
                        <option value="+1345">KY +1345</option>
                        <option value="+236">CF +236</option>
                        <option value="+235">TD +235</option>
                        <option value="+56">CL +56</option>
                        <option value="+86">CN +86</option>
                        <option value="+61">CX +61</option>
                        <option value="+672">CC +672</option>
                        <option value="+57">CO +57</option>
                        <option value="+269">KM +269</option>
                        <option value="+242">CG +242</option>
                        <option value="+242">CD +242</option>
                        <option value="+682">CK +682</option>
                        <option value="+506">CR +506</option>
                        <option value="+225">CI +225</option>
                        <option value="+385">HR +385</option>
                        <option value="+53">CU +53</option>
                        <option value="+357">CY +357</option>
                        <option value="+420">CZ +420</option>
                        <option value="+45">DK +45</option>
                        <option value="+253">DJ +253</option>
                        <option value="+1767">DM +1767</option>
                        <option value="+1809">DO +1809</option>
                        <option value="+670">TP +670</option>
                        <option value="+593">EC +593</option>
                        <option value="+20">EG +20</option>
                        <option value="+503">SV +503</option>
                        <option value="+240">GQ +240</option>
                        <option value="+291">ER +291</option>
                        <option value="+372">EE +372</option>
                        <option value="+251">ET +251</option>
                        <option value="+61">XA +61</option>
                        <option value="+500">FK +500</option>
                        <option value="+298">FO +298</option>
                        <option value="+679">FJ +679</option>
                        <option value="+358">FI +358</option>
                        <option value="+33">FR +33</option>
                        <option value="+594">GF +594</option>
                        <option value="+689">PF +689</option>
                        <option value="+0">TF +0</option>
                        <option value="+241">GA +241</option>
                        <option value="+220">GM +220</option>
                        <option value="+995">GE +995</option>
                        <option value="+49">DE +49</option>
                        <option value="+233">GH +233</option>
                        <option value="+350">GI +350</option>
                        <option value="+30">GR +30</option>
                        <option value="+299">GL +299</option>
                        <option value="+1473">GD +1473</option>
                        <option value="+590">GP +590</option>
                        <option value="+1671">GU +1671</option>
                        <option value="+502">GT +502</option>
                        <option value="+44">XU +44</option>
                        <option value="+224">GN +224</option>
                        <option value="+245">GW +245</option>
                        <option value="+592">GY +592</option>
                        <option value="+509">HT +509</option>
                        <option value="+0">HM +0</option>
                        <option value="+504">HN +504</option>
                        <option value="+852">HK +852</option>
                        <option value="+36">HU +36</option>
                        <option value="+354">IS +354</option>
                        <option value="+91">IN +91</option>
                        <option value="+62">ID +62</option>
                        <option value="+98">IR +98</option>
                        <option value="+964">IQ +964</option>
                        <option value="+353">IE +353</option>
                        <option value="+972">IL +972</option>
                        <option value="+39">IT +39</option>
                        <option value="+1876">JM +1876</option>
                        <option value="+81">JP +81</option>
                        <option value="+44">XJ +44</option>
                        <option value="+962">JO +962</option>
                        <option value="+7">KZ +7</option>
                        <option value="+254">KE +254</option>
                        <option value="+686">KI +686</option>
                        <option value="+850">KP +850</option>
                        <option value="+82">KR +82</option>
                        <option value="+965">KW +965</option>
                        <option value="+996">KG +996</option>
                        <option value="+856">LA +856</option>
                        <option value="+371">LV +371</option>
                        <option value="+961">LB +961</option>
                        <option value="+266">LS +266</option>
                        <option value="+231">LR +231</option>
                        <option value="+218">LY +218</option>
                        <option value="+423">LI +423</option>
                        <option value="+370">LT +370</option>
                        <option value="+352">LU +352</option>
                        <option value="+853">MO +853</option>
                        <option value="+389">MK +389</option>
                        <option value="+261">MG +261</option>
                        <option value="+265">MW +265</option>
                        <option value="+60">MY +60</option>
                        <option value="+960">MV +960</option>
                        <option value="+223">ML +223</option>
                        <option value="+356">MT +356</option>
                        <option value="+44">XM +44</option>
                        <option value="+692">MH +692</option>
                        <option value="+596">MQ +596</option>
                        <option value="+222">MR +222</option>
                        <option value="+230">MU +230</option>
                        <option value="+269">YT +269</option>
                        <option value="+52">MX +52</option>
                        <option value="+691">FM +691</option>
                        <option value="+373">MD +373</option>
                        <option value="+377">MC +377</option>
                        <option value="+976">MN +976</option>
                        <option value="+1664">MS +1664</option>
                        <option value="+212">MA +212</option>
                        <option value="+258">MZ +258</option>
                        <option value="+95">MM +95</option>
                        <option value="+264">NA +264</option>
                        <option value="+674">NR +674</option>
                        <option value="+977">NP +977</option>
                        <option value="+599">AN +599</option>
                        <option value="+31">NL +31</option>
                        <option value="+687">NC +687</option>
                        <option value="+64">NZ +64</option>
                        <option value="+505">NI +505</option>
                        <option value="+227">NE +227</option>
                        <option value="+234">NG +234</option>
                        <option value="+683">NU +683</option>
                        <option value="+672">NF +672</option>
                        <option value="+1670">MP +1670</option>
                        <option value="+47">NO +47</option>
                        <option value="+968">OM +968</option>
                        <option value="+92">PK +92</option>
                        <option value="+680">PW +680</option>
                        <option value="+970">PS +970</option>
                        <option value="+507">PA +507</option>
                        <option value="+675">PG +675</option>
                        <option value="+595">PY +595</option>
                        <option value="+51">PE +51</option>
                        <option value="+63">PH +63</option>
                        <option value="+0">PN +0</option>
                        <option value="+48">PL +48</option>
                        <option value="+351">PT +351</option>
                        <option value="+1787">PR +1787</option>
                        <option value="+974">QA +974</option>
                        <option value="+262">RE +262</option>
                        <option value="+40">RO +40</option>
                        <option value="+70">RU +70</option>
                        <option value="+250">RW +250</option>
                        <option value="+290">SH +290</option>
                        <option value="+1869">KN +1869</option>
                        <option value="+1758">LC +1758</option>
                        <option value="+508">PM +508</option>
                        <option value="+1784">VC +1784</option>
                        <option value="+684">WS +684</option>
                        <option value="+378">SM +378</option>
                        <option value="+239">ST +239</option>
                        <option value="+966">SA +966</option>
                        <option value="+221">SN +221</option>
                        <option value="+381">RS +381</option>
                        <option value="+248">SC +248</option>
                        <option value="+232">SL +232</option>
                        <option value="+65">SG +65</option>
                        <option value="+421">SK +421</option>
                        <option value="+386">SI +386</option>
                        <option value="+44">XG +44</option>
                        <option value="+677">SB +677</option>
                        <option value="+252">SO +252</option>
                        <option value="+27">ZA +27</option>
                        <option value="+0">GS +0</option>
                        <option value="+211">SS +211</option>
                        <option value="+34">ES +34</option>
                        <option value="+94">LK +94</option>
                        <option value="+249">SD +249</option>
                        <option value="+597">SR +597</option>
                        <option value="+47">SJ +47</option>
                        <option value="+268">SZ +268</option>
                        <option value="+46">SE +46</option>
                        <option value="+41">CH +41</option>
                        <option value="+963">SY +963</option>
                        <option value="+886">TW +886</option>
                        <option value="+992">TJ +992</option>
                        <option value="+255">TZ +255</option>
                        <option value="+66">TH +66</option>
                        <option value="+228">TG +228</option>
                        <option value="+690">TK +690</option>
                        <option value="+676">TO +676</option>
                        <option value="+1868">TT +1868</option>
                        <option value="+216">TN +216</option>
                        <option value="+90">TR +90</option>
                        <option value="+7370">TM +7370</option>
                        <option value="+1649">TC +1649</option>
                        <option value="+688">TV +688</option>
                        <option value="+256">UG +256</option>
                        <option value="+380">UA +380</option>
                        <option value="+971">AE +971</option>
                        <option value="+44">GB +44</option>
                        <option value="+1" selected="">US +1</option>
                        <option value="+1">UM +1</option>
                        <option value="+598">UY +598</option>
                        <option value="+998">UZ +998</option>
                        <option value="+678">VU +678</option>
                        <option value="+39">VA +39</option>
                        <option value="+58">VE +58</option>
                        <option value="+84">VN +84</option>
                        <option value="+1284">VG +1284</option>
                        <option value="+1340">VI +1340</option>
                        <option value="+681">WF +681</option>
                        <option value="+212">EH +212</option>
                        <option value="+967">YE +967</option>
                        <option value="+38">YU +38</option>
                        <option value="+260">ZM +260</option>
                        <option value="+263">ZW +263</option>
                    </select>
                    <input type="text" class="textbox otpPhoneNumber" placeholder="Enter Phone Number" value="">
                    <a href="javascript:;" class="button sendOTP enabled">Get the code</a>
                </div>
            </div>
            
        </div>
    </div>
    <!-- OTP Popup -->
    
    <div class="payment-wrapper" data-user-id="">
        <div class="container">
        	<div class="col-md-12">
        		<div class="payment-form">
                    
                    <div class="logo-container">
                        <a href="index.php"><img src="assets/images/logo.png"></a>
                    </div>
                    
                    <!-- Payment Info -->
        			<div class="payment-info">

                        <!-- Section 1 -->
                        <div class="section section-1">
                            
        				    <div class="col-xs-12">
        				        <h6>User Information</h6>
        				    </div>
        				    
                            <!-- Phase 1 -->
                            <div class="phase phase-1">
                    			<div class="col-xs-12">
                    				<label>
                    					<span>First Name</span>
                    					<input type="text" class="first_name textbox validation" placeholder="First Name" maxlength="15">
                    				</label>
    
                    				<label>
                    					<span>Middle Name</span>
                    					<input type="text" class="middle_name textbox" placeholder="Middle Name" maxlength="15">
                    				</label>
            
                                    <label>
                                        <span>Last Name</span>
                                        <input type="text" class="last_name textbox validation" placeholder="Last Name" maxlength="15">
                                    </label>
                                    <a href="javascript:;" class="button disabled button-phase-1">Next</a>
                                </div>
                                    
                    			<div class="clear"></div>
                            </div>
                			<!-- Phase 1 -->
                            
                            <!-- Phase 2 -->
                            <div class="phase phase-2">
                    			<div class="col-xs-12">
                    				<label>
                    						<span>Date of birth</span>
                    						<span class="why why-birthdate">Why we need this?</span>
                    						<div class="overlay"></div>
                    						
                    						<div class="birth-container">
                        						<select class="birth-month CustomSelectbox">
                        						    <option value="">Month</option>
                        						    <?php for ($x = 01; $x <= 12; $x++) { ?>
                        						        <option value="<?php echo $x; ?>"><?php echo $x; ?></option>
                        						    <?php } ?>
                        						</select>
                        						<select class="birth-day CustomSelectbox">
                        						    <option value="">Day</option>
                        						    <?php for ($x = 01; $x <= 31; $x++) { ?>
                        						        <option value="<?php echo $x; ?>"><?php echo $x; ?></option>
                        						    <?php } ?>
                        						</select>
                        						<select class="birth-year CustomSelectbox">
                        						    <option value="">Year</option>
                        						    <?php for ($x = 1900; $x <= date("Y"); $x++) { ?>
                        						        <option value="<?php echo $x; ?>"><?php echo $x; ?></option>
                        						    <?php } ?>
                        						</select>
                        						<input type="hidden" class="birthday" value="">
                        						<div class="clear"></div>
                    						</div>
                    						
                    					</label>
                                    <div class="radio-group">
                                            <span>Gender</span>
                                            <span class="why why-birthdate">Why we need this?</span>
                                            
                                            <label><div class="checkbox active"></div><input type="radio" name="gender" value="m" class="gender" checked> <strong>Male</strong></label>
                                            <label><div class="checkbox"></div><input type="radio" name="gender" value="f" class="gender"> <strong>Female</strong></label>
                                            <label><div class="checkbox"></div><input type="radio" name="gender" value="o" class="gender"> <strong>Other</strong></label>
                                        </div>
                                    <a href="javascript:;" class="button disabled button-phase-2">Next</a>
                                </div>
                    			<div class="clear"></div>
                            </div>
                			<!-- Phase 2 -->
                            
                            <!-- Phase 3 -->
                            <div class="phase phase-3">
                                <div class="col-xs-12">
                                    <label>
                                        <span>Phone Number *</span>
                                        <span class="why why-phone">Why we need this?</span>
                                        <input type="text" class="phone_number textbox" maxlength="21" placeholder="Phone Number" required>
                                    </label>
                                    <label>
                                        <span>Email Address <strong class="check_email_status"></strong></span>
                                        <span class="why why-email">Why we need this?</span>
                                        <input type="text" class="email_address textbox" data-email-validate="false" placeholder="Email Address" required>
                                    </label>
                                    <a href="javascript:;" class="button disabled button-phase-3">Next</a>
                                </div>
                                <div class="clear"></div>
                            </div>
                            <!-- Phase 3 -->
                            
                            <!-- Phase 4 -->
                            <div class="phase phase-4">
                    			<div class="col-xs-12">
                    				<label>
                    					<span>Username <strong class="check_user_status"></strong></span>
                    					<input type="text" class="username textbox validation" data-username-validate="" placeholder="Enter your username" maxlength="10">
                    				</label>
                    				
                    				<div id="message" class="password-requirements">
                                        <h6>Password must contain the following:</h6>
                                        <p id="letter" class="invalid">A <b>lowercase</b> letter</p>
                                        <p id="capital" class="invalid">A <b>capital (uppercase)</b> letter</p>
                                        <p id="number" class="invalid">A <b>number</b></p>
                                        <p id="length" class="invalid">Minimum <b>6 characters</b></p>
                                        <p id="passwordMatch" class="invalid">Password Match</p>
                                    </div>
                    				<label>
                    					<span>Password</span>
                    					<div class="field-notice f-password"></div>
                    					<input type="password" class="password textbox validation" placeholder="Password" id="psw" name="psw" pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,}" title="Must contain at least one number and one uppercase and lowercase letter, and at least 6 or more characters" required>
                    				</label>
                    				<label>
                    					<span>Repeat Password</span>
                    					<input type="password" class="repeat_password textbox validation" id="repeatPassword" placeholder="Repeat the password">
                    				</label>
                                    <div class="nda-container">
                                        <input type="checkbox" class="checkbox nda-agreement"><p>By clicking on the "Next" button below, you acknowledge that you have read, understand, and agree to be bound by the <strong><a href="terms_condition.php" target="_blank">Terms and Condition</a>, <a href="nda.php" target="_blank">Non-Disclosure Agreement,</a> and <a href="medical-disclaimer.php" target="_blank">Medical Disclaimer</a></strong>.</p>
                                    </div>
                                </div>
                                <div class="col-xs-12">
                                    <div class="button-overlay"></div>
                                    <a href="javascript:;" class="button next step-1 disabled">Create Account</a>
                                </div>
                                <div class="clear"></div>
                            </div>
                            <!-- Phase 4 -->
                            
                        </div>
                        <!-- Section 1 -->
            
                        <!-- Section 2 -->
                        <div class="section section-2 hide">
                            <div class="col-xs-12">
                                <h6>Address</h6>
                            </div>
    
                            <div class="col-xs-12">
                                <label>
                                    <span>Address</span>
                                    <input type="text" class="textbox billing_address" placeholder="You Billing Address">
                                </label>
 
                                <label>
                                    <span>City</span>
                                    <input type="text" class="textbox billing_city" placeholder="City of billing">
                                </label>

                                <label>
                                    <span>State</span>
                                    <input type="text" class="textbox billing_state" placeholder="State of billing">
                                </label>

                                <label>
                                    <span>Zip Code</span>
                                    <input type="text" class="textbox billing_zip" placeholder="Zip Code">
                                </label>
                            </div>
                            
                            <div class="clear"></div>
    
                            <div class="col-xs-12">
                                <a href="javascript:;" class="button next step-2 hide">Next</a>
                                <!--<?php if( $_GET['plan'] != '1' ){ ?><a href="search_dd.php" class="button blue skip">Skip Payment</a><?php } ?>-->
                            </div>
                            <div class="clear"></div>

                        </div>
                        <!-- Section 2 -->

                        <!-- Section 3 -->
                        <div class="section section-3 hide">
                        <form action="/create_subscription.php" method="post" id="payment-form">
                            
                            <div class="col-md-12">
                                <h6>Select subscription</h6>
                                
                                <div class="price-selection row">
                                
                                <div class="col-md-3">
                                    <label style="margin-bottom:5px;">
                                        <div class="item enabled <?php if( isset($_GET['plan']) && $_GET['plan'] == '3' ){ echo 'current'; } ?>">
                                            <div class="desc">
                                                <h6>$1 <span>/ Month</span></h6>
                                                <p><strong>Doctor Ai</strong> Your virtual medical assistant</p>
                                                <input type="radio" name="pricing" value="plan_1" <?php if( isset($_GET['plan']) && $_GET['plan'] == '3' ){ echo 'checked'; } ?>>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                                
                                <div class="col-md-3">
                                    <label style="margin-bottom:5px;">
                                        <div class="item enabled <?php if( isset($_GET['plan']) && $_GET['plan'] == '5' ){ echo 'current'; } ?>">
                                            <div class="desc">
                                                <h6>$5 <span>/ Month</span></h6>
                                                <p><strong>Genie and Doctor Ai</strong> your virtual medical assistant</p>
                                                <input type="radio" name="pricing" value="plan_2" <?php if( isset($_GET['plan']) && $_GET['plan'] == '5' ){ echo 'checked'; } ?>>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                                
                                <div class="col-md-3">
                                    <label style="margin-bottom:5px;">
                                        <div class="item enabled state_restriction <?php if( isset($_GET['plan']) && $_GET['plan'] == '20' ){ echo 'current'; } ?>">
                                            <div class="desc">
                                                <h6>$20 <span>/ Month</span></h6>
                                                <p><strong>Unlimited Telemedicine</strong> Monthly Subscription<br> Minimum 12 Months</p>
                                                <input type="radio" name="pricing" value="plan_3" <?php if( isset($_GET['plan']) && $_GET['plan'] == '20' ){ echo 'checked'; } ?>>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                                
                                <div class="col-md-3">
                                    <label style="margin-bottom:5px;">
                                        <div class="item enabled state_restriction <?php if( isset($_GET['plan']) && $_GET['plan'] == '40' ){ echo 'current'; } ?>">
                                            <div class="desc">
                                                <h6>$40 <span>/ Visit</span></h6>
                                                <p><strong>Pay per visit</strong> Telemedicine Single Visit</p>
                                                <input type="radio" name="pricing" value="plan_4" <?php if( isset($_GET['plan']) && $_GET['plan'] == '50' ){ echo 'checked'; } ?>>
                                            </div>
                                        </div>
                                    </label>
                                </div>
                                
                            <div class="clear"></div>
                            </div>
                                
                            </div>
                            <div class="clear"></div>
                            
                            
                            
                            <div class="col-md-12">
                                <label>
                                    <span class="mb-10">Name on the Card</span>
                                    <input id="name" class="textbox mb-20" name="name" placeholder="Full name here" required>
                                </label>
                            </div>
                            
                            <div class="col-md-12 mb-20">
                                <label>
                                    <span class="mb-5">Email Address</span>
                                    <input id="email" class="textbox" name="stripeEmail" type="email" placeholder="example@your-email.com" required>
                                </label>
                            </div>
                            
                                   
                            <div class="col-xs-12">
                                <label>
                                    <span>Apply Coupon <strong class="check_coupon_status"></strong></span>
                                    <input type="text" id="coupon"  name="coupon" class="coupon textbox validation" coupon-validate="" placeholder="Enter a valid coupon">
                                </label>
                            </div>  
                            
                              
                            <div class="col-md-12">
                                
                                <!-- A Stripe Element will be inserted here. -->
                                <div id="card-element"></div>
                                
                                <!-- Used to display form errors -->
                                <div id="card-errors" role="alert"></div>
                                
                                <?php if( $_GET['plan'] == '5' || $_GET['plan'] == '40' ){ ?>
                                    <label>Credit or debit card</label>
                                    <div id="card-element"><!-- A Stripe Element will be inserted here. --></div>
                                    <div style="width: 100%; height: 20px;"></div>
                                    <button class="button">Submit Payment</button>
                                <?php }elseif( $_GET['plan'] == '1' ){ ?>
                                    <div id="card-element" style"display:none"><?php //A Stripe Element will be inserted here. ?></div>
                                    <!--<a href="index.php" class="button blue skip">Start Free Trial</a>-->
                                <?php }elseif($_GET['plan'] == '20'){ ?>
                                    <label>Credit or debit card</label>
                                    <div id="card-element"><!-- A Stripe Element will be inserted here. --></div>
                                    <div style="width: 100%; height: 20px;"></div>
                                   
                                <div class="col-xs-12">
                                    <label>
                                        <span>Apply Coupon <strong class="check_coupon_status"></strong></span>
                                        <input type="text" id="coupon"  name="coupon" class="coupon textbox validation" coupon-validate="" placeholder="Enter a valid coupon">
                                    </label>
                                </div>                                     
                              <!---  <a href="search_dd.php" class="button blue skip">Start 1 Month Free Trial</a>--->
                                <?php  } ?>
                                
                                <button class="button">Submit Payment</button> 
                            </div>
                            
                            <div class="clear"></div>
                        
                            <!-- Used to display form errors. -->
                            <div id="error-message" role="alert"></div>
                          
                        </form>
                        <div class="clear"></div>

                        </div>
                        <!-- Section 3 -->
                        
                        <!-- CTA -->
                        <div class="section login-cta hide">
                            <div class="col-md-12">
                                <h1>Account Created</h1>
                                <p>You can now login and start using DOCTOR AI</p>
                                <a href="logout.php" class="button">Login to account</a>
                            </div>
                            <div class="clear"></div>
                        </div>
                        <!-- CTA -->
                        
        			</div>
                    <!-- Payment Info -->
                    
                    <div class="notice-container"></div>
                    
        		</div>
        	</div>
        </div>
    </div>
    
    <div class="sidebar-chat-bot">
        
        <div class="chat-widget">
            <div class="titlebar">
                <h6>Ask Doctor AI</h6> <img src="assets/images/close.png" class="close">
                <div class="clear"></div>
            </div>
            <div class="inner"></div>
        </div>
        
        <div class="chat-button">
            <img src="assets/images/chat.png">
        </div>
    </div>

</body>
</html>
