<?php

// Start Session
session_start();

// Include Functions File
include('../process/functions.php');

if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}

if(isset($_GET['id'])) {
    
    $nurse_id = $_GET['id'];

    $query=mysqli_query(ddxrxDBConnect(), "SELECT * FROM all_users as au join nurse as n on au.userid = n.user_id WHERE n.user_id=".$nurse_id);
    $row=mysqli_fetch_array($query);
}

// Get Profile Image
if( isset($_GET['id']) ){

    $userid = $_GET['id'];

    $sql = "SELECT * FROM `user_profile` WHERE `user_id` = '$userid' order by `id` DESC";
    $result = mysqli_query(ddxrxDBConnect(), $sql);
    $user_info = mysqli_fetch_assoc($result);

    // Free result set
    mysqli_free_result($result);

    mysqli_close(ddxrxDBConnect());

    if( empty($user_info) ){
        $profile_picture = 'dist/img/avatar.png';
    }else{
        $profile_picture = '../profile-images/'.$user_info['image_url'];
    }

}

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Edit <?php echo $row['nurse_fname']." ".$row['nurse_lname']; ?> - DDxRx Admin Panel | Dashboard</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Other JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/nurse-script.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
    <script src="dist/js/adminlte.min.js"></script>
    <script src="dist/js/custom.js"></script>

    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="dist/css/custom.css">

</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php
    include('includes/header.php');
    include('includes/sidebar.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Edit nurse
                <small>Nurse</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Edit Nurse</li>
            </ol>
        </section>
        
        <!-- Main content -->
        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">

                <div class="col-md-10">
                    <div class="box box-primary">

                        <form method="POST" action="process/edit_nurse.php" name="edit_nurse_form" id="edit_nurse_form">
                            <input type="hidden" name="nurse_id" value="<?php echo $row['user_id']; ?>">
                            <div class="container-fluid">
                                <br>
                                Login Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Username:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" name="username" value="<?php echo $row['username']; ?>" disabled class="form-control">
                                    </div>
                                    <div class="col-md-2">
                                        <label>Password:</label>
                                    </div>
                                    <div class="col-md-4">
                                        <input type="password" name="password" class="form-control">
                                    </div>
                                </div>
                                Personal Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>First Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_fname" value="<?php echo $row['nurse_fname']; ?>" class="form-control first_name" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Last Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_lname" value="<?php echo $row['nurse_lname']; ?>" class="form-control last_name" required>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label for="email">Email:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="email" name="nurse_email" value="<?php echo $row['nurse_email']; ?>" id="email" Placeholder="nurse@email.com" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Date of Birth:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="date" name="nurse_dob" value="<?php echo $row['nurse_dob']; ?>" class="form-control" required>
                                    </div>
                                    
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Qualification:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <select class="form-control" name="nurse_degree" required>
                                            <option <?php if($row['nurse_degree']=="RN") echo "selected"; ?> value="RN">RN</option>
                                            <option <?php if($row['nurse_degree']=="LPN") echo "selected"; ?> value="LPN">LPN</option>
                                            <option <?php if($row['nurse_degree']=="MA") echo "selected"; ?> value="MA">MA</option>
                                            <option <?php if($row['nurse_degree']=="Manager") echo "selected"; ?> value="Manager">Manager</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Mobile Number:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="mobile_phone" value="<?php echo $row['mobile_phone']; ?>" class="form-control" required>
                                    </div>
                                    
                                </div>

                                <!-- Video Training -->
                                <div class="row form-group">

                                    <div class="col-md-2">
                                        <label>Select Video Training:</label>
                                    </div>

                                    <div class="col-md-10">
                                        
                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_1">
                                            <span class="label-text">Clinical Assist Email Pitch</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_2">
                                            <span class="label-text">Clinical Assist for Hospital</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_3">
                                            <span class="label-text">Clinical Assist Introduction</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_4">
                                            <span class="label-text">Clinical Assist Medical Disclaimer</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_5">
                                            <span class="label-text">Clinical Assist Primary Care</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_6">
                                            <span class="label-text">Clinical Assist Fall Alert</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_7">
                                            <span class="label-text">Clinical Assist Urgent Care Clinics</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_8">
                                            <span class="label-text">Clinic Owner RPM Training</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_9">
                                            <span class="label-text">Doctor Ai Introduction</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_10">
                                            <span class="label-text">Doctor Ai RPM Onboarding</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_11">
                                            <span class="label-text">Doctor Ai RPM Phone Call Training</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_12">
                                            <span class="label-text">Doctor Ai RPM Pitch</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_13">
                                            <span class="label-text">Doctor Ai RPM</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_14">
                                            <span class="label-text">RPM Engagement Rules</span>
                                        </label>
                                    </div>

                                </div>
                                <!-- End Video Training -->

                                <div class="row form-group">
                                    <div class="col-md-4 col-md-offset-4">
                                        <button class="btn btn-primary col-md-12">Update Nurse</button>
                                    </div>
                                </div>


                            </div>
                        </form>
                        
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="box box-primary">
                        <div class="container-fluid">

                            <div class="row form-group">
                                <div class="col-md-12">
                                
                                <div class="avatar-upload-container">
                                    <div class="avatar-container">
                                        <div class="upload-icon-container">
                                            <div class="upload-icon">
                                                <i class="fa fa-cloud-upload"></i>
                                                <h6>Select New Image</h6>
                                            </div>
                                        </div>
                                        <img src="<?php echo $profile_picture; ?>" class="avatar">
                                    </div>

                                    <form id="uploadForm" enctype="multipart/form-data">
                                        <input type="file" name="file" accept="image/*" id="fileToUpload" class="uploadfield" style="display: none" required>
                                        <input type="hidden" value="<?php echo $_GET['id']; ?>" id="userid">
                                        <input type="submit" value="Upload Image" class="submitUpload">
                                    </form>

                                </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer">
        <div class="pull-right hidden-xs">
            <b>Version</b> 2.4.0
        </div>
        <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
        reserved.
    </footer>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

</body>
</html>
