<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// include('../process/functions.php');

if(!isset($_SESSION['name']) || $_SESSION['user_type'] != "admin") {
    header("Location: login.php");
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Nurse - DDxRx Admin Panel | Dashboard</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- JQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>

    <!-- Other JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="dist/js/nurse-script.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
    <script src="dist/js/adminlte.min.js"></script>

    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="dist/css/custom.css">

</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php
    include('includes/header.php');
    include('includes/sidebar.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Add new nurse
                <small>Nurse</small>
            </h1>
            
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li class="active">Add Nurse</li>
            </ol>
        </section>
        
        <!-- Main content -->
        <section class="content">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-primary">
                        <form method="POST" action="process/add_nurse.php" name="nurse_create_form" id="nurse_create_form">
                            <div class="container-fluid">
                                <br>
                                Login Details
                                <hr>
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>Username:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="username" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Password:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="password" name="password" class="form-control" required>
                                    </div>
                                </div>
                                Nurse Details
                                <hr>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label>First Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_fname" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Last Name:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="text" name="nurse_lname" class="form-control" required>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    <div class="col-md-2">
                                        <label for="email">Email:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="email" name="nurse_email" value="" id="email" Placeholder="nurse@email.com" class="form-control" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Date of Birth:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <input type="date" name="nurse_dob" class="form-control" required>
                                    </div>
                                </div>
                                
                                <div class="row form-group">
                                    
                                    <div class="col-md-2">
                                        <label>Qualification:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <select class="form-control" name="nurse_degree" required>
                                            <option value="">--select--</option>
                                            <option value="RN">RN</option>
                                            <option value="LPN">LPN</option>
                                            <option value="MA">MA</option>
                                            <option value="Manager">Manager</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label>Mobile Number:</label>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <!--<input type="text" name="country_code" class="form-control" style="width: 10%; float: left; border-right: 0px; outline: none" placeholder="+63">-->
                                        <input type="number" name="mobile_phone" class="form-control" required>
                                    </div>
                                    
                                </div>

                                <!-- Video Training -->
                                <div class="row form-group">

                                    <div class="col-md-2">
                                        <label>Select Video Training:</label>
                                    </div>

                                    <div class="col-md-10">
                                        
                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_1">
                                            <span class="label-text">Clinical Assist Email Pitch</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_2">
                                            <span class="label-text">Clinical Assist for Hospital</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_3">
                                            <span class="label-text">Clinical Assist Introduction</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_4">
                                            <span class="label-text">Clinical Assist Medical Disclaimer</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_5">
                                            <span class="label-text">Clinical Assist Primary Care</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_6">
                                            <span class="label-text">Clinical Assist Fall Alert</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_7">
                                            <span class="label-text">Clinical Assist Urgent Care Clinics</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_8">
                                            <span class="label-text">Clinic Owner RPM Training</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_9">
                                            <span class="label-text">Doctor Ai Introduction</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_10">
                                            <span class="label-text">Doctor Ai RPM Onboarding</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_11">
                                            <span class="label-text">Doctor Ai RPM Phone Call Training</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_12">
                                            <span class="label-text">Doctor Ai RPM Pitch</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_13">
                                            <span class="label-text">Doctor Ai RPM</span>
                                        </label>

                                        <label style="position: relative">
                                            <input type="checkbox" name="video_set" value="video_set_14">
                                            <span class="label-text">RPM Engagement Rules</span>
                                        </label>
                                    </div>

                                </div>
                                <!-- End Video Training -->
                                
                                <div class="row form-group">
                                    <div class="col-md-4 col-md-offset-4">
                                        <button class="btn btn-primary col-md-12">Add Nurse</button>
                                    </div>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <footer class="main-footer">
        <div class="pull-right hidden-xs">
            <b>Version</b> 2.4.0
        </div>
        <strong>Copyright &copy; 2014-2016 <a href="https://adminlte.io">Almsaeed Studio</a>.</strong> All rights
        reserved.
    </footer>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 3 -->
<script src="bower_components/jquery/dist/jquery.min.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<!--<script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/additional-methods.min.js"></script>-->


<!-- jQuery UI 1.11.4 -->
<script src="bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
    $.widget.bridge('uibutton', $.ui.button);
</script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- Morris.js charts -->
<script src="bower_components/raphael/raphael.min.js"></script>
<script src="bower_components/morris.js/morris.min.js"></script>
<!-- Sparkline -->
<script src="bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
<!-- jvectormap -->
<script src="plugins/jvectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="plugins/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
<!-- jQuery Knob Chart -->
<script src="bower_components/jquery-knob/dist/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="bower_components/moment/min/moment.min.js"></script>
<script src="bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
<!-- datepicker -->
<script src="bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
<!-- Bootstrap WYSIHTML5 -->
<script src="plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
<!-- Slimscroll -->
<script src="bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="bower_components/fastclick/lib/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
<script src="dist/js/pages/dashboard.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>


</body>
</html>
