<?php

    session_start();

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }

    // Include function file
    include('process/functions.php');

?>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Nurse ADT Dashboard</title>

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/adt-dashboard.css">

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="assets/js/adt-dashboard.js"></script>
    </head>
    <body>

        <!-- ADT MRN -->
        <div class="adt-mrn-container">
            <div class="inner">
                <div class="container">
                    <div class="col-md-12">

                        <div class="mrn-form">
                            <form>
                                <label>
                                    <input type="number" class="textbox mrn-input" placeholder="Type MRN Number...">
                                    <input type="submit" class="frm-btn check-adt" value="Confirm">
                                    <img src="assets/images/loading.svg" class="loading">
                                </label>
                                <p><a href="adt-dashboard.php">Cancel and go back to ADT Dashboard</a></p>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- ADT MRN -->

        <!-- ADT Container -->
        <div class="adt-container hide" id="adt-container">
            <div class="container">
                <div class="col-md-12" id="adt-column">
                    
                    <div class="adt-header">
                        <div class="row">

                            <div class="col-md-6"><h6>New Patient</h6></div>
                            <div class="col-md-6"><a href="adt-dashboard.php" class="btn-add">Back to dashboard</a></div>

                        </div>
                    </div>

                    <div class="adt-patient-form">
                        <div class="row">
                            
                            <input type="hidden" class="patientid" value="0">

                            <div class="spacer"></div>

                            <div class="col-md-3">
                                <label><span>DDXRX MRN</span>
                                    <input type="text" class="textbox ddxrx-mrn" placeholder="MRN No. from internal system">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Hospital MRN</span>
                                    <input type="text" class="textbox hospital-mrn" placeholder="MRN No. from hospital">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Room Number</span>
                                    <input type="text" class="textbox room_no" placeholder="Enter patient's room no.">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Phone Number</span>
                                    <input type="text" class="textbox mobile_no" placeholder="Enter patient's phone no.">
                                </label>
                            </div>

                            <div class="clear"></div>
                            <div class="spacer"></div>

                            <div class="col-md-3">
                                <label><span>First Name</span>
                                    <input type="text" class="textbox fname" placeholder="Enter patient's first name">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Middle Name(Optional)</span>
                                    <input type="text" class="textbox mname" placeholder="Enter patient's middle name">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Last Name</span>
                                    <input type="text" class="textbox lname" placeholder="Enter patient's last name">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Date of Birth</span>
                                    <input type="date" class="textbox dob" placeholder="Enter patient's birth date">
                                </label>
                            </div>

                            <div class="clear"></div>
                            <div class="spacer"></div>

                            <div class="col-md-3">
                                <label><span>Address</span>
                                    <input type="text" class="textbox address" placeholder="Enter patient's full address">
                                </label>
                            </div>

                            <div class="col-md-2">
                                <label><span>City</span>
                                    <input type="text" class="textbox city" placeholder="Enter residing city">
                                </label>
                            </div>

                            <div class="col-md-2">
                                <label><span>State</span>
                                    <input type="text" class="textbox state" placeholder="Enter residing state">
                                </label>
                            </div>

                            <div class="col-md-2">
                                <label><span>Zip Code</span>
                                    <input type="text" class="textbox zip" placeholder="Zip related to city">
                                </label>
                            </div>

                            <div class="col-md-3">
                                <label><span>Email Address</span>
                                    <input type="text" class="textbox email" placeholder="Enter patient's email">
                                </label>
                            </div>

                            <div class="clear"></div>
                            <div class="spacer"></div>

                            <div class="col-md-12">
                                <label><span>Patient's Medical History</span></label>
                                <div class="history-placeholder"></div>
                            </div>

                            <div class="col-md-3">
                                <form class="diagnosis-search-form">
                                    <input type="text" class="textbox" placeholder="Type to search diagnosis">
                                    <ul class="search-result-list"></ul>
                                </form>
                            </div>

                            <div class="col-md-9">
                                <a href="javascript:;" class="frm-btn add">Add Patient</a>
                                <a href="adt-dashboard.php" class="frm-btn cancel"><ion-icon name="arrow-back"></ion-icon> Cancel</a>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- ADT Container -->

        <?php
            if( $_SESSION['user_type'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                physician_bottom_nav();
            }
        ?>

    </body>
</html>