<?php

    session_start();

    if(!isset($_SESSION['userid']) || !isset($_SESSION['userType']) || $_SESSION['userType'] != 'nurse') {
        header("Location: provider_login.php");
        die();
    }

    // Include function file
    include('process/functions.php');

?>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Nurse ADT Dashboard</title>

        <link rel="stylesheet" type="text/css" href="assets/css/reset.css">
        <link rel="stylesheet" type="text/css" href="assets/css/grid.css">
        <link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
        <link rel="stylesheet" type="text/css" href="assets/css/adt-dashboard.css">

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
        <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="assets/js/adt-dashboard.js"></script>
    </head>
    <body>

        <!-- ADT Container -->
        <div class="adt-container">
            <div class="container">
                <div class="col-md-12">
                    
                    <div class="adt-header">
                        <div class="row">

                            <div class="col-md-6"><h6>ADT Dashboard</h6></div>
                            <div class="col-md-6"><a href="adt-add-patient.php" class="btn-add">Add Patient</a></div>

                        </div>
                    </div>

                    <div class="table-container">
                        <div class="table-heading">
                            <div class="cellItem mrn">MRN No.</div>
                            <div class="cellItem room_no">Room No.</div>
                            <div class="cellItem fname">First Name</div>
                            <div class="cellItem mname">Middle Name</div>
                            <div class="cellItem lname">Last Name</div>
                            <div class="cellItem dob">DOB</div>
                            <div class="cellItem age">Age</div>
                            <div class="cellItem action">Action</div>
                            <div class="clear"></div>
                        </div>

                        <!-- Entries -->
                        <div class="table-body">

                            <?php
                            if( isset($_GET['patient_id']) ){
                                $patient_id = $_GET['patient_id'];
                                $sql = "SELECT * FROM `adt` WHERE `patient_id` = '$patient_id' LIMIT 1";
                            }else{
                                $sql = "SELECT * FROM `adt` order by `id` DESC";
                            }
                            $counter = 0;
                            $result = ddxrxDBConnect()->query($sql);

                            if ($result->num_rows > 0) {
                                // output data of each row
                                while($row = $result->fetch_assoc()) {
                                    $counter++;
                            ?>
                                
                                <div class="entryItem<?php if( isset($_GET['patient_id']) ){ echo ' opened'; } ?>" id="entryItem-<?php echo $counter; ?>" data-item="<?php echo $counter; ?>">
                                    <div class="cellItem mrn"><?php echo $row['mrn']; ?></div>
                                    <div class="cellItem room_no"><?php echo $row['room_no']; ?></div>
                                    <div class="cellItem fname"><?php echo $row['first_name']; ?></div>
                                    <div class="cellItem mname"><?php echo $row['middle_name']; ?></div>
                                    <div class="cellItem lname"><?php echo $row['last_name']; ?></div>
                                    <div class="cellItem dob"><?php echo $row['dob']; ?></div>
                                    <div class="cellItem age"><?php echo date_diff(date_create($row['dob']), date_create())->y; ?> Years Old</div>
                                    <div class="cellItem action"><a href="javascript:;" class="view-details">View Details</a></div>
                                    <div class="clear"></div>
                                </div>

                                <!-- ADT Edit Form -->
                                <div class="item-details<?php if( isset($_GET['patient_id']) ){ echo ' show'; } ?>" id="item-detail-<?php echo $counter; ?>" data-adt-id="<?php echo $row['id']; ?>" data-patient-id="<?php if( isset($_GET['patient_id']) ){ echo $_GET['patient_id']; }else{ echo $row['patient_id']; } ?>">
                                    
                                    <div class="adt-patient-form">
                                        <div class="row">

                                            <div class="col-md-2">
                                                <label><span>Room No.</span>
                                                    <input type="text" class="textbox room_no" placeholder="Patient's room number" value="<?php echo $row['room_no']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Hospital MRN No.</span>
                                                    <input type="text" class="textbox hospital-mrn" placeholder="Hospital MRN No." value="<?php echo $row['mrn_hospital']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>First Name</span>
                                                    <input type="text" class="textbox fname" placeholder="Enter patient's first name" value="<?php echo $row['first_name']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Middle Name</span>
                                                    <input type="text" class="textbox mname" placeholder="Enter patient's middle name" value="<?php echo $row['middle_name']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Last Name</span>
                                                    <input type="text" class="textbox lname" placeholder="Enter patient's last name" value="<?php echo $row['last_name']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Date of Birth</span>
                                                    <input type="date" class="textbox dob" value="<?php echo $row['dob']; ?>">
                                                </label>
                                            </div>

                                            <div class="clear"></div>
                                            <div class="spacer"></div>

                                            <div class="col-md-2">
                                                <label><span>Present Address</span>
                                                    <input type="text" class="textbox address" placeholder="Patient's full address" value="<?php echo $row['address']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>City</span>
                                                    <input type="text" class="textbox city" placeholder="Enter residing city" value="<?php echo $row['city']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>State</span>
                                                    <input type="text" class="textbox state" placeholder="Enter residing state" value="<?php echo $row['state']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Zip Code</span>
                                                    <input type="text" class="textbox zip" placeholder="Zip related to city" value="<?php echo $row['zip']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Contact No.</span>
                                                    <input type="text" class="textbox mobile_no" placeholder="Enter active number" value="<?php echo $row['phone']; ?>">
                                                </label>
                                            </div>

                                            <div class="col-md-2">
                                                <label><span>Email Address</span>
                                                    <input type="text" class="textbox email" placeholder="username@provider.com" value="<?php echo $row['email']; ?>">
                                                </label>
                                            </div>

                                            <div class="clear"></div>
                                            <div class="spacer"></div>

                                            <div class="col-md-12">
                                                <label><span>Patient's Medical History</span></label>
                                                <div class="history-placeholder">
                                                    <?php
                                                    $diagnosis = json_decode($row['diagnosis']);
                                                    for( $i = 0; $i < count($diagnosis); $i++ ){
                                                        echo '<a href="javascript:;"><span>'.$diagnosis[$i].'</span> <ion-icon name="close-sharp"></ion-icon></a>';
                                                    }
                                                    ?>
                                                </div>
                                            </div>

                                            <div class="col-md-3">
                                                <form class="diagnosis-search-form">
                                                    <input type="text" class="textbox" placeholder="Type to search diagnosis">
                                                    <ul class="search-result-list">
                                                        <li><a href="javascript:;">Test 1</a></li>
                                                        <li><a href="javascript:;">Test 2</a></li>
                                                        <li><a href="javascript:;">Test 3</a></li>
                                                        <li><a href="javascript:;">Test 4</a></li>
                                                        <li><a href="javascript:;">Test 5</a></li>
                                                        <li><a href="javascript:;">Test 6</a></li>
                                                    </ul>
                                                </form>
                                            </div>

                                            <div class="col-md-9">
                                                <a href="javascript:;" class="frm-btn delete"><ion-icon name="trash"></ion-icon></a>
                                                <a href="javascript:;" class="frm-btn update">Update</a>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                                <!-- ADT Edit Form -->
                            
                            <?php
                                } // end while
                            } else {
                                
                                echo '
                                    <div class="adt-empty-result">
                                        <h1>No ADT Records Available</h1>
                                        <p>Opps... There are no adt records found at the moment please come back later.</p>
                                        <img src="assets/images/error-login.jpg">
                                    </div>
                                ';

                            }

                            ddxrxDBConnect()->close();

                            ?>

                            

                        </div>
                        <!-- Entries -->

                    </div>

                </div>
            </div>
        </div>
        <!-- ADT Container -->
        
        <?php
            if( $_SESSION['user_type'] == 'nurse' ){
                provider_bottom_nav();
            }elseif( $_SESSION['user_type'] == 'physician' || $_SESSION['user_type'] == 'doctor' ){
                physician_bottom_nav();
            }
        ?>

    </body>
</html>