<?php include('process/functions.php'); ?>

<!DOCTYPE html>
<html>
<head>
	<title>Doctor Ai</title>
	
	<meta name="viewport" content="width=device-width, initial-scale=1">
	
	<link rel="stylesheet" type="text/css" href="assets/css/reset.css">
	<link rel="stylesheet" type="text/css" href="assets/css/grid.css">
	<link rel="stylesheet" type="text/css" href="assets/css/select2.min.css">
	<link rel="stylesheet" type="text/css" href="assets/css/anti-coagiation.css">
	<link rel="stylesheet" type="text/css" href="assets/css/top-bar.css">
	
	<script type="text/javascript" src="assets/js/jquery.min.js"></script>
	<script type="text/javascript" src="assets/js/anti-coagiation.js"></script>
	<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>
	
	
</head>
<body>
    
    <div class="container">
        <div class="col-md-12">
            
            <div class="anti-coagiation">
                <h1>Doctor Ai Bleeding Risk Score: While using high dose anticoagulants for COVID-19</h1>
                
                <div class="item">
                    <p class="label">MALE SEX</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="1" class="male_sex off">
                </div>
                
                <div class="item">
                    <p class="label">AGE (≥80; 40 TO 80; 18 to 40; )</p>
                    <select class="selectbox old_age">
                        <option value="">Select Age</option>
                        <option value="0.75">More than 80</option>
                        <option value="0.5">40 to 80</option>
                        <option value="0">Less than 40 </option>
                    </select>
                </div>
                
                
                <div class="item">
                    <p class="label">RACE (WHITE; AFRICAN AMERICAN; ASIAN; HISPANIC; )</p>
                    <select class="selectbox old_age">
                        <option value="">Select Race</option>
                        <option value="0">WHITE</option>
                        <option value="0.5">AFRICAN AMERICAN</option>
                        <option value="1">ASIAN</option>
                        <option value="0.5">HISPANIC</option>
                    </select>
                </div>
                
                
                <!--<div class="item">-->
                <!--    <p class="label">NON-WHITE RACE (ASIAN, HISPANIC, OR AFRICAN AMERICAN)</p>-->
                <!--    <img src="assets/images/boticon/switch-no.png" data-value="1" class="none_white off">-->
                <!--</div>-->
                
                <div class="item">
                    <p class="label">CURRENTLY TREATED FOR PEPTIC ULCER DISEASE</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="1" class="ulcer_diesease off">
                </div>
                
                <div class="item">
                    <p class="label">BLEEDING EPISODE WITHIN THE PAST 3 MONTHS</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="1" class="bleeding off">
                </div>
                
                <div class="item">
                    <p class="label">PLATELET COUNT &lt;50,000</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="1" class="platele_count off">
                </div>
                
                <div class="item">
                    <p class="label">EGFR <30; 30 TO 60; >60; </p>
                    <select class="selectbox egfr">
                        <option value="">Select EGFR</option>
                        <option value="0.5">Less than 30</option>
                        <option value="0.4">30 to 60</option>
                        <option value="0.25">More than 60</option>
                    </select>
                </div>
                
                <div class="item">
                    <p class="label">INR >1.5</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.5" class="inr off">
                </div>
                
                <div class="item">
                    <p class="label">ACTIVE CANCER</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.5" class="active_cancer off">
                </div>
                
                <div class="item">
                    <p class="label">HISTORY OF RHEUMATIC DISEASE</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.5" class="rheumatic_disease off">
                </div>
                
                <div class="item">
                    <p class="label">PRESENCE OF CENTRAL VENOUS CATHETER</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.5" class="venous_catheter off">
                </div>
                
                <div class="item">
                    <p class="label">PRIOR HISTORY OF STROKE</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.25" class="stroke_history off">
                </div>
                
                <div class="item">
                    <p class="label">PRIOR HISTORY OF GASTROINTESTINAL BLEEDING</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.25" class="gastrointestinal_bleeding off">
                </div>
                
                <div class="item">
                    <p class="label">RECENT MYOCARDIAL INFARCTION</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.25" class="myocardial_infarction off">
                </div>
                
                <div class="item">
                    <p class="label">DIABETES MELLITUS TYPE 2</p>
                    <img src="assets/images/boticon/switch-no.png" data-value="0.25" class="diabetes_mellitus off">
                </div>
                
                
                
                
                <a href="javascript:;" class="submit">Submit</a>
                
            </div>
            
        </div>
    </div>
    
</body>
</html>