<?php

// Output JSON header
header('Content-Type: application/json');

// Include function file
include('../process/functions.php');

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// If input is not empty
if(!empty($input)) {

    // If all required parameters are present
    if( isset($input['dictation_id']) && isset($input['patient_id']) && isset($input['unique_id']) && isset($input['message']) ){

        if( is_numeric($input['dictation_id']) && is_numeric($input['patient_id']) && is_numeric($input['unique_id']) && is_string($input['message']) ){

            $dictation_id = mysqli_real_escape_string(ddxrxDBConnect(), $input['dictation_id']);
            $patient_id = mysqli_real_escape_string(ddxrxDBConnect(), $input['patient_id']);
            $unique_id = mysqli_real_escape_string(ddxrxDBConnect(), $input['unique_id']);

            // If note_type is present
            if( isset($input['note_type']) ){
                $note_type = mysqli_real_escape_string(ddxrxDBConnect(), $input['note_type']);
            }else{
                $note_type = '0';
            }

            $message = mysqli_real_escape_string(ddxrxDBConnect(), $input['message']);

            $sql = "INSERT INTO `notes_dictation` (`dictation_id`, `patient_id`, `unique_id`, `note_type`, `message`) VALUES ('$dictation_id', '$patient_id', '$unique_id', '$note_type', '$message')";

            if (mysqli_query(ddxrxDBConnect(), $sql)) {

                // Change status code to 200
                http_response_code(200);

                $output = array(
                    'status_code' => '200',
                    'title' => 'OK',
                    'message' => 'The request was successful.'
                );

            } else {

                // Change status code to 500
                http_response_code(500);

                $output = array(
                    'status_code' => '500',
                    'title' => 'Internal Server Error',
                    'message' => 'Opps! Something went wrong in our backend. Please try again later.'
                );

            }

            // Close the database connection
            mysqli_close(ddxrxDBConnect());

        }else{

            // Change status code to 422
            http_response_code(422);

            $output = array(
                'status_code' => '422',
                'title' => 'Invalid Data Type',
                'message' => 'One or more parameters have incorrect data type.'
            );

        }
    
    }else{
            
        // Change status code to 422
        http_response_code(422);
    
        $output = array(
            'status_code' => '422',
            'title' => 'Missing Parameters',
            'message' => 'The request sent by client was incomplete or incorrect. One or more parameters are missing or have incorrect data type.'
        );
    }

}else{

    // Change status code to 400
    http_response_code(400);

    $output = array(
        'status_code' => '400',
        'title' => 'Bad Request',
        'message' => 'The request sent by client was empty. Please send a non-empty request in JSON format.'
    );

}

// Output Response
echo json_encode($output);

?>
