<?php

// Change header output to JSON
header("Content-Type: application/json");


// Check if there are post data
if(isset($_POST)) {
    
    if( !isset($_POST['group_id']) || !isset($_POST['user_id']) ){
        
        $output = array(
            'result' => false,
            'title' => 'Missing Parameters',
            'desc' => 'Please enter the valid parameter.'
        );
        
    }else{
        
        // Main upload Folder
        $target_dir = "../log_uploads/";
        
        $group_folder = $_POST['group_id'];
        $user_folder = $_POST['user_id'];
        
        // Check if log_uploads folder exist
        if( is_dir( $target_dir ) == false ){
            mkdir( $target_dir );
        }
        
        // Check if group folder exist
        if( is_dir( $target_dir . $group_folder ) == false ){
            
            mkdir( $target_dir . $group_folder );
            
            //Check if user_id folder exist
            if( is_dir( $target_dir . $group_folder . '/' . $user_folder ) == false ){
                mkdir( $target_dir . $group_folder . '/' . $user_folder );
            }
            
        }
        
        
        // Get file Type
        $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
        $FileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
        
        // Set file name for the new uploaded file
        $fileName = date('m-d-y-H-i-s') .'.'. $FileType;
        
        // Set path for the new file
        $newFile = $target_dir . $group_folder . '/' . $user_folder .'/'. $fileName;
        
        // Set URL for the file name
        $filePath = 'https://'.$_SERVER['HTTP_HOST'].'/log_uploads/'. $group_folder . '/' . $user_folder .'/'. $fileName;
        
        // Check if file is an actual .txt/.log or fake file
        if($FileType == "txt" || $FileType == "log" ) {
            
            // Check if file is too large
            if ($_FILES["fileToUpload"]["size"] > 500000) {
                $output = array(
                    'result' => false,
                    'title' => 'File Too Large',
                    'desc' => 'Invalid file type, only .txt and .log files allowed'
                );
            }else{
                
                if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $newFile)) {
                    
                    $output = array(
                        'result' => true,
                        'title' => 'Upload Successful',
                        'desc' => 'The file have been successfully uploaded',
                        'file_name' => $fileName,
                        'file_path' => $filePath
                    );
                    
                } else {
                    
                    $output = array(
                        'result' => false,
                        'title' => 'Upload Interupted',
                        'desc' => 'An error occured while the file was uploading, please try again.'
                    );
                    
                }
                
            }
            
        } else {
            
            $output = array(
                'result' => false,
                'title' => 'Invalid File Type',
                'desc' => 'Invalid file type, only .txt and .log files allowed'
            );
            
        }
    
    }
    
}else{
    
    $output = array(
        'result' => false,
        'title' => 'No File',
        'desc' => 'No file selected, please upload a proper file.'
    );
    
}

echo json_encode($output);

?>