<?php

// Output JSON header
header('Content-Type: application/json');

// Include function file
include('../process/functions.php');

$inputJSON = file_get_contents('php://input');

$input = json_decode($inputJSON, true);

// If input is not empty
if(!empty($input)) {

    if( !empty($input['first_name']) && !empty($input['last_name']) && !empty($input['unique_id']) ){
        
        $first_name = $input['first_name'];
        $last_name = $input['last_name'];
        $unique_id = $input['unique_id'];

        $sql = "SELECT * FROM all_users INNER JOIN `physician` ON `all_users`.`userid` = `physician`.`user_id` WHERE `all_users`.`unique_id` = '$unique_id' AND `physician`.`physician_fname` = '$first_name' AND `physician`.`physician_lname` = '$last_name' LIMIT 1";

        $result = ddxrxDBConnect()->query($sql);

        // Associative array
        $row = $result -> fetch_assoc();
        
        if (!empty($row)) {
            
            $output = array(
                'result' => true,
                'desc' => 'The Physician details match our database records.'
            );

        } else {
            
            $output = array(
                'result' => false,
                'desc' => 'Physician details not found.'
            );

        }

        // Free result set
        $result -> free_result();

        // Close Connection
        ddxrxDBConnect()->close();

    }else{

        // Change status code to 422
        http_response_code(422);

        $output = array(
            'status_code' => '422',
            'title' => 'Missing Parameters',
            'message' => 'The request sent by client was incomplete. One or more parameters are missing.'
        );

    }

}else{

    // Change status code to 400
    http_response_code(400);

    $output = array(
        'status_code' => '400',
        'title' => 'Bad Request',
        'message' => 'The request sent by client was empty. Please send a non-empty request in JSON format.'
    );

}

echo json_encode($output);