$(document).ready(function(){
    
    // Set 
    sessionStorage.setItem("botAnswered", "");
    
    //localStorage.setItem("symptoms", "");
    localStorage.setItem("entity", "");
    
    // Declare variable
    var inputSymptoms = [];
    var multipleAnswers = [];
    var multipleAnswers_raw = [];
    
    // Read answers from multi_answer table
    function read_multAnswer( patientID, userID ){
        
        user_id = userID;
        patient_id = patientID;
        
        $.ajax({
            type: "POST",
            url: 'process/readMultAnswer.php',
            
            data:{
                patient_id: patient_id,
                user_id: user_id
            },
            
            success: function(data){
                $('.answers-conttainer h3').html(data);
                var recognition = new webkitSpeechRecognition();
                recognition.stop();
            }
        
        });
        
    }
    
    // Function to remove duplicate from array
    function remove_arrayDuplicate(arr){
        var tmp = [];
        for(var i = 0; i < arr.length; i++){
            if(tmp.indexOf(arr[i]) == -1){
            tmp.push(arr[i]);
            }
        }
        return tmp;
    }
    
    // function text to speech
    function text_to_speech(text){
        
        var sendData = {
            "text" : text,
        };
            
        $.ajax({
            type: "POST",
            //url: 'https://ddfe8a349a1f.ngrok.io',
                    
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                                
            beforeSend: function() {},
            success: function(data){},               
            failure: function(errMsg) {}
        
        });
        
    }
    
    function sendQuestions(){
        var questions = [];
        var questionFinal;
        var questions_list = $('.option_symptoms .inner ul').html();
            
        if( questions_list == '' || questions_list == ' ' ){
                
            // Question is empty
                
        }else{
                
            if (questions === undefined || questions.length == 0) {
                
                $(".option_symptoms .inner ul li .overlay").each(function(){
                        
                    //$(this).text();
                    questions.push([ $(this).text(), $(this).attr('id'), $('body').data('user_id') ]);
                    
                });
                
                //questions.push([ 'None of the above', '0', $('body').data('user_id') ]);
                
                $.ajax({
                    type: "POST",
                    url: 'process/send_multi_answer.php',
                    data: JSON.stringify(questions),
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                                        
                    beforeSend: function() {},
                    success: function(data){},               
                    failure: function(errMsg) {}
                
                });
                
                
            }
                
        }
    }
    
    // Function to forward symptoms to search_dd.php
    function forward_search(){
        
        Swal.fire({
            icon: 'success',
            title: 'Fetching Results',
            text: 'Please wait while we transfer you to the results page.',
        });
        
        $('.bot-reaction').removeClass('idle');
        $('.bot-reaction').addClass('thinking');
        $('.response-container h1').addClass('thinking');
        $('.response-container h1').html('Please wait...');
                        
        $('.form-container').hide();
        $('.common-symptoms').hide();
        //$('.option_symptoms').hide();
        $('.error-report').hide();
        $('.front-social-media').hide();
        
        var text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        if( inputSymptoms.length == '1' ){
            inputSymptoms.push("Nothing else");
        }
        inputSymptoms = remove_arrayDuplicate(inputSymptoms);
        
        var i, len, text;
        for (i = 0, len = inputSymptoms.length, text = ""; i < len; i++) {
            $('#formddX').append('<input type="hidden" name="symptoms['+i+']" value="'+inputSymptoms[i]+'">');
            //console.log( inputSymptoms[i] );
        }
        
        //window.location.replace('search_dd.php'+text);
        //alert('search_dd.php'+text);
        $('#formddX').append('<input type="submit" id="submitbotsearch">');
        $('#submitbotsearch').click();

    }
    
    // Function to ask mmore symptoms
    function prompt_more_symptoms(){
        
        //console.log( 'the length is: ' + inputSymptoms );
        
        //if( inputSymptoms.length <= 3 ){
            if( inputSymptoms.length != 1 && inputSymptoms.length != ' ' ){
                
                // Convert text to speech
                text_to_speech('Do you want to add more symptoms?');
                
                Swal.fire({
                    title: 'Success',
                    text: "Do you want to add more symptoms",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#e74c3c',
                    cancelButtonColor: '#2ecc71',
                    confirmButtonText: 'No',
                    cancelButtonText: 'Yes',

                }).then((result) => {
                    if (result.value) {
                        // Convert text to speech
                        text_to_speech('Please wait while we transfer you to the results page.');
                        forward_search();
                    }
                });
                //console.log( 'Console: ' + inputSymptoms.length );
            }
        //}
        
    }
    
    // Auto Redirect/Submit
    function auto_submit(){
        
        // Regular Submit
        if( inputSymptoms.length >= 999 ){
            
            Swal.fire({
                title: 'Success',
                text: "Let's narrow down diagnostic options.",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
            //console.log( inputSymptoms );
            
        }
        
        
        // Follow up auto submit
        var arrstring = inputSymptoms.toString();
        var ArrSearchResult = arrstring.search('follow-up') !== -1;
        if( ArrSearchResult == true ){
            
            Swal.fire({
                title: 'Success',
                text: "We will forward you with the results",
                icon: 'success',
                showCancelButton: false,
                confirmButtonText: 'Show Results',
                allowOutsideClick: false
            }).then((result) => {
                if (result.value) {
                    
                    // Hide Elements
                    $('#google_translate_element').remove();
                    $('.bot-avatar').remove();
                    $('.container').remove();
                    // Submit to reports page
                    forward_search();
                    
                }
            });
            
        }
        
    }
    
    // Function to send symptoms
    function sendSymptoms(){
        
        var user_id = '1';
        var userInput = $('.search_phrase').val();
        var entity = localStorage.getItem("entity");
        
        var sendData = {
            "user_id" : user_id,
            "question" : userInput,
            "entity" : entity
        };
        
        $.ajax({
            type: "POST",
            url: 'https://ddxrx.ai',

            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            
            beforeSend: function() {
                $('.response-container h1').text('Thinking . . .');
                $('.response-container h1').addClass('thinking');
                $('.bot-reaction').removeClass('idle');
                $('.bot-reaction').addClass('thinking'); 
                $('.form-container .textbox').addClass('thinking');
                $('.common-symptoms h6').addClass('thinking');
            },

            success: function(data){
                
                sendText(data.text);
                
                // Type 5
                if( data.response == 'success' && data.type == 'type5' ){
                    
                    // Register a session
                    // This is to indicate if the questions have been answered or not
                    sessionStorage.setItem("botAnswered", "no");
                    sessionStorage.setItem("lastAnswered","q_1");
                    
                    // Variable for counter
                    var counter = 0;
                    
                    if( data.symptoms !== undefined ){
                                
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                                
                    }else{
                                
                        // Add data to array
                        if( data.symptoms !== undefined ){
                            inputSymptoms.push( data.symptoms );
                        }
                                
                    }
                    
                    // Auto Search
                    auto_submit();
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                        
                    // Set The Entity Value In storage
                    localStorage.setItem("entity", data.symptoms);
                        
                    if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                        $('.option_symptoms ol').html(''); // Reset the symptom option container  
                        $('.option_symptoms ul').html(''); // Reset the symptom option container
                        $('.option_symptoms').fadeIn(); // Show the symptoms option container
                        
                        let result = data.symptoms_data;
            			for (let user_options of result) {
                			// Iterate Counter
                			counter++;
                	        $('.option_symptoms ul').append('<li class="enabled" id="counter_'+counter+'" data-counter="'+counter+'"><div class="overlay q_'+counter+'" id="q_'+counter+'">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
            	        }
            	        
            	        // Hide Search Form
            		    $('.form-container').hide();
                    }
                        
                    // Only show none of the above where there are options
                    if("symptoms_data" in data){
                        if( data.symptoms_data.length > 0 ){
                            $('.option_symptoms ul').append('<li class="none-of-above enabled"><div class="overlay">None of the above</div>None of the above</li>');
                        }
                    }
                    
                    $('.option_symptoms a.send_mult_ans').removeClass('hide');
                    $('.option_symptoms a.send_mult_ans_type8').addClass('hide');
            	    
            	    // Bot Speech: Instruction
                    var plainText = $('.response-container h1').html();
                    text_to_speech(plainText);
            	    
            	    // Bot Speech: Tell Users to answer question
                    $(".option_symptoms ul li .overlay").each(function(i){
                        
                        var getQuestion = $(this).html();
                        
                        setTimeout(function(){
                            text_to_speech( getQuestion + ", Please answer if yes or no" );
                        },500 + ( i * 15000 ));
                        
                    });
            	    
            	    // Ask to add more or conitnue
            	    //prompt_more_symptoms();
            	    
            	    var user_id = $('body').data('user_id');
                    var patient_id = $('body').data('patient-id'); 
            	   
            	    sendQuestions();
            	    read_multAnswer( $('body').data('patient-id'), $('body').data('user_id') );
            	    
                }
                
                // Type 6
                if( data.response == 'success' && data.type == 'type6' ){
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    $('.form-container').hide();
                    
                    $('.front-social-media').hide();
                    $('.common-symptoms').hide();
                    //$('.option_symptoms').hide();
                    $('.button-container').remove();
                    $('.response-container').append('<div class="button-container"><a href="'+data.link+'">Click Here</a></div>');
                    
                }
                
                // Type 7
                if( data.response == 'success' && data.type == 'type7' ){
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                    $('.form-container').hide();
                    
                    $('.button-container').hide();
                    $('.error-report').show();
                	$('.error-report ul').html('');
                    
                    let result = data.symptoms_data;
            		for (let user_options of result) {
                	    
                	    if("link" in user_options){
                	        var optionLink = user_options.link;
                	        var cssclass = 'none';
                	    }else{
                	        var optionLink = 'javascript:;';
                	        var cssclass = 'back-to-main';
                	    }
                	    
                	    $('.error-report ul').append('<li><a href="'+optionLink+'" class="'+cssclass+'">'+user_options.option.question+'</a></li>');
                	    
            	    }
                
                }
                
                // Type 8
                if( data.response == 'success' && data.type == 'type8' ){
                    
                    if( data.symptoms !== undefined ){
                                
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                                
                    }else{
                                
                        // Add data to array
                        if( data.symptoms !== undefined ){
                            inputSymptoms.push( data.symptoms );
                        }
                                
                    }
                    
                    $('.response-container h1').text(data.text);
                    $('.response-container h6').text(' ');
                    $('.bot-reaction').removeClass('thinking');
                    $('.bot-reaction').addClass('idle');
                    $('.response-container h1').removeClass('thinking');
                    $('.form-container .textbox').removeClass('thinking');
                    $('.common-symptoms h6').removeClass('thinking');
                    $('.textbox.search_phrase').val('');
                        
                    // Set The Entity Value In storage
                    localStorage.setItem("entity", data.symptoms);
                        
                    if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                        $('.option_symptoms ol').html(''); // Reset the symptom option container  
                        $('.option_symptoms ul').html(''); // Reset the symptom option container
                        //$('.option_symptoms').fadeIn(); // Show the symptoms option container
                        
                        let result = data.symptoms_data;
            			for (let user_options of result) {
                			//console.log( user_options.option.Question );
                	        $('.option_symptoms ul').append('<li class="enabled"><div class="overlay">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
            	        }
            	        
            	        // Hide Search Form
            		    $('.form-container').hide();
                    }
                        
                    // Only show none of the above where there are options
                    if("symptoms_data" in data){
                        if( data.symptoms_data.length > 0 ){
                            $('.option_symptoms ul').append('<li class="none-of-above enabled"><div class="overlay">None of the above</div>None of the above</li>');
                        }
                    }
                    
                    $('.option_symptoms a.send_mult_ans_type8').removeClass('hide');
                    $('.option_symptoms a.send_mult_ans').addClass('hide');
                    
                }
                
            },
            
            failure: function(errMsg) {
                
                $('.response-container h1').text('I am malfunctioning! Try again later.');
                $('.bot-reaction').removeClass('thinking');
                $('.bot-reaction').addClass('angry');

            }
            
        });
        
    }
    
    // Function to send
    function sendText( sendTextData ){
        
        var patient_id = $('body').data('patient-id');
        var user_id = $('body').data('user_id');
        var text_data = sendTextData;
        
        $.ajax({
            type: "POST",
            url: 'process/sendText.php',
            
            data:{
                patient_id: patient_id,
                user_id: user_id,
                text_data: text_data
            },
            
            success: function(data){
            }
        
        });
        
    }
    
    // Initial Welcome Message: Text to speech
    var plainText = $('.response-container h1').html();
    text_to_speech(plainText);
    
    // Search Result Click
    $('body').on('click', '.ac_results li', function() {
        $('.textbox').val( $(this).text() );
        sendSymptoms();
    });
    
    // Common Symptoms
    $('body').on('click', '.common-symptoms a', function() {
        var symptom = $(this).attr('data-symptoms');
        $('.textbox.search_phrase').val(symptom);
        sendSymptoms();
    });
    
    // Refresh Button
    $('body').on('click', '.form-container .button.refresh', function() {
        //location.reload();
        $('.form-container .textbox').val('');
        refreshBot();
    });
    
    // Send Symptoms
    $('body').on('click', '.form-container .button.send', function() {
        sendSymptoms();
    });
    
    
    /* ==================================================== */
    // Multi Options 
    /* ==================================================== */
    $('body').on('click', '.option_symptoms li .overlay', function() {
        
        multipleAnswers = '';
        multipleAnswers_raw = [];
        
        if( $(this).parent().hasClass('checked') === true ){
            
            $(this).parent().removeClass('checked');
            
        }else{
            
            $(this).parent().addClass('checked');
            
        }
        
        $(".option_symptoms li.checked").each(function(i){
            
            var separator = '';
            
            if( $(".option_symptoms li.checked").last().index() == i ){
                separator = '';
            }else{
                separator = '$';
            }
            
            multipleAnswers = multipleAnswers+$('.overlay',this).text()+separator;
            multipleAnswers_raw.push( $(this).text() );
            
        });
        
    });
    
    $('body').on('click', '.send_mult_ans', function() {
        
        if( multipleAnswers !== '' ){
            
            var sendData = {
                "question" : multipleAnswers,
            };
            
            $.ajax({
                type: "POST",
                url: 'https://ddxrx.ai/questionSearch',
            
                data: JSON.stringify(sendData),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                        
                beforeSend: function() {
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking');
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                    //$('.option_symptoms').fadeOut();
                    $('.option_symptoms ul').html('');
                },
            
                success: function(data){
                    
                    console.log( data.text );
                    sendText(data.text);
                    
                    setTimeout(function(){
                        
                        // Display Response
                        $('.response-container h1').text(data.text);
                        
                        // Find and replace $ sign to , comma from response
                        var i;
                        for (i = 0; i < 10; i++) {
                            var text = $('.response-container h1').text();
                            $('.response-container h1').text(text.replace('$', ' + '));
                        }
                        
                        //$('.response-container h6').text(data.symptoms);
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                        // Add data to array
                        var i;
                        for( i = 0; i < data.symptoms.length; ++i ){
                            inputSymptoms.push( data.symptoms[i] );
                        }
                        
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        //localStorage.setItem("symptoms", inputSymptoms);
                        
                        // Auto Search
                        auto_submit();
                        
                        // Ask more search
                        prompt_more_symptoms();
                        
                        //console.log( inputSymptoms );
                        
                        $('.form-container').show();
                        
                    }, 1000);
                    
                },
                        
                failure: function(errMsg) {
            
                }
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Error...',
                text: 'Answer cannot be empty, please choose atleast one to proceed',
            })
            
        }
        
    });
    
    $('body').on('click', '.send_mult_ans_type8', function() {
        
        if( multipleAnswers !== '' ){
            
            var sendData = {
                "question" : multipleAnswers,
                "user_id": "1",
                "entity":""
            };
            
            $.ajax({
                type: "POST",
                url: 'https://ddxrx.ai/',
            
                data: JSON.stringify(sendData),
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                        
                beforeSend: function() {
                    $('.response-container h1').text('Thinking . . .');
                    $('.response-container h1').addClass('thinking');
                    $('.bot-reaction').removeClass('idle');
                    $('.bot-reaction').addClass('thinking');
                    $('.form-container .textbox').addClass('thinking');
                    $('.common-symptoms h6').addClass('thinking');
                    
                    //$('.option_symptoms').fadeOut();
                    $('.option_symptoms ul').html('');
                },
            
                success: function(data){
                    
                    setTimeout(function(){
                        
                        // Display Response
                        $('.response-container h1').text(data.text);
                        
                        // Find and replace $ sign to , comma from response
                        var i;
                        for (i = 0; i < 10; i++) {
                            var text = $('.response-container h1').text();
                            $('.response-container h1').text(text.replace('$', ' + '));
                        }
                        
                        //$('.response-container h6').text(data.symptoms);
                        $('.bot-reaction').removeClass('thinking');
                        $('.bot-reaction').addClass('idle');
                        $('.response-container h1').removeClass('thinking');
                        $('.form-container .textbox').removeClass('thinking');
                        $('.common-symptoms h6').removeClass('thinking');
                        $('.textbox.search_phrase').val('');
                        
                        // Set The Entity Value In storage
                        localStorage.setItem("entity", data.symptoms);
                        
                        if("symptoms_data" in data){ // Check if the object key exists(Sometimes it exists sometimes it doesn't depending on the API)
                            $('.option_symptoms ol').html(''); // Reset the symptom option container  
                            $('.option_symptoms ul').html(''); // Reset the symptom option container
                            //$('.option_symptoms').fadeIn(); // Show the symptoms option container
                            
                            let result = data.symptoms_data;
                			for (let user_options of result) {
                    			//console.log( user_options.option.Question );
                    	        $('.option_symptoms ul').append('<li class="enabled"><div class="overlay">'+user_options.option.question+'</div>'+user_options.option.question+'</li>');
                	        }
                	        
                	        // Hide Search Form
                		    $('.form-container').hide();
                        }
                            
                        // Only show none of the above where there are options
                        if("symptoms_data" in data){
                            if( data.symptoms_data.length > 0 ){
                                $('.option_symptoms ul').append('<li class="none-of-above enabled"><div class="overlay">None of the above</div>None of the above</li>');
                            }
                        }
                        
                        $('.option_symptoms a.send_mult_ans').removeClass('hide');
                        $('.option_symptoms a.send_mult_ans_type8').addClass('hide');
                        
                        // Auto Search
                        auto_submit();
                        
                        // Ask more search
                        prompt_more_symptoms();
                        
                        $('.form-container').show();
                        
                    }, 1000);
                    
                },
                        
                failure: function(errMsg) {
            
                }
            });
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Error...',
                text: 'Answer cannot be empty, please choose atleast one to proceed',
            })
            
        }
        
    });
    
    // None of the above got clicked
    $('body').on('click', '.option_symptoms li.none-of-above.enabled', function() {
        
        $('.response-container h1').html('Please enter a new symptom');
        //$('.option_symptoms').hide();
        $('.form-container').show();
    
    });
    
    
    /* ==================================================== */
    /* Navigation Menu */
    /* ==================================================== */
    $('body').on('click', '.nav-menu.open', function() {
        
        $('.wrapper').addClass('blur');
        $('#particles-js').addClass('blur');
        $('.nav-container').addClass('show');
        
        $('.nav-menu.open').addClass('close');
        $('.nav-menu.open').removeClass('open');
        
    });
    
    $('body').on('click', '.nav-menu.close', function() {
        
        $('.wrapper').removeClass('blur');
        $('#particles-js').removeClass('blur');
        $('.nav-container').removeClass('show');
        
        $('.nav-menu.close').addClass('open');
        $('.nav-menu.close').removeClass('close');
        
    });
    
    
    
    // Refresh Bot
    function refreshBot(){
        
        $('.response-container h1').html('How may I help you?');
        
        localStorage.setItem("entity", "");
    
        // Declare variable
        inputSymptoms = [];
        multipleAnswers = [];
        multipleAnswers_raw = [];
        
        text = '';
        symptoms_list = localStorage.getItem("symptoms");
        
        arrstring = inputSymptoms.toString();
        ArrSearchResult = arrstring.search('follow-up') !== -1;
        symptom = $(this).attr('data-symptoms');
        
        user_id = '1';
        userInput = $('.search_phrase').val();
        entity = localStorage.getItem("entity");
                
        sendData = '';
        
        text = '';
        i = '';
        separator = '';
        sendData = '';
        
        
        Swal.fire({
            icon: 'info',
            title: 'Bot Refreshed',
            text: "Bot's memory has been refreshed",
        });
        
    }
    
    // Menu Bar Height
    var NavHeight = $('.menu-bar').outerHeight();
    NavHeight = NavHeight+100;
    $('.menu-bar-spacer').css("height", NavHeight);
    
    
    // Back Button
    $('body').on('click', '.back-to-main', function() {
        
        $('.error-report').hide();
        $('.form-container').show();
        $('.common-symptoms').show();
        
    });
    
});























