$(document).ready(function(){

    // Check for changes every second
    //setInterval(function(){

        var patient_id = $('body').data('patient-id');

        $.ajax({
            type: 'POST',
            url: 'process/dictation-checker.php',
            data: {
                patient_id: patient_id
            },
        
            beforeSend: function () {
                // Do something before sending the request
            },

            success: function (response) {
                
                if( response.result != false ){

                    // Assuming response is an array of items
                    var items = response.items; // Adjust this based on the actual structure of your response
                
                    var buttons = '';
                
                    // Create buttons based on the number of items
                    for (var i = 0; i < items.length; i++) {
                        var itemId = i + 1;
                
                        var ItemDetails = '<div class="itemDetails item_' + itemId + '"><div class="descriptionOriginal" data-dictation-id="'+itemId+'"><h6>Physician Dictation</h6><textarea class="editor"></textarea><p><span>' + items[i].message + '</span><a href="#" class="edit"><i class="fa-regular fa-pen-to-square"></i> Edit</a></p> <i class="fa-solid fa-wand-magic-sparkles fa-beat-fade aienhanceBtn" data-add-id="' + itemId + '"></i><a href="#" class="addBtn"><div class="inner"><i class="fa-solid fa-circle-plus"></i><span>Add Dictation</span></div></a><a href="#" class="save-edit"><div class="inner"><i class="fa-solid fa-floppy-disk"></i><span>Save Changes</span></div></a></div></div>';
                
                        buttons += '<div class="dictationItem" id="dictation_' + itemId + '" data-dictation-id="'+itemId+'"><div class="dictationBtn"><a href="#" class="btnTitle" data-dictation-button="' + itemId + '"><i class="fa-solid fa-chevron-right"></i> Dictation ' + itemId + '</a><i class="fa-solid fa-arrow-up-right-from-square expandIcon"></i></div>' + ItemDetails + '</div>';
                    }
                
                    // Append buttons to container
                    $('.dictation-button-container .dictation-original .items').html(buttons);

                }else{

                    $('.dictation-original .items').html('<div class="warning"><i class="fa-solid fa-circle-exclamation"></i> There are currently no dictation right now.</div>');

                }

            },
        
            error: function (error) {
                console.error('Error:', error);
            }
        });
        
    //}, 1000);

    // Toggle the dictation
    $('body').on('click', '.dictation-button-container .dictationItem .dictationBtn', function() {

        // Toggle details
        $(this).siblings('.itemDetails').toggle();

    });

    // Inserting dictation
    // $('body').on('click', 'a.dictationBtn.enabled', function() {
    //     var dictationBtnNo = $(this).data('dictation-button');
    //     var dictationText = $('.dictation-'+dictationBtnNo).html();

    //     // Append Dictation
    //     $('.results-container .textarea').append('Dictation No.' + dictationBtnNo + ': ' + dictationText + '\n');

    // });

    $('body').on('click', '.dictation-button-container .dictationItem .itemDetails .descriptionOriginal .addBtn', function(e){

        // Prevent default behaviour
        e.preventDefault();

        var dictationNumber = $(this).parent().attr('data-dictation-id');
        var dictationText = $(this).siblings('p').children('span').html();
        
        $('.results-container .textarea').append('Dictation No.' + dictationNumber + ': ' + dictationText + '\n');

        const Toast = Swal.mixin({
            toast: true,
            position: "bottom-left",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.onmouseenter = Swal.stopTimer;
              toast.onmouseleave = Swal.resumeTimer;
            }
          });
          Toast.fire({
            icon: "success",
            title: "Dictation No. ("+dictationNumber+") Added!"
          });

    });

    $('body').on('click', '.dictation-button-container .enhanced-dictation .addEnhancedBtn', function(e){
        
        var dictationText = $('.dictation-button-container .enhanced-dictation .items p').html();

        $('.results-container .textarea').append('Custom Dictation: ' + dictationText + '\n');

        const Toast = Swal.mixin({
            toast: true,
            position: "bottom-left",
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
              toast.onmouseenter = Swal.stopTimer;
              toast.onmouseleave = Swal.resumeTimer;
            }
          });
          Toast.fire({
            icon: "success",
            title: "AI Dictation Added!"
          });

    });

    // AI Enchance Dictation Button
    $('body').on('click', '.dictation-button-container .aienhanceBtn', function() {

        var itemID = $(this).attr('data-add-id');
        var dictationText = $('#dictation_'+itemID+' .itemDetails p span').html();

        $.ajax({
            url: 'https://doctorai.online/api/ai/llm/notes',
            type: 'POST',
            data: dictationText,

            beforeSend: function () {
                $('.dictation-button-container .enhanced-dictation').fadeIn();
                $('.dictation-button-container .enhanced-dictation .items').html('<h6>Please wait while our AI is analyzing the dictation...</h6><i class="fa-solid fa-spinner fa-spin-pulse"></i>')
            },

            success: function (response) {

                //var out = response;

                let lines = response.split("\n");
                var output = "";
                for (let line of lines) {
                    if (line.trim().length === 0) {
                    continue;
                    }
                    if (line.trim().endsWith(":")) {
                    output += `<p style="font-weight: bold;">${line}</p>`;
                    } else {
                    output += `<p>${line}</p>`;
                    }
                }

                $('.dictation-button-container .enhanced-dictation .items').html(output);
            }
            
        });

    });

    // Dictation edit
    $('body').on('click', '.dictation-button-container .dictationItem .itemDetails .descriptionOriginal .edit', function(e){

        // Prevent default behaviour
        e.preventDefault();

        // Get contents of dictation and store in a variable
        var dictationText = $(this).siblings().html();

        // Show Textarea
        $(this).parent().siblings('.editor').fadeIn();

        // Remove current values of a textarea
        $(this).parent().siblings('.editor').val('');

        // Insert dictation to textarea
        $(this).parent().siblings('.editor').val(dictationText);

        // Hide dictation text
        $(this).parent().hide();

        // Hide add dictationb button to prevent adding the unsaved text
        $(this).parent().siblings('addBtn').hide();

        // Hide magic button
        $(this).parent().siblings('.aienhanceBtn').hide();

        // Hide save button
        $(this).parent().siblings('.addBtn').hide();

        // Add save edit button
        $(this).parent().siblings('.save-edit').css('display','inline-block');

    });

    // Save dictation
    $('body').on('click', '.dictation-button-container .dictationItem .itemDetails .descriptionOriginal .save-edit', function(e){

        // Prevent default behaviour
        e.preventDefault();

        // Store values to variable
        var newDictationNote = $(this).siblings('.editor').val();

        // Overwrite to dictation notes
        $(this).siblings('p').html('<span>'+newDictationNote+'</span><a href="#" class="edit"><i class="fa-regular fa-pen-to-square"></i> Edit</a>');

        // Show dictation
        $(this).siblings('p').show();

        // Hide Editor
        $(this).siblings('.editor').hide();

        // Show magic button
        $(this).siblings('.aienhanceBtn').show();
        
        // Show add dictation button
        $(this).siblings('.addBtn').css('display','inline-block');

        // Hide this button
        $(this).hide();

    });

});
