$(document).ready(function(){

    // Edit link
    $('.dictation-list .link.edit').click(function(e){

        // Prevent default behaviour
        e.preventDefault();

        // Hide Content
        $(this).parent().hide();

        // Show editor
        $(this).parent().siblings().show();

        // Reset Placeholder
        $('.aienhanced-placeholder').html();

        // Hide placeholder
        $('.aienhanced-placeholder').hide();

        // Hide Alt Buttons
        $(".plain.aienhanceBtn").hide();
        $(".plain.aienhanceloading").hide();

    });

    // Cancel button
    $('.dictation-list .link.cancel').click(function(e){
        
        // Prevent default behaviour
        e.preventDefault();

        var original_content = $(this).parent().siblings().children('p').html();

        // Restore the original content
        $(this).siblings('.text-editor').val(original_content);

        // Hide editor
        $(this).parent().hide();

        // Show content
        $(this).parent().siblings().show();

        // Show Alt Buttons
        $(".plain.aienhanceBtn").show();

    });

    // Save button
    $('.dictation-list .link.save').click(function(e){
        
        // Prevent default behaviour
        e.preventDefault();

        // Variables
        var dictation_id = $(this).parent().parent().parent().data('id');
        var text_content = $(this).siblings('.text-editor').val();

        $.ajax({
            type: 'POST',
            url: 'process/edit-dictation.php',
            data: {
                dictation_id: dictation_id,
                text_content: text_content
            },

            success: function (response) {
                
                if( response.result == true ){

                    // Retain content into the placeholder
                    $('#dictation_'+dictation_id+' .view-container p').html(text_content);

                    // Hide editor
                    $('#dictation_'+dictation_id+' .edit-container').hide();

                    // Show Content
                    $('#dictation_'+dictation_id+' .view-container').show();

                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: response.icon,
                    title: response.title
                });

            },
        
            error: function (error) {
                console.error('Error:', error);
            }
        });

    });

    // AI Enhanced: Editor
    $('.editor.aienhanceBtn').click(function(){
        
        var dictationText = $(this).siblings('.text-editor').val();
        var dictation_id = $(this).parent().parent().parent().attr('id');

        $.ajax({
            url: 'https://doctorai.online/api/ai/llm/notes',
            type: 'POST',
            data: dictationText,

            beforeSend: function(){

                // Hide button & Show loading
                $('#'+dictation_id+' .aienhanceBtn').hide();
                $('#'+dictation_id+' .aienhanceloading').show();

            },

            success: function (response) {

                // Process results
                let lines = response.split("\n");
                var output = "";
                for (let line of lines) {
                    if (line.trim().length === 0) {
                    continue;
                    }
                    if (line.trim().endsWith(":")) {
                    output += `<p style="font-weight: bold;">${line}</p>`;
                    } else {
                    output += `<p>${line}</p>`;
                    }
                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: 'success',
                    title: 'AI Notes Completed'
                });

                // Output results
                $('#'+dictation_id+' .aienhanced-placeholder').html(output);

                // Show placeholder
                $('#'+dictation_id+' .aienhanced-placeholder').show();

                // Secretly change value of the textarea
                $('#'+dictation_id+' .text-editor').val(response);

                // Hide Text Editor
                $('#'+dictation_id+' .text-editor').hide();

                // Bring back the button & Hide loading
                $('#'+dictation_id+' .aienhanceBtn').show();
                $('#'+dictation_id+' .aienhanceloading').hide();

            }
            
        });

    });

    // AI Enhanced: Plain
    $('.plain.aienhanceBtn').click(function(){
        
        var dictationText = $(this).siblings('.edit-container').children('.text-editor').val();
        var dictation_id = $(this).parent().parent().attr('id');

        $.ajax({
            url: 'https://doctorai.online/api/ai/llm/notes',
            type: 'POST',
            data: dictationText,

            beforeSend: function(){

                // Show loading
                $('#'+dictation_id+' .plain.aienhanceloading').show();
                $('#'+dictation_id+' .plain.aienhanceBtn').hide();

                $('#'+dictation_id+' .view-container .edit').hide();

            },

            success: function (response) {

                // Process results
                let lines = response.split("\n");
                var output = "";
                for (let line of lines) {
                    if (line.trim().length === 0) {
                    continue;
                    }
                    if (line.trim().endsWith(":")) {
                    output += `<p style="font-weight: bold;">${line}</p>`;
                    } else {
                    output += `<p>${line}</p>`;
                    }
                }

                const Toast = Swal.mixin({
                    toast: true,
                    position: "bottom-end",
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                      toast.onmouseenter = Swal.stopTimer;
                      toast.onmouseleave = Swal.resumeTimer;
                    }
                });

                Toast.fire({
                    icon: 'success',
                    title: 'AI Notes Completed'
                });

                // Output results
                $('#'+dictation_id+' .view-container p').html(output);

                // Show placeholder
                $('#'+dictation_id+' .aienhanced-placeholder').show();

                // Hide loading
                $('#'+dictation_id+' .aienhanceloading').hide();

            }
            
        });

    });

});