$(document).ready(function(){

    // Login
    $('body').on('submit', '.login-form', function(e) {
        
        // Prevent the form from submitting
        e.preventDefault();

        var username = $('.login-form .textbox.username').val();
        var password = $('.login-form .textbox.password').val();

        // Check if Username & Password is not empty
        if( username != '' && password != '' ){

            // Show Popup
            $('.disclaimer-popup-container').addClass('show');

        }else{

            Swal.fire({
                icon: "warning",
                title: "Empty Fields",
                text: "Empty username or password, please fill up the fields before attempting to login.",
            });

        }

    });
    
    $('.disclaimer-popup-container .disclaimer-container .button-container a.btn.agree').click(function(e){
        
        // Prevent the form from submitting
        e.preventDefault();

        var username = $('.login-form .textbox.username').val();
        var password = $('.login-form .textbox.password').val();
        var action = $('.login-form').attr('action');

        // Send Data to Server
        $.ajax({
            url: action,
            type: 'POST',
            data: {
                username: username,
                password: password
            },
            success: function(data){
                
                $('.disclaimer-popup-container').removeClass('show');

                if( data.result === true ){
                        
                    // Store GUID in Local Storage
                    var patientData = {};
                    patientData.waitingroom_id = data.login_details.waitingroom_id;
                    patientData.idKey = data.login_details.guid;
                    patientData.checkInTime = Date.now();
                    localStorage.setItem("patient", JSON.stringify(patientData));

                    // Redirect
                    window.location.href = data.redirect_url;
        
                }else{
        
                    Swal.fire({
                        icon: data.icon,
                        title: data.title,
                        text: data.text,
                    })
        
                }
        
            }

        });

    });

    // Disagree
    $('.disclaimer-popup-container .disclaimer-container .button-container a.btn.disagree').click(function(e){
        
        // Prevent the form from submitting
        e.preventDefault();

        $('.disclaimer-popup-container').removeClass('show');

    });

});