jQuery(document).ready(function($){

	/* ====================================== */
	// Auto adjust height of symptom list
	/* ====================================== */
	/*
	var search_cont_height = $('.search-diagnosis-container').innerHeight();
	$('.diaglosis-list-container').css('height',search_cont_height+'px');
	$('.transfer-container').css('height',search_cont_height+'px');
	*/

	/* ====================================== */
	// Radio Button: Probability
	/* ====================================== */
	$('.tab-content-container .switch').click(function(){
		$(this).toggleClass("on");
	});

	/* ====================================== */
	// Prevent other elements from becoming clickable
	/* ====================================== */
	$('.tab-content-container label span').click(function(e){
		e.preventDefault();
	});


	/* ====================================== */
	// Patient Notes Show/Hide
	/* ====================================== */
	$('.patient-record-container .patient-record-form .close, .button.cancel').click(function(){
		$('.patient-record-container').addClass('hide');
	});

	$('.tab-content-container .add_note').click(function(){
		$('.patient-record-container').removeClass('hide');
	});
	
	var menuHeight = $('.mobile-menu-container').height();
	var screenHeight = $(window).height();
	var finalHeight = screenHeight-menuHeight-60;
	
	$('.patient-record-form').css( 'height', finalHeight );



	/* ====================================== */
	// Reverse Diagnosis Values
	/* ====================================== */
	$('.form-container').on('click', '.transfer-container .transfer.left', function() {

		var counter = 0;

		$('.diaglosis-list-container ul li').each(function(){
			counter++;

			$('.search-'+counter).val($(this).text());

			//alert($(this).text());
  		});

  		// Empty the list
  		$('.diaglosis-list-container ul').html(' ');

	});



	/* ====================================== */
	// Create New Diagnosis form
	/* ====================================== */

	$('.add-more-container a').click(function(){

		var counter = 0;
		$('.search-diagnosis-container .textbox').each(function(){
			counter++;
		});

		var new_counter = counter+1;

		// Add New Box
		$('.dynamic_textbox').append('<label><span>Enter Diagnosis</span><input type="text" class="textbox search-'+new_counter+'" placeholder="Type to search diagnosis"></label>');

		// Update Height
		//var search_cont_height = $('.search-diagnosis-container').innerHeight();
		//$('.diaglosis-list-container').css('height',search_cont_height+'px');

	});





	$('.diaglosis-list-container ul li strong.approve').click(function(){

		var user_id = $(this).data('approve-id');
		var history = $('.diaglosis-list-container ul').data('base');

		$.ajax({
			type: 'POST',
			url: 'process/approve_medical.php',

			data: {
				user_id:user_id,
				history:history
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				
				$('#diagnosis_'+user_id+' span.pending').remove();
				$('#diagnosis_'+user_id+' strong.approve').remove();
				
			},
						
			fail: function(response){
				alert('Update Failed!');
			}
		});

	});
	
	
	// Intor Button
    $('.demo-button').click(function(e){
       introJs().addHints();
    });
    
    
    $('.submitOrderData').click(function(){
        
        // Patient ID
        var patient_id = $('body').data('patient_id');
        
        // Variables for diet
        var diet = [];
        var diet_item;
        
        // Variables for activity
        var activity = [];
        var activity_item;
        
        // Variables for medication
        var medication = [];
        var medication_item;
        
        // Store selected values in array for diet plat
        $('.order_entry_list_container.diet_plan label .checkbox').each(function(){
            
            if( $(this).prop('checked') === true ){
                
                diet_item = $(this).val();
                diet.push(diet_item);
                
            }
            
        });
        
        // Store selected values in array for activity plan
        $('.order_entry_list_container.activity_plan label .checkbox').each(function(){
            
            if( $(this).prop('checked') === true ){
                
                activity_item = $(this).val();
                activity.push(activity_item);
                
            }
            
        });
        
        // Store selected values in array for medication plan
        $('.order_entry_list_container.medication_plan label .checkbox').each(function(){
            
            if( $(this).prop('checked') === true ){
                
                medication_item = $(this).val();
                medication.push(medication_item);
                
            }
            
        });
        
        var obj = { patient_id, diet, activity, medication }
        var JsonResult = JSON.stringify(obj);
        
        console.log( JsonResult );
        
        $.ajax({
            type: "POST",
            url: 'process/send_order.php',
                    
            data: JsonResult,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                                
            beforeSend: function() {},
            success: function(data){},
            failure: function(errMsg) {}
        
        });
        
        
        // Send abnormal vitals
        var patient_id = $('body').data('patient_id');
        
        var systolicBP = $('.systolicBP').val();
        var diastolicBP = $('.diastolicBP').val();
        var heartRate = $('.heartrate').val();
        var respRate = $('.respiratoryrate').val();
        var pulseOX = $('.pulseOX').val();
        var temp = $('.temperature').val();
        var glucose = $('.glucose').val();
        var weight = $('.weight').val();
        
        $.ajax({
            type: "POST",
            url: 'process/save_vital_history.php',
            data: {
            	patient_id:patient_id,
            	systolicBP:systolicBP,
            	diastolicBP:diastolicBP,
            	heartRate:heartRate,
            	respRate:respRate,
            	pulseOX:pulseOX,
            	temp:temp,
            	glucose:glucose,
            	weight:weight
            },
            success: function(data){
                $('.systolicBP').val('');
                $('.diastolicBP').val('');
                $('.heartrate').val('');
                $('.respiratoryrate').val('');
                $('.pulseOX').val('');
                $('.temperature').val('');
                $('.glucose').val('');
                $('.weight').val('');
            },
        });
        
        Swal.fire({
            icon:  'success',
            title: 'Data Saved',
            text:  'Your dava have successfully sent to our database',
        });
        
    });
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

});



































