jQuery(document).ready(function($){
    
	// Function to validate Email
	function validateEmail(email) {
    	var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    	return emailReg.test( email );
	}

	// Used to format phone number
	function phoneFormatter() {
		$('.phone_number').on('input', function() {
	    	var number = $(this).val().replace(/[^\d]/g, '')
	    if (number.length == 7) {
	    	number = number.replace(/(\d{3})(\d{4})/, "$1-$2");
	    } else if (number.length == 10) {
	    	number = number.replace(/(\d{3})(\d{3})(\d{4})/, "($1) $2-$3");
	    }
	   		$(this).val(number)
		});
	};

	$(phoneFormatter);

	$(".button.next.step-1").click(function(){

		var first_name = $('.first_name').val();
		var middle_name = $('.middle_name').val();
		var last_name = $('.last_name').val();
		var occupation = $('.occupation').val();
		var birthday = $('.birthday').val();
		//var gender = $('.gender').val();
		var gender = $("input[name='gender']:checked").val();
		var phone_number = $('.phone_number').val();
		var email_address = $('.email_address').val();
		var username = $('.username').val();
		var password = $('.password').val();
		var repeat_password = $('.repeat_password').val();
		var nda_agreement = $('.checkbox.nda-agreement').is(':checked');

		var username_validation = $('.username').data('username-validate');
		var email_validation = $('.email_address').data('email-validate');

		// Check all textbox if it is valid
  		$(".validation").each(function(){
  			if( $(this).val() == '' ){
  				$(this).addClass('required');
  				$('.notice-container').html('<p>Fields in red are required</p>');
  				$('.notice-container').fadeIn();
  			}
		});

  		// Check Select box if it is valid
  		var selectbox = $('.selectbox option:selected').val();
  		if( selectbox == '' ){
  			$('.selectbox').addClass('required');
  		}else{
  			$('.selectbox').removeClass('required');
  		}

        

  		if( first_name != '' && last_name != '' && occupation != '' && birthday != '' && gender != '' && phone_number != '' && email_address != '' && username != '' && password != '' && username_validation == 'true' && email_validation == 'true' ){
  			if( password == repeat_password ){
  				if( validateEmail(email_address) ){
  				    if( nda_agreement == true ){
                
        				$.ajax({
        					type: 'POST',
        					url: 'new_patient_new.php',
                            dataType: "json",
        					data: {
        						first_name:first_name,
        						middle_name:middle_name,
        						last_name:last_name,
        						occupation:occupation,
        						birthday:birthday,
        						gender:gender,
        						phone_number:phone_number,
        						email_address:email_address,
        						username:username,
        						password:password
        					},
        
        					beforeSend: function() {
        						// Do Something
        					},
        					success: function(response) {
        						// Do Something
        						console.log('The ID: '+response.user_id);
        						$(".payment-wrapper").attr("data-user-id", response.user_id);
        						$('.section.section-1').hide();
        						$('.section.section-2').fadeIn();
        
        						$('.steps .first').removeClass('current');
        						$('.steps .second').addClass('current');
        					},	
        					fail: function(response){
        					// Do Something
        					}
        				});
        				$('.notice-container').fadeOut();
        				
  				    }else{
                        
                        $('.notice-container').html('<p>Please sign the terms and condition by clicking on the checkbox</p>');
                        $('.notice-container').fadeIn();
                          
  				    }
				}else{
					$('.notice-container').html('<p>Invalid Email Address</p>');
	  				$('.notice-container').fadeIn();

	  				$('.email_address').addClass('required');
				}
			}else{

				$('.notice-container').html('<p>Password and Repeat Password fields do not match</p>');
  				$('.notice-container').fadeIn();

  				$('.password').addClass('required');
  				$('.repeat_password').addClass('required');

			}
		}

		$('.textbox').on('input',function(e){
    		$(this).removeClass('required');
    		$('.notice-container').fadeOut();
		});

	});

	$(".button.next.step-2").click(function(){
        
        var user_id = $('.payment-wrapper').attr('data-user-id');
        var billing_address = $('.billing_address').val();
        var billing_city = $('.billing_city').val();
        var billing_state = $('.billing_state').val();
        var billing_zip = $('.billing_zip').val();
        
        $.ajax({
			type: 'POST',
			url: 'process/insert_billing.php',
			data: {
				user_id:user_id,
				billing_address:billing_address,
				billing_city:billing_city,
				billing_state:billing_state,
				billing_zip:billing_zip
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				$('.section.section-2').hide();
        		$('.section.section-3').fadeIn();
        
        		$('.steps .second').removeClass('current');
        		$('.steps .third').addClass('current');
			},	
			fail: function(response){
			// Do Something
			}
		});

	});

	$(".back.step-2").click(function(){

		$('.section.section-2').hide();
		$('.section.section-1').fadeIn();

		$('.steps .first').addClass('current');
		$('.steps .second').removeClass('current');

	});

	$(".back.step-3").click(function(){

		$('.section.section-3').hide();
		$('.section.section-2').fadeIn();

		$('.steps .second').addClass('current');
		$('.steps .third').removeClass('current');

	});


	/* ============================================================ */
	/* Check User */
	/* ============================================================ */
	$('.username').on("change keyup", function(e) {

		var username = $('.username').val();

		if( username != '' ){ // Start If

			// Start Ajax
			$.ajax({
				type: 'POST',
				url: 'process/check_user.php',

				data: {
					username:username
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {
					// Do Something
					if(response == 'valid'){
						$('.check_user_status').html('Available');
						$('.check_user_status').removeClass('red');
						$('.check_user_status').addClass('green');
						$('.username').data('username-validate', 'true');
						console.log( $('.username').data('username-validate') );

					}else{
						$('.check_user_status').html('Unavailable');
						$('.check_user_status').removeClass('green');
						$('.check_user_status').addClass('red');
						$('.username').data('username-validate', 'false');
						console.log( $('.username').data('username-validate') );
					}
				},	
				fail: function(response){
				// Do Something
				}
			});
			// End Ajax

		} // End if

	});


	/* ============================================================ */
	/* Check Email */
	/* ============================================================ */

	$('.email_address').on("change keyup", function(e) {

		var email_address = $('.email_address').val();

		if( email_address != '' ){ // Start If

			// Start Ajax
			$.ajax({
				type: 'POST',
				url: 'process/check_email.php',

				data: {
					email_address:email_address
				},

				beforeSend: function() {
					// Do Something
				},
				success: function(response) {
					// Do Something
					if(response == 'valid'){
						$('.check_email_status').html('Available');
						$('.check_email_status').removeClass('red');
						$('.check_email_status').addClass('green');
						$('.email_address').data('email-validate', 'true');
						console.log( $('.email_address').data('email-validate') );
					}else{
						$('.check_email_status').html('Unavailable');
						$('.check_email_status').removeClass('green');
						$('.check_email_status').addClass('red');
						$('.email_address').data('email-validate', 'false');
						console.log( $('.email_address').data('email-validate') );
					}
				},	
				fail: function(response){
					// Do Something
				}
			});
			// End Ajax

		} // End if

	});
    
    
    /* ============================================================ */
	/* Gender Radio Box */
	/* ============================================================ */
	
	$('.payment-form .radio-group label').click(function(){
	    
	    $('.payment-form .radio-group label .checkbox').removeClass('active');
	    $('.checkbox',this).addClass('active');
	    
	    var gender = $("input[name='gender']:checked").val();
	    console.log(gender);
	    
	})

    
    /* ============================================================ */
	/* Stripe Script */
	/* ============================================================ */
    // var stripe = Stripe('pk_test_vtuAOjwWO0WKTGxkW8isBtqJ000WWmMHkW');
    var stripe = Stripe('pk_live_IPuqKaZg6bNzEcMULCfsXPht00SENC6WFj');
            
    // Create an instance of Elements.
    var elements = stripe.elements();
            
    // Custom styling can be passed to options when creating an Element.
    // (Note that this demo uses a wider set of styles than the guide below.)
    
    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                  color: '#aab7c4'
                }
              },
              invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
              }
            };
            
            // Create an instance of the card Element.
            var card = elements.create('card', {style: style});
            
            // Add an instance of the card Element into the `card-element` <div>.
            card.mount('#card-element');
            
            // Handle real-time validation errors from the card Element.
            card.addEventListener('change', function(event) {
              var displayError = document.getElementById('card-errors');
              if (event.error) {
                displayError.textContent = event.error.message;
              } else {
                displayError.textContent = '';
              }
            });
            
            // Handle form submission.
            var form = document.getElementById('payment-form');
            form.addEventListener('submit', function(event) {
              event.preventDefault();
            
              stripe.createToken(card).then(function(result) {
                if (result.error) {
                  // Inform the user if there was an error.
                  var errorElement = document.getElementById('card-errors');
                  errorElement.textContent = result.error.message;
                } else {
                  // Send the token to your server.
                  stripeTokenHandler(result.token);
                }
              });
            });
            
            // Submit the form with the token ID.
            function stripeTokenHandler(token) {
              // Insert the token ID into the form so it gets submitted to the server
              var form = document.getElementById('payment-form');
              var hiddenInput = document.createElement('input');
              hiddenInput.setAttribute('type', 'hidden');
              hiddenInput.setAttribute('name', 'stripeToken');
              hiddenInput.setAttribute('value', token.id);
              form.appendChild(hiddenInput);
            
              // Submit the form
              form.submit();
            }

    
    /* ============================================================ */
	/* Custom Radio Box */
	/* ============================================================ */
    $('.price-selection .item.enabled').click(function(){
        $('.price-selection .item').removeClass('current');
        $(this).addClass('current');
    });
    
    
    
    $('.textbox, .checkbox').on('input propertychange paste focus click', function() {

        var first_name = $('.first_name').val();
		var middle_name = $('.middle_name').val();
		var last_name = $('.last_name').val();
		var occupation = $('.occupation').val();
		var birthday = $('.birthday').val();
		//var gender = $('.gender').val();
		var gender = $("input[name='gender']:checked").val();
		var phone_number = $('.phone_number').val();
		var email_address = $('.email_address').val();
		var username = $('.username').val();
		var password = $('.password').val();
		var repeat_password = $('.repeat_password').val();
		var nda_agreement = $('.checkbox.nda-agreement').is(':checked');

		var username_validation = $('.username').data('username-validate');
		var email_validation = $('.email_address').data('email-validate');
		
		$('.button.step-1').removeClass('disabled');
		$('.button.step-1').addClass('disabled');
        
        if( first_name != '' && last_name != '' && birthday != '' && gender != '' && phone_number != '' && email_address != '' && username != '' && password != '' && username_validation == 'true' && email_validation == 'true' && $('.checkbox').is(':checked') ){
      		$('.button.step-1').removeClass('disabled');
        }else{
            $('.button.step-1').addClass('disabled');
        }
    });
    
});