jQuery(document).ready(function($){
    
    function watermark(){
        
    	var canvas = $("#canvas-container canvas").get(0);
    	var current_date_time = $('.order-date').text();
    	var provider_name = $('#provider_name').val();
        var ctx = canvas.getContext("2d");
        
    	const pixelSize = 20;
    	const width = ctx.measureText("text").width;
    	const height = pixelSize * 3 / 4;
    	
    	ctx.fillStyle = "#AAAAAA";
    	ctx.font = pixelSize +"px serif";
    	ctx.fillText(("Date & Time: " + current_date_time), 15, 30);
    	ctx.fillText(("By:"+provider_name), 15, 60);
	
    }
    
	// Load Canvas
	$('#canvas-container').jqScribble();
	watermark();
	

	// Reset Canvas
	$('.clear_canvas').click(function(){
	    $('#canvas-container').data('jqScribble').clear();
	    watermark();
	});
	
	// Save Image
	var $canvas = $("canvas");
	
	$('.tab-content-container').on('click', '.button.blue.save_canvas', function() {
    
        var user_id = $('body').data('user-id');
        var image_url = $canvas[0].toDataURL('image/png');
        
        $.ajax({
			type: 'POST',
			url: 'process/save_image.php',
			data: {
				image_url:image_url,
				user_id:user_id
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response == 'true'){
				    
				    Swal.fire({
                        type: 'success',
                        title: 'Sign order has been saved',
                        showConfirmButton: true,
                    })
				    window.location.href = "order_list.php?id="+user_id;
				    
				}
				console.log(response);
			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}
		});
        
    });
    
	$('.tab-content-container').on('click', '.button.blue.open.save', function() {
		
		var patient_id = $('#patient_id').val();
		var provider_id = $('#provider_id').val();
        var user_id = $('body').data('patient-id');
        var image_url = $canvas[0].toDataURL('image/png');
        
        $.ajax({
			type: 'POST',
			url: 'process/save_image_open.php',
			data: {
				image_url:image_url,
				user_id:user_id,
				provider_id:provider_id
			},

			beforeSend: function() {
				// Do Something
			},
			success: function(response) {
				// Do Something
				if(response.status == 'success'){
				    
				    Swal.fire({
                        type: 'success',
                        title: 'Sign order has been saved',
                        showConfirmButton: true,
                    })
				    
					Swal.fire({
						title: 'Order Saved',
						text: "Signed order has been saved",
						icon: 'success',
						showCancelButton: false,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Done'
					}).then((result) => {
						if (result.isConfirmed) {

							// Redirect to page
							window.location.href = "order-app.php?patient_id=" + user_id;

						}
					});
				    
				}

			},	
			fail: function(response){
				// Do Something
				//alert('false');
			}
		});
        
    });
    
    // Detect Checkbox
    $(".signature").change(function() {
        if(this.checked) {
            $('.save_canvas').removeClass('gray');
            $('.save_canvas').addClass('blue');

			$('.save').removeClass('gray');
            $('.save').addClass('blue');
        }else{
            $('.save_canvas').addClass('gray');
            $('.save_canvas').removeClass('blue');

			$('.save').addClass('gray');
            $('.save').removeClass('blue');
        }
    });
    
}); // End of Jquery



// Redirect
jQuery(document).ready(function($){

	$('.refresh').click(function(){

		var patient_id = $(this).data('patient-id');
		window.location.href = "order-app.php?patient_id=" + patient_id;

	});

});