$(document).ready(function(){
    
    var rate = '';
    
    /* -------------------------------------------------------------- */
    // Feedback Selector
    /* -------------------------------------------------------------- */
    //$('.feedback-group .item').click(function(){
    $(document).on('click', '.feedback-group .item.inactive', function(){
        $(this).removeClass('inactive');
        $(this).addClass('active');
    });
    $(document).on('click', '.feedback-group .item.active', function(){
        $(this).removeClass('active');
        $(this).addClass('inactive');
    });
    
    /* -------------------------------------------------------------- */
    // Select Ratings
    /* -------------------------------------------------------------- */
    $('.rate-popup ion-icon').click(function(){
        
        // Reset Star Values
        $('.rate-popup ion-icon').attr('name', 'star-outline');
        
        // Register Rate
        var rate = $(this).data('rate');
        localStorage.setItem("rate", rate);
        
        for (i = 0; i<=rate; i++) {
            
            // Iterate and change star value
            $('.rate-'+i).attr('name', 'star');
            
        }
        
        $('.feedback-group').hide();
        $('.feedback-group .item.active').removeClass('active');
        $('.feedback-group .item.active').addClass('inactive');
        
        if( rate == '1' || rate == '2' ){
            
            $('.rate-popup-container .rate-popup p').html("We're sorry you have a bad experience, can you tell us which part of the website you didn't like? <br><br>We take your feedback seriously and will improve our service.");
            $('.rate-popup-container .rate-popup .reactions').html('<div><img src="assets/images/emoticon/sad.svg" class="emoticon"></div>');
            $('.feedback-group.low').show();
            
        }else if( rate == '3' ){
            
            $('.rate-popup-container .rate-popup p').html("Thanks for the rating! Can you tell me which part of the website you didn't like?");
            $('.rate-popup-container .rate-popup .reactions').html('<div><img src="assets/images/emoticon/smiling.svg" class="emoticon"></div>');
            $('.feedback-group.mid').show();
            
        }else if( rate == '4' || rate == '5' ){
            
            $('.rate-popup-container .rate-popup p').html("Excellent rating! What did you enjoy about doctor ai?");
            $('.rate-popup-container .rate-popup .reactions').html('<div><img src="assets/images/emoticon/smile.svg" class="emoticon"></div>');
            $('.feedback-group.high').show();
            
        }
        
        // Show Submit button
        $('.rate-popup .send-rate').show();
        
        // Hide No Thanks button
        $('.rate-popup .no-thanks').hide();
        
    });
    
    /* -------------------------------------------------------------- */
    // Send Rate
    /* -------------------------------------------------------------- */
    $('.rate-popup-container .rate-popup .send-rate').click(function(){
        
        var feedback = [];
        
        rateData = localStorage.getItem("rate");
        
        $(".feedback-group .item.active").each(function(){
            feedback.push( $(this).data('feedback-item') );
        });
        
        var feedbackData = JSON.stringify(feedback);
        
        $.ajax({
            type: "POST",
            url: 'process/insert_rate.php',
            
            data:{
                rateData: rateData,
                feedback:feedbackData
            },
            
            success: function(data){
                
                //localStorage.setItem("is_rate", "true");
                
                $('.rate-popup-container').hide();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Feedback Received',
                    text: 'Thank you for rating our service, your input is highly valued.',
                })
                
            }
        
        });
    });
    
    /* -------------------------------------------------------------- */
    // Close popup
    /* -------------------------------------------------------------- */
    $('.rate-popup-container .rate-popup .no-thanks').click(function(){
        $('.rate-popup-container').remove();
    });
    
    
    
});










