$(document).ready(function(){
    
    var otp = '';
    var redirect_url = '';
    
    $('.login-container .reqbtn.otp').click(function(){
        $('.login-form.emailform').hide();
        $('.login-form.otpForm').fadeIn();
        
        $('.req-icon-container .reqbtn.otp').addClass('active');
        $('.req-icon-container .reqbtn.email').removeClass('active');
    });
    
    $('.login-container .reqbtn.email').click(function(){
        $('.login-form.otpForm').hide();
        $('.login-form.emailform').fadeIn();
        
        $('.req-icon-container .reqbtn.email').addClass('active');
        $('.req-icon-container .reqbtn.otp').removeClass('active');
    });
    
    // Reset via mobile
    $(document).on('click', '.send_otp', function(){
        
        var mobile_number = $('#mobile_number').val();
        
        if( mobile_number != '' ){
        
            $.ajax({
                type: "POST",
                url: 'process/forget_otp.php',
                
                data:{
                    mobile_number: mobile_number
                },
                
                success: function(data){
                    
                    if( data.result == true ){
                        
                        otp = data.otp_number;
                        redirect_url = data.redirect_url;
                        
                        $('.button.send_otp').addClass('verify_otp');
                        $('.button.verify_otp').removeClass('send_otp');
                        $('.button.verify_otp').text('Verify OTP');
                        
                        $('#mobile_number').hide();
                        $('#otp_code').show();
                        
                    }else{
                        
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Unregistered Phone Number',
                            text: data.error_desc,
                        });
                        
                    }
                    
                }
            
            });
        
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Phone Number Required',
                text: 'Opps you seem to have submitted without entering your phone number',
            })
            
        }
         
    });
    
    // Reset via username
    $(document).on('click', '.reset_password', function(e){
        
        // Prevent the form from submitting
        e.preventDefault();
        
        // Declare Variables
        var username = $('#username').val();
        
        if( username != '' ){
            
            $.ajax({
                type: "POST",
                url: 'process/reset_password_by_username.php',
                
                data:{
                    username: username
                },
                
                success: function(data){
                    
                    Swal.fire({
                        icon: data.icon,
                        title: data.title,
                        text: data.desc,
                    });
                    
                }
            
            });
            
        }else{
            
            Swal.fire({
                icon: 'warning',
                title: 'Username Empty',
                text: 'Please enter the username first before sending a request.',
            });
            
        }
        
    });
    
    $(document).on('click', '.verify_otp', function(){
        
        var otp_code = $('#otp_code').val();
        
        if( otp_code == otp ){
            
            window.location.replace(redirect_url);
            
        }else{
            
            Swal.fire({
                icon: 'error',
                title: 'Invalid OTP',
                text: 'OTP does not match, please try again or request a new one.',
            })
            
        }
        
    });


});