$(document).ready(function(){
    
    // Global Variables
    var patient_id = $('body').data('patient-id');
    
    
    // Provider Dashboard Tab
    $('.filterBtn').click(function(){
        
        $('.filterBtn').removeClass('active');
        $(this).addClass('active');
        
    });
    
    
    // Get Recent Vitals
    function get_recent_vitals(patient_id){
        
        $.ajax({
            type: 'POST',
            url: 'process/get_recent_vitals.php',
                
            data: {
            	patient_id:patient_id
            },

            success: function(response) {
                
                // Do something
                $('table.single_user_data tbody').html(response);
                
            },
            
            fail: function(response){
            	Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
            }
        });
        
    }
    
    
    $('body').on('click', '.addVitals', function() {
        var patient_id = $(this).data('patient-id');
        $('#hidden_patient_id').val( patient_id );
    });
    
    $('body').on('click', '.popup_vitals', function() {
        $('.popup-container').fadeIn();
    });
    
    $('body').on('click', '.addVitals', function() {
        $('.popup-container').fadeIn();
    });
    
    $('body').on('click', '.popup-container .button.cancel', function() {
        $('.popup-container').fadeOut();
    });
            
    $('body').on('click', '.add_vitals', function() {
                    
        var patient_id = $('#hidden_patient_id').val();
        var systolicBP = $('#systolicBP').val();
        var diastolicBP = $('#diastolicBP').val();
        var heartRate = $('#heartRate').val();
        var respRate = $('#respRate').val();
        var pulseOX = $('#pulseOX').val();
        var temp = $('#temp').val();
        var glucose = $('#glucose').val();
        var weight = $('#weight').val();
                    
        $.ajax({
            type: 'POST',
            url: 'process/save_vital_history.php',
            
            data: {
            	patient_id:patient_id,
            	systolicBP:systolicBP,
            	diastolicBP:diastolicBP,
            	heartRate:heartRate,
            	respRate:respRate,
            	pulseOX:pulseOX,
            	temp:temp,
            	glucose:glucose,
            	weight:weight
            },
            
            beforeSend: function() {
            					
            },
            success: function(response) {
                
                $('.textbox').val();
                $('.popup-container').fadeOut();
                            
                Swal.fire({
                    icon: 'success',
                    title: 'Data Saved',
                    text: "The vitals data have been saved",
                });
                
                get_recent_vitals(patient_id);             
                                
            },	
            fail: function(response){
            	// Do Something
            }
            
        });
                     
    });
    
    // Auto Sync on load
    /*
    $.ajax({
        type: 'POST',
        url: 'process/syncvitals.php',
            
        data: {
        	patient_id:patient_id
        },
            
        beforeSend: function() {
            
            $('.syncContainer').fadeIn();
            					
        },
        
        success: function(response) {
            
            get_recent_vitals(patient_id);
            $('.syncContainer').fadeOut();
            
        },
        
        fail: function(response){
        	Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Something went wrong!',
            });
        }
            
    });
    */
    
    $('#stopTime').click(function(){
        $('#time-counter').attr('data-seconds', '0');
    });
    
    
    $('.total-time .selectbox').on('change', function (e) {

        // var patient_id = $('body').data('patient-id');
        // var optionSelected = $("option:selected", this).data('target');
        // var valueSelected = this.value;
        
        // $.get(optionSelected, function(data, status){
        //     $('.total-time span, #totalTimeData').html(data);
        // });

        // // Change data month
        // var selectedMonth = $("option:selected", this).data('month');
        // $('.print-btn.bp a').attr('data-month', selectedMonth);
        // $('.print-btn.session a').attr('data-month', selectedMonth);

        // // Update BP
        // $.get('process/update_rpm.php?type=bp&patient_id='+patient_id+'&month='+selectedMonth, function(response) {
        //     $('.bp-text').html(response);
        // });

        // // Update BP
        // $.get('process/update_rpm.php?type=session&patient_id='+patient_id+'&month='+selectedMonth, function(response) {
        //     $('.session-text').html(response);
        // });

        var patient_id = $('body').data('patient-id');
        var selectedMonth = $('.selectbox.month option:selected').val();
        var selectedYear = $('.selectbox.year option:selected').val();

        $('.print-btn.bp a').attr('data-month', selectedMonth);
        $('.print-btn.session a').attr('data-month', selectedMonth);

        $('.print-btn.bp a').attr('data-year', selectedYear);
        $('.print-btn.session a').attr('data-year', selectedYear);

        // Update BP
        $.get('process/update_rpm.php?type=bp&patient_id='+patient_id+'&month='+selectedMonth+'&year='+selectedYear, function(response) {
            $('.bp-text').html(response);
        });

        // Update BP
        $.get('process/update_rpm.php?type=session&patient_id='+patient_id+'&month='+selectedMonth+'&year='+selectedYear, function(response) {
            $('.session-text').html(response);
        });
        
        // Reload Data table via Ajax
        $.ajax({
            type: 'POST',
            url: 'process/vitals_datatable.php',
            data: {
                patient_id: patient_id,
                month: selectedMonth,
                year: selectedYear
            },
                
            success: function(response) {
                    
                var table = $('#myTable').DataTable();

                if (response.length > 0) {
                    table.clear().rows.add(response).draw();
                } else {
                    table.clear().draw();
                }
                    
            },
                    
        });
        
    });
    
    
    /* Show Billing Codes */
    $('.popup_billing_codes').click(function(){
        $('.billing-code-popup').css("display", "flex");
    });
    
    // Close Button
    $('.billing-code-popup .close').click(function(){
        $('.billing-code-popup').fadeOut();
    });
    
    // Submit CPT codes
    $('.billing-code-popup .button').click(function(){
        
        var cpt_codes = [];
        var patient_id = $('body').data('patient-id');
        var user_type = $('body').data('user-type');
        
        if( user_type == 'nurse' ){
            var provider_id = $('body').data('nurse-id');
        }else if( user_type == 'doctor' ){
            var provider_id = $('body').data('physician-id');
        }
        
        $(".billing-code-popup .checkbox").each(function(){
            
            if( $(this).is(':checked') === true ){
                cpt_codes.push( $(this).val() );
            }
            
        });
        
        var sendData = {
            "user_type" : user_type,
            "provider_id" : provider_id,
            "patient_id" : patient_id,
            "cpt_code" : cpt_codes
        };
        
        $.ajax({
            type: 'POST',
            url: 'process/submit_cpt_code.php',
            data: JSON.stringify(sendData),
            contentType: "application/json; charset=utf-8",
            dataType: "json",
                
            beforeSend: function() {
                    					
            },
                
            success: function(response) {
                    
                $('.billing-code-popup').hide();
                    
                if( response.result === true ){
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: 'CPT code sent',
                    });
                }else{
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Something went wrong!',
                    });
                }
                    
            },
                
            fail: function(response){
                    
                $('.billing-code-popup').hide();
                    
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
                    
            }
                    
        });
        
    });
    
    

    // Create the note
    $('.popup_new_notes').click(function(){
        
        var cctype = $('body').data('cctype');
        var NoteTitle = '';
        
        if( cctype == 'rpm' ){
            NoteTitle = 'RPM Note';
        }else if( cctype == 'cpm' ){
            NoteTitle = 'CPM Note';
        }
        
        $('body').prepend('<div class="floating-notes rpm-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+NoteTitle+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea><div class="status"></div></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    // Note PLUS Button
    $('body').on('click', '.floating-notes .add', function() {
        
        if( cctype == 'rpm' ){
            NoteTitle = 'RPM Note';
        }else if( cctype == 'cpm' ){
            NoteTitle = 'CPM Note';
        }
        
        $('body').prepend('<div class="floating-notes rpm-notes"><div class="notes-bar"><img src="assets/images/note-add.png" class="add"><img src="assets/images/note-save.png" class="save"><img src="assets/images/note-close.png" class="close"></div><input type="text" class="resizable-title-bar" placeholder="Enter Note Title" value="'+NoteTitle+'"><textarea class="resizable-editor" placeholder="Start Typing Notes here..."></textarea><div class="status"></div></div>');
        
        // Resizable
        $( ".floating-notes" ).resizable({
           //alsoResize: ".resizable-editor"
        });
        
        // Drag and drop
        $( ".floating-notes" ).draggable();
        
    });
    
    // Close Button
    $('body').on('click', '.floating-notes .close', function() {
        
        $(this).parent().parent().remove();
        
    });
    
    
    // Save notes for RPM
    $('body').on('click', '.floating-notes.rpm-notes .save', function(){
        
        var user_type = $('body').data('user-type');
        
        var provider_id = '';
        if( user_type == 'doctor' ){
            provider_id = $('body').data('physician-id');
        }else if( user_type == 'nurse' ){
            provider_id = $('body').data('nurse-id');
        }
        
        var save_type = 'new';
        var note_type = $('body').data('cctype');
        var created_by = provider_id;
        var patient_id = $('body').data('patient-id');
        var note_title = $('.resizable-title-bar').val();
        var note_text = $('.resizable-editor').val();
        
        $.ajax({
            type: "POST",
            url: 'process/save_note.php',
            
            data:{
                patient_id:patient_id,
                save_type: save_type,
                note_type: note_type,
                created_by : created_by,
                note_title: note_title,
                note_text: note_text
            },
            
            success: function(data){
                
                //$('.floating-notes .status').html('<div class="saved">Note Saved</div>');
                $('.floating-notes').remove();
            },
            
            fail: function(response){
            
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                });
                        
            }
        
        });
        
    });
    
    
    // Yes/No CCM Button
    $('body').on('click', '.toggle', function(){
        
        var answer = '';
        var patient_id = $(this).data('patient-id');
        
        if( $(this).hasClass('yes') === true ){
            
            answer = 'no';
            
            Swal.fire({
                title: 'Agreement',
                text: "I certify that patient do not want to continue the CCM program.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Agree'
            }).then((result) => {
                if (result.isConfirmed) {
                    
                    $('#ccm_id_'+patient_id).removeClass('yes');
                    $('#ccm_id_'+patient_id).addClass('no');
                    
                }
            });
            
            
        }else if( $(this).hasClass('no') === true ){
            
            answer = 'yes';
            
            Swal.fire({
                title: 'Agreement',
                text: "I certify that the patient have multiple (two or more) chronic conditions expected to last at least 12 months and I have obtained verbal consent prior to enrolling the patient into the CCM program.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Agree'
            }).then((result) => {
                if (result.isConfirmed) {
                    
                    $('#ccm_id_'+patient_id).removeClass('no');
                    $('#ccm_id_'+patient_id).addClass('yes');
                    
                }
            });
            
        }
        

        $.ajax({
            type: "POST",
            url: 'process/save_ccm.php',
            
            data:{
                patient_id:patient_id,
                answer: answer,
            },
            
            success: function(data){
                
            },
            
            fail: function(response){
            
                Swal.fire({
                    icon: 'success',
                    title: 'Saved',
                    text: 'CCM Saved',
                });
                        
            }
        
        });
        
    });
    
    
    // Redirect On Click
    // $('body').on('click', '#myTable tbody tr td.enabled', function() {
    //     var patientId = $(this).parent().data('patient-id');
    //     window.location.replace("patient_vitals.php?patient_id="+patientId+"&cctype=rpm");
    // });
    
    
    $('body').on('click', '#myTable tbody tr', function() {
        
        // Register patiend ID into variable
        var table_patient_id = $(this).attr('id');
        
        // Add Highlight Class
        $(this).addClass('highlighted');
        
        var patientArray = [];
        
        $("#myTable tbody tr").each(function(){
            if( $(this).hasClass("highlighted") ){
                patientArray.push($(this).attr('id'));
            }
        });
        
        var patientOBJ = JSON.stringify(patientArray);
        
        // Store in cookie
        Cookies.set('highlightHistory', patientOBJ, { expires: 7 });
        
    });
    
    // RPM Dashboard, double click user table goes RPM data
    $("body.rpm-dashboard #myTable tbody tr td.enabled").dblclick(function(){
        
        // Register patiend ID into variable
        var table_patient_id = $(this).parent().attr('data-patient-id');
        
        window.location.href = "patient_vitals.php?patient_id="+table_patient_id+"&cctype=rpm";
        
    });
    
    // RPM Dashboard, click user table goes RPM data
    $("body.rpm-dashboard #myTable tbody tr td.enabled").click(function(){
        
        // Register patiend ID into variable
        var table_patient_id = $(this).parent().attr('data-patient-id');
        
        window.location.href = "patient_vitals.php?patient_id="+table_patient_id+"&cctype=rpm";
        
    });
    
    
    // 20 minute Dashboard, click user table goes RPM data
    $('body.twenty-minute-dashboard').on('click', 'table.dataTable tbody tr', function(){
        var patient_id = $(this).attr('id');
        window.location.href = 'patient_vitals.php?patient_id='+patient_id+'&cctype=rpm';
    });
    
    // Critical Vitals Dashboard, click user table goes RPM data
    $("body.critical-dashboard #myTable tbody tr").click(function(){
        
        // Register patiend ID into variable
        var table_patient_id = $(this).attr('data-patient-id');
        
        window.location.href = "patient_vitals.php?patient_id="+table_patient_id+"&cctype=rpm";
        
    });
    
    
    // Highlight all clicked entries from cookies
    if( document.cookie.indexOf("highlightHistory=") > 0) {
        var highlightJson = Cookies.get('highlightHistory');
        var highlightArray = JSON.parse(highlightJson);
        
        for (let i = 0; i < highlightArray.length; ++i) {
            $('#'+highlightArray[i]).addClass('highlighted');
            $('.'+highlightArray[i]).addClass('highlighted');
        }
    }
    
    
    /* --------------------------------------------------------------- */
    // Billing Filter
    /* --------------------------------------------------------------- */
    
    $(document).on('change','.filterSelect',function(){
        
        var selectedFilter = $('.filterSelect :selected').val();
        
        if( selectedFilter <= 12 ){
            
            $('.range-group').removeClass('show');
            
        }else if( selectedFilter == 'custom' ){
            
            $('.range-group').addClass('show');
            
        }else{
            
            $('.range-group').removeClass('show');
            
        }
        
    });
    
    
    /* --------------------------------------------------------------- */
    // Add Manual Timer
    /* --------------------------------------------------------------- */
   /* Show Billing Codes */
    $('.manualTimerBtn').click(function(){
        $('.manual-timer-popup').css("display", "flex");
    });
    
    // Close Button
    $('.manual-timer-popup .close').click(function(){
        $('.manual-timer-popup').fadeOut();
    });
   
    // Submit CPT codes
    $('.manual-timer-popup .btn').click(function(){
        
        var user_type = $('body').data('user-type');
        var cctype = $('body').data('cctype');
        var patient_id = $('body').data('patient-id');
        var mm = $('.min').val();
        var ss = $('.sec').val();
        
        if( user_type == 'nurse' ){
            
            var provider_type = 'nurse';
            var provider_id = $('body').data('nurse-id');
            
        }else if( user_type == 'doctor' ){
            
            var provider_type = 'doctor';
            var provider_id = $('body').data('physician-id');
            
        }
        
        if( mm != '' && ss != '' ){
        
            $.ajax({
                type: 'POST',
                url: 'process/submit_manual_time.php',
                data:{
                    cctype: cctype,
                    provider_id: provider_id,
                    provider_type:provider_type,
                    patient_id : patient_id,
                    mm : mm,
                    ss : ss
                },
                beforeSend: function() {
                        					
                },
                    
                success: function(response) {
                        
                    $('.billing-code-popup').hide();
                        
                    if( response.result === true ){
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Time Added',
                            text: 'Manual time added',
                        });
                        
                        $('.manual-timer-popup').fadeOut();
                        $('.min').val('');
                        $('.sec').val('');
                        
                    }else{
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Something went wrong!',
                        });
                    }
                        
                }
                        
            });
        
        }else{
            
            Swal.fire({
                icon: "error",
                title: "Time Field Empty",
                text: "Both the seconds and minutes field cannot be empty at the same time, please fill up atleast 1 before submitting.",
            });
            
        }
        
    });
   
   
    // RPM Assigned Nurse Filter
    $('.assigned-filter.main').change(function(){
        
        var selectedFilter = $(this).find(":selected").val();
        
        window.location.replace("vitals_dashboard.php?filter=" + selectedFilter);
        
    });
   
    // Assign Patient to Nurse
    $('.assigned-filter.basic').change(function(){
        
        var nurseID = $(this).find(":selected").val();
        var patientID = $(this).parent().parent().attr('data-patient-id');
        
        $.ajax({
            type: 'POST',
            url: 'process/assign-to-nurse.php',
            data:{
                nurseID: nurseID,
                patientID: patientID
            },
                
            success: function(response) {
                
                if( response.result == true ){
                    
                    Swal.fire({
                        position: 'bottom-end',
                        icon: 'success',
                        title: 'Nurse has been assign to patient',
                        showConfirmButton: false,
                        timer: 1500
                    });
                    
                }else{
                    
                    Swal.fire({
                        position: 'bottom-end',
                        icon: 'error',
                        title: 'Something went wrong, please try agan!',
                        showConfirmButton: false,
                        timer: 1500
                    });
                    
                }
                
            }
        });
        
    });
   
   
    // Print Button for RPM
    $('.print-btn.bp a').click(function(e){

        // Prevent default
        e.preventDefault();

        var patient_id = $(this).data('patient-id');
        var month = $(this).data('month');
        var year = $(this).data('year');

        var redirectURL = 'rpm-pdf.php?patient_id='+patient_id+'&month='+month+'&year='+year;

        window.location.href = redirectURL;

    });

    // Print Button for Timer
    $('.print-btn.session a').click(function(e){

        // Prevent default
        e.preventDefault();

        var patient_id = $(this).data('patient-id');
        var month = $(this).data('month');
        var year = $(this).data('year');

        var redirectURL = 'timer-pdf.php?patient_id='+patient_id+'&month='+month+'&year='+year;

        window.location.href = redirectURL;

    });
   
   
   
   
   
    
    
});